/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.villagercomfort.core.mixin;

import dev.ghen.villagercomfort.comfort.BedroomComfortValues;
import dev.ghen.villagercomfort.comfort.ComfortHelper;
import dev.ghen.villagercomfort.comfort.WorkplaceComfortValues;
import dev.ghen.villagercomfort.common.capabilty.ModCapabilities;
import dev.ghen.villagercomfort.core.config.CommonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.LightLayer;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Villager.class})
public class VillagerMixin {
    @Shadow
    @Final
    private static Logger f_201976_;

    @Inject(method={"startSleeping"}, at={@At(value="HEAD")})
    private void scanBedroomComfortValues(BlockPos pos, CallbackInfo ci) {
        Villager villager = (Villager)this;
        villager.getCapability(ModCapabilities.COMFORT_VALUES_CAP).ifPresent(cap -> {
            BedroomComfortValues.setValuesToCap(villager, pos, cap);
            cap.addDaysWithoutZombie(1);
            if (cap.getOutsideSeconds() < ((Number)CommonConfig.AVERAGE_TIME_OUTSIDE.get()).intValue()) {
                cap.addDaysWithoutOutside(1);
            } else {
                cap.setDaysWithoutOutside(0);
            }
            cap.setOutsideSeconds(0);
            cap.setHasBed(true);
            if (cap.hasWorkplace()) {
                cap.setHasWorkplace(villager.m_6274_().m_21874_(MemoryModuleType.f_26360_));
            }
        });
    }

    @Inject(method={"playWorkSound"}, at={@At(value="HEAD")})
    private void scanWorkstationComfortValues(CallbackInfo ci) {
        Villager villager = (Villager)this;
        villager.getCapability(ModCapabilities.COMFORT_VALUES_CAP).ifPresent(cap -> {
            WorkplaceComfortValues.setValuesToCap(villager, cap);
            if (!cap.hasWorkplace()) {
                cap.setHasWorkplace(true);
            }
        });
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void checkSunlightTick(CallbackInfo ci) {
        Villager villager = (Villager)this;
        if (!villager.f_19853_.m_5776_() && villager.f_19797_ % 20 == 0) {
            villager.getCapability(ModCapabilities.COMFORT_VALUES_CAP).ifPresent(cap -> {
                if (villager.f_19853_.m_45517_(LightLayer.SKY, villager.m_142538_()) > 12) {
                    cap.addOutsideSeconds(1);
                }
                if (villager.m_6274_().m_21954_(Activity.f_37984_) && cap.getDaysWithoutZombie() > 0) {
                    cap.setDaysWithoutZombie(0);
                }
            });
        }
    }

    @Inject(method={"updateSpecialPrices"}, at={@At(value="TAIL")})
    private void setComfortModifiers(Player player, CallbackInfo ci) {
        Villager villager = (Villager)this;
        villager.getCapability(ModCapabilities.COMFORT_VALUES_CAP).ifPresent(cap -> {
            for (MerchantOffer merchantOffer : villager.m_6616_()) {
                merchantOffer.m_45353_(ComfortHelper.calculatePriceModifier(villager, cap, merchantOffer.m_45352_().m_41613_()));
            }
        });
    }
}

