/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.client.gui.screens.inventory;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ServerConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.enchantment.EnchantmentInstance;

public class ModEnchantmentScreen
extends EnchantmentScreen {
    private static final Component REROLL_ENCHANTMENTS_TOOLTIP = new TranslatableComponent("container.enchant.reroll").m_130940_(ChatFormatting.GRAY);
    private final List<List<EnchantmentInstance>> slotData = IntStream.range(0, 3).mapToObj(i -> Lists.newArrayList()).collect(Collectors.toList());

    public ModEnchantmentScreen(EnchantmentMenu container, Inventory playerInventory, Component textComponent) {
        super(container, playerInventory, textComponent);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (((ServerConfig)EasyMagic.CONFIG.server()).rerollEnchantments == ServerConfig.ReRollEnchantments.WITH_COST) {
            int startX = this.f_97735_ + 15;
            int startY = this.f_97736_ + 14;
            if ((double)startX <= mouseX && mouseX < (double)(startX + 36) && (double)startY <= mouseY && mouseY < (double)(startY + 31) && ((EnchantmentMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, 4)) {
                this.f_96541_.f_91072_.m_105208_(((EnchantmentMenu)this.f_97732_).f_38840_, 4);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        int slot = this.getEnchantingSlot(mouseX, mouseY);
        if (slot != -1) {
            if (!this.slotData.get(slot).isEmpty()) {
                ArrayList tooltip = Lists.newArrayList();
                this.addSlotEnchantments(slot, this.slotData.get(slot), tooltip);
                this.m_96597_(matrixStack, tooltip, mouseX, mouseY);
            }
        } else if (((ServerConfig)EasyMagic.CONFIG.server()).rerollEnchantments == ServerConfig.ReRollEnchantments.WITH_COST) {
            int startX = this.f_97735_ + 15;
            int startY = this.f_97736_ + 14;
            if (startX <= mouseX && mouseX < startX + 36 && startY <= mouseY && mouseY < startY + 31) {
                ArrayList tooltip = Lists.newArrayList();
                this.addRerollTooltipInfo(tooltip);
                this.m_96597_(matrixStack, tooltip, mouseX, mouseY);
            }
        }
    }

    protected boolean m_6774_(int x, int y, int width, int height, double mouseX, double mouseY) {
        if (this.getSelectedSlot(mouseX, mouseY) != null) {
            return super.m_6774_(x, y, width, height, mouseX, mouseY);
        }
        return false;
    }

    @Nullable
    private Slot getSelectedSlot(double mouseX, double mouseY) {
        for (int i = 0; i < ((EnchantmentMenu)this.f_97732_).f_38839_.size(); ++i) {
            Slot slot = (Slot)((EnchantmentMenu)this.f_97732_).f_38839_.get(i);
            if (!this.isSlotSelected(slot, mouseX, mouseY) || !slot.m_6659_()) continue;
            return slot;
        }
        return null;
    }

    private boolean isSlotSelected(Slot slotIn, double mouseX, double mouseY) {
        return super.m_6774_(slotIn.f_40220_, slotIn.f_40221_, 16, 16, mouseX, mouseY);
    }

    private int getEnchantingSlot(int mouseX, int mouseY) {
        for (int j = 0; j < 3; ++j) {
            int levels = ((EnchantmentMenu)this.f_97732_).f_39446_[j];
            if (!super.m_6774_(60, 14 + 19 * j, 108, 17, (double)mouseX, (double)mouseY) || levels <= 0) continue;
            return j;
        }
        return -1;
    }

    public void setSlotData(int slot, List<EnchantmentInstance> data) {
        this.slotData.set(slot, data);
    }

    private void addSlotEnchantments(int slot, List<EnchantmentInstance> slotData, List<Component> slotTooltip) {
        boolean hasValidEnchantment = slotData.isEmpty();
        for (EnchantmentInstance data : slotData) {
            if (data.f_44947_ == null) continue;
            slotTooltip.add((Component)new TranslatableComponent("container.enchant.clue", new Object[]{data.f_44947_.m_44700_(data.f_44948_)}).m_130940_(ChatFormatting.GRAY));
            hasValidEnchantment = true;
        }
        this.addSlotInfo(slot, slotTooltip, hasValidEnchantment);
    }

    private void addSlotInfo(int slot, List<Component> slotTooltip, boolean hasValidEnchantment) {
        ArrayList additionalTooltip = Lists.newArrayList();
        if (!hasValidEnchantment) {
            additionalTooltip.add(new TranslatableComponent("forge.container.enchant.limitedEnchantability").m_130940_(ChatFormatting.RED));
        } else if (!this.f_96541_.f_91074_.m_150110_().f_35937_) {
            int enchantLevels = ((EnchantmentMenu)this.f_97732_).f_39446_[slot];
            if (this.f_96541_.f_91074_.f_36078_ < enchantLevels) {
                additionalTooltip.add(new TranslatableComponent("container.enchant.level.requirement", new Object[]{enchantLevels}).m_130940_(ChatFormatting.RED));
            } else {
                this.addLapisComponent(++slot, additionalTooltip);
                this.addLevelComponent(slot, additionalTooltip);
            }
        }
        if (!additionalTooltip.isEmpty()) {
            if (!slotTooltip.isEmpty()) {
                slotTooltip.add(TextComponent.f_131282_);
            }
            slotTooltip.addAll(additionalTooltip);
        }
    }

    private void addLapisComponent(int amount, List<Component> tooltip) {
        TranslatableComponent component = amount == 1 ? new TranslatableComponent("container.enchant.lapis.one") : new TranslatableComponent("container.enchant.lapis.many", new Object[]{amount});
        tooltip.add((Component)component.m_130940_(((EnchantmentMenu)this.f_97732_).m_39492_() >= amount ? ChatFormatting.GRAY : ChatFormatting.RED));
    }

    private void addLevelComponent(int amount, List<Component> tooltip) {
        TranslatableComponent component = amount == 1 ? new TranslatableComponent("container.enchant.level.one") : new TranslatableComponent("container.enchant.level.many", new Object[]{amount});
        tooltip.add((Component)component.m_130940_(this.f_96541_.f_91074_.f_36078_ >= amount ? ChatFormatting.GRAY : ChatFormatting.RED));
    }

    private void addRerollTooltipInfo(List<Component> tooltip) {
        tooltip.add(REROLL_ENCHANTMENTS_TOOLTIP);
        ArrayList additionalTooltip = Lists.newArrayList();
        if (!this.f_96541_.f_91074_.m_150110_().f_35937_) {
            if (((ServerConfig)EasyMagic.CONFIG.server()).rerollLapisCost > 0) {
                this.addLapisComponent(((ServerConfig)EasyMagic.CONFIG.server()).rerollLapisCost, additionalTooltip);
            }
            if (((ServerConfig)EasyMagic.CONFIG.server()).rerollLevelCost > 0) {
                this.addLevelComponent(((ServerConfig)EasyMagic.CONFIG.server()).rerollLevelCost, additionalTooltip);
            }
        }
        if (!additionalTooltip.isEmpty()) {
            tooltip.add(TextComponent.f_131282_);
            tooltip.addAll(additionalTooltip);
        }
    }
}

