/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;

public class TwittollagerEntity
extends AbstractIllager {
    private static final EntityDataAccessor<Boolean> ANGRY = SynchedEntityData.m_135353_(TwittollagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> STARING = SynchedEntityData.m_135353_(TwittollagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> PHONE_DINGED = SynchedEntityData.m_135353_(TwittollagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HMM = SynchedEntityData.m_135353_(TwittollagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CHECKING_PHONE = SynchedEntityData.m_135353_(TwittollagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> GRRRRRRRRRRRRR_TICKS = SynchedEntityData.m_135353_(TwittollagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CAN_CHARGE = SynchedEntityData.m_135353_(TwittollagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> EXPLODE = SynchedEntityData.m_135353_(TwittollagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int checkPhoneTicks;
    private int waitTime;

    public TwittollagerEntity(EntityType<? extends AbstractIllager> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new ChargeAtTargetGoal());
        this.f_21345_.m_25352_(0, (Goal)new StareAggressivelyGoal());
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, GlowSquid.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Sheep.class, 10, false, false, p_234199_0_ -> p_234199_0_ instanceof Sheep && ((Sheep)p_234199_0_).m_29874_() == DyeColor.PINK));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{TwittollagerEntity.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, 10, false, false, p_234199_0_ -> p_234199_0_ instanceof Villager && ((Villager)p_234199_0_).m_146764_() < 0));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANGRY, (Object)false);
        this.f_19804_.m_135372_(STARING, (Object)false);
        this.f_19804_.m_135372_(PHONE_DINGED, (Object)false);
        this.f_19804_.m_135372_(HMM, (Object)false);
        this.f_19804_.m_135372_(CHECKING_PHONE, (Object)false);
        this.f_19804_.m_135372_(GRRRRRRRRRRRRR_TICKS, (Object)0);
        this.f_19804_.m_135372_(CAN_CHARGE, (Object)false);
        this.f_19804_.m_135372_(EXPLODE, (Object)false);
    }

    public boolean m_6779_(LivingEntity p_186270_) {
        return p_186270_ instanceof Player && this.f_19853_.m_46791_() == Difficulty.PEACEFUL ? false : p_186270_.m_142066_();
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_5448_() instanceof GlowSquid && !this.isAngry()) {
            this.checkPhoneTicks = 115;
            if (!this.f_19853_.f_46443_) {
                this.setAngry(true);
            }
            this.m_5496_(IllageAndSpillageSoundEvents.ENTITY_TWITTOLLAGER_ANGRY, 2.0f, 1.0f);
        }
        if (this.m_5448_() instanceof Sheep && ((Sheep)this.m_5448_()).m_29874_() == DyeColor.PINK && !this.isAngry()) {
            this.checkPhoneTicks = 115;
            if (!this.f_19853_.f_46443_) {
                this.setAngry(true);
            }
            this.m_5496_(IllageAndSpillageSoundEvents.ENTITY_TWITTOLLAGER_ANGRY, 2.0f, 1.0f);
        }
        if (this.m_5448_() instanceof Villager && ((Villager)this.m_5448_()).m_146764_() < 0 && !this.isAngry()) {
            this.checkPhoneTicks = 115;
            if (!this.f_19853_.f_46443_) {
                this.setAngry(true);
            }
            this.m_5496_(IllageAndSpillageSoundEvents.ENTITY_TWITTOLLAGER_ANGRY, 2.0f, 1.0f);
        }
        if (this.isStaring()) {
            ++this.waitTime;
            if (this.waitTime > 60 && this.f_19796_.nextInt(25) == 0 && !this.hasPhoneDinged() && !this.isAngry()) {
                this.m_5496_(IllageAndSpillageSoundEvents.ENTITY_TWITTOLLAGER_DING, 1.0f, 1.0f);
                this.setPhoneDinged(true);
            }
        }
        if (this.hasPhoneDinged() || this.isAngry()) {
            ++this.checkPhoneTicks;
            if (!this.isAngry()) {
                if (this.checkPhoneTicks == 15) {
                    this.m_5496_(IllageAndSpillageSoundEvents.ENTITY_TWITTOLLAGER_HMM, 1.0f, 1.0f);
                    if (!this.f_19853_.f_46443_) {
                        this.setHmm(true);
                    }
                }
                if (this.checkPhoneTicks == 35 && !this.f_19853_.f_46443_) {
                    this.setCheckingPhone(true);
                }
                if (this.checkPhoneTicks == 115) {
                    if (!this.f_19853_.f_46443_) {
                        this.setAngry(true);
                    }
                    this.m_5496_(IllageAndSpillageSoundEvents.ENTITY_TWITTOLLAGER_ANGRY, 2.0f, 1.0f);
                }
            }
        }
        if (this.isAngry()) {
            if (!this.f_19853_.f_46443_ && this.getGRRRRRRRRRR() < 60) {
                this.setGRRRRRRRRRRRRRR(this.getGRRRRRRRRRR() + 1);
            }
            if (this.checkPhoneTicks == 184) {
                this.setCanCharge(true);
                if (!this.f_19853_.f_46443_) {
                    this.setCheckingPhone(false);
                }
            }
        }
    }

    public boolean m_6469_(DamageSource p_37849_, float p_37850_) {
        if (p_37849_.m_19372_() && p_37849_.m_7639_() instanceof TwittollagerEntity) {
            return false;
        }
        if (p_37849_.m_7639_() != null && !this.isAngry()) {
            this.checkPhoneTicks = 115;
            if (!this.f_19853_.f_46443_) {
                this.setAngry(true);
            }
            this.m_5496_(IllageAndSpillageSoundEvents.ENTITY_TWITTOLLAGER_ANGRY, 2.0f, 1.0f);
        }
        return super.m_6469_(p_37849_, p_37850_);
    }

    public boolean m_7490_() {
        return false;
    }

    public SoundEvent m_7930_() {
        return IllageAndSpillageSoundEvents.ENTITY_TWITTOLLAGER_CELEBRATE;
    }

    protected SoundEvent m_7515_() {
        if (this.hasPhoneDinged() || this.isAngry()) {
            return null;
        }
        return IllageAndSpillageSoundEvents.ENTITY_TWITTOLLAGER_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return IllageAndSpillageSoundEvents.ENTITY_TWITTOLLAGER_HURT;
    }

    protected SoundEvent m_5592_() {
        if (this.isExplode()) {
            return null;
        }
        return IllageAndSpillageSoundEvents.ENTITY_TWITTOLLAGER_DEATH;
    }

    public boolean isAngry() {
        return (Boolean)this.f_19804_.m_135370_(ANGRY);
    }

    public void setAngry(boolean angry) {
        this.f_19804_.m_135381_(ANGRY, (Object)angry);
    }

    public boolean isStaring() {
        return (Boolean)this.f_19804_.m_135370_(STARING);
    }

    public void setStaring(boolean angry) {
        this.f_19804_.m_135381_(STARING, (Object)angry);
    }

    public boolean hasPhoneDinged() {
        return (Boolean)this.f_19804_.m_135370_(PHONE_DINGED);
    }

    public void setPhoneDinged(boolean ding) {
        this.f_19804_.m_135381_(PHONE_DINGED, (Object)ding);
    }

    public boolean isHmm() {
        return (Boolean)this.f_19804_.m_135370_(HMM);
    }

    public void setHmm(boolean hmm) {
        this.f_19804_.m_135381_(HMM, (Object)hmm);
    }

    public boolean isCheckingPhone() {
        return (Boolean)this.f_19804_.m_135370_(CHECKING_PHONE);
    }

    public void setCheckingPhone(boolean check) {
        this.f_19804_.m_135381_(CHECKING_PHONE, (Object)check);
    }

    public int getGRRRRRRRRRR() {
        return (Integer)this.f_19804_.m_135370_(GRRRRRRRRRRRRR_TICKS);
    }

    public void setGRRRRRRRRRRRRRR(int grrrrr) {
        this.f_19804_.m_135381_(GRRRRRRRRRRRRR_TICKS, (Object)grrrrr);
    }

    public boolean canCharge() {
        return (Boolean)this.f_19804_.m_135370_(CAN_CHARGE);
    }

    public void setCanCharge(boolean charge) {
        this.f_19804_.m_135381_(CAN_CHARGE, (Object)charge);
    }

    public boolean isExplode() {
        return (Boolean)this.f_19804_.m_135370_(EXPLODE);
    }

    public void setExplode(boolean boom) {
        this.f_19804_.m_135381_(EXPLODE, (Object)boom);
    }

    public boolean m_7327_(Entity p_70652_1_) {
        return false;
    }

    private void explode() {
        this.setExplode(true);
        this.m_5496_(IllageAndSpillageSoundEvents.ENTITY_TWITTOLLAGER_EXPLODE, 6.0f, 1.0f);
        this.m_5496_(IllageAndSpillageSoundEvents.ENTITY_TWITTOLLAGER_SCREAM, 6.0f, 1.0f);
        this.m_6469_(DamageSource.f_19317_, Float.MAX_VALUE);
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Explosion.BlockInteraction.NONE);
        }
    }

    public void m_6667_(DamageSource p_37847_) {
        if (this.isExplode()) {
            this.f_20919_ = 19;
        }
        super.m_6667_(p_37847_);
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 60) {
            if (this.isExplode()) {
                this.makeExplodeParticles();
            } else {
                super.m_7822_(p_21375_);
            }
        } else {
            super.m_7822_(p_21375_);
        }
    }

    public void makeExplodeParticles() {
        double d2;
        double d1;
        double d0;
        int i;
        for (i = 0; i < 250; ++i) {
            d0 = (-0.5 + this.f_19796_.nextGaussian()) / 2.0;
            d1 = (-0.5 + this.f_19796_.nextGaussian()) / 2.0;
            d2 = (-0.5 + this.f_19796_.nextGaussian()) / 2.0;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123777_, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d0, d1, d2);
        }
        for (i = 0; i < 200; ++i) {
            d0 = (-0.5 + this.f_19796_.nextGaussian()) / 2.0;
            d1 = (-0.5 + this.f_19796_.nextGaussian()) / 2.0;
            d2 = (-0.5 + this.f_19796_.nextGaussian()) / 2.0;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d0, d1, d2);
        }
        for (i = 0; i < 150; ++i) {
            d0 = (-0.5 + this.f_19796_.nextGaussian()) / 2.0;
            d1 = (-0.5 + this.f_19796_.nextGaussian()) / 2.0;
            d2 = (-0.5 + this.f_19796_.nextGaussian()) / 2.0;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d0, d1, d2);
        }
        for (i = 0; i < 75; ++i) {
            double random = (-0.5 + this.f_19796_.nextDouble()) / 2.0;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123778_, this.m_20185_() - 2.0 + random, this.m_20186_() + 1.0 + random, this.m_20189_() + random, 0.0, 0.14, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123778_, this.m_20185_() + 2.0 + random, this.m_20186_() + 1.0 + random, this.m_20189_() + random, 0.0, 0.14, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123778_, this.m_20185_() - 1.0 + random, this.m_20186_() + 2.0 + random, this.m_20189_() + random, 0.0, 0.14, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123778_, this.m_20185_() + 1.0 + random, this.m_20186_() + 2.0 + random, this.m_20189_() + random, 0.0, 0.14, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123778_, this.m_20185_() + 0.0 + random, this.m_20186_() + 2.0 + random, this.m_20189_() + random, 0.0, 0.14, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123778_, this.m_20185_() - 2.0 + random, this.m_20186_() + 5.0 + random, this.m_20189_() + random, 0.0, 0.14, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123778_, this.m_20185_() + 2.0 + random, this.m_20186_() + 5.0 + random, this.m_20189_() + random, 0.0, 0.14, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123778_, this.m_20185_() - 1.0 + random, this.m_20186_() + 4.0 + random, this.m_20189_() + random, 0.0, 0.14, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123778_, this.m_20185_() + 1.0 + random, this.m_20186_() + 4.0 + random, this.m_20189_() + random, 0.0, 0.14, 0.0);
        }
    }

    class ChargeAtTargetGoal
    extends Goal {
        public ChargeAtTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return TwittollagerEntity.this.m_5448_() != null && TwittollagerEntity.this.m_142582_((Entity)TwittollagerEntity.this.m_5448_()) && TwittollagerEntity.this.canCharge();
        }

        public void m_8056_() {
            TwittollagerEntity.this.m_5496_(IllageAndSpillageSoundEvents.ENTITY_TWITTOLLAGER_CHARGE, 2.0f, 1.0f);
        }

        public boolean m_8045_() {
            return TwittollagerEntity.this.m_5448_() != null && TwittollagerEntity.this.m_142582_((Entity)TwittollagerEntity.this.m_5448_());
        }

        public void m_8037_() {
            if (TwittollagerEntity.this.m_5448_() != null) {
                TwittollagerEntity.this.m_21573_().m_5624_((Entity)TwittollagerEntity.this.m_5448_(), 2.5);
                TwittollagerEntity.this.m_21563_().m_24960_((Entity)TwittollagerEntity.this.m_5448_(), 30.0f, 30.0f);
                TwittollagerEntity.this.f_21344_.m_5624_((Entity)TwittollagerEntity.this.m_5448_(), 2.5);
                if (TwittollagerEntity.this.m_20280_((Entity)TwittollagerEntity.this.m_5448_()) < 4.5) {
                    TwittollagerEntity.this.explode();
                }
            }
        }

        public void m_8041_() {
            TwittollagerEntity.this.m_21573_().m_26573_();
            TwittollagerEntity.this.f_21344_.m_26573_();
        }
    }

    class StareAggressivelyGoal
    extends Goal {
        public StareAggressivelyGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return TwittollagerEntity.this.m_5448_() != null && TwittollagerEntity.this.m_20280_((Entity)TwittollagerEntity.this.m_5448_()) < 150.0 && TwittollagerEntity.this.m_142582_((Entity)TwittollagerEntity.this.m_5448_()) && !TwittollagerEntity.this.canCharge();
        }

        public void m_8056_() {
            TwittollagerEntity.this.setStaring(true);
        }

        public boolean m_8045_() {
            return (TwittollagerEntity.this.m_5448_() != null && TwittollagerEntity.this.m_20280_((Entity)TwittollagerEntity.this.m_5448_()) < 150.0 && TwittollagerEntity.this.m_5448_().m_6084_() && TwittollagerEntity.this.m_142582_((Entity)TwittollagerEntity.this.m_5448_()) || TwittollagerEntity.this.hasPhoneDinged()) && !TwittollagerEntity.this.canCharge();
        }

        public void m_8037_() {
            TwittollagerEntity.this.m_21573_().m_26573_();
            if (TwittollagerEntity.this.checkPhoneTicks < 30 || !TwittollagerEntity.this.hasPhoneDinged()) {
                if (TwittollagerEntity.this.m_5448_() != null) {
                    TwittollagerEntity.this.m_21563_().m_24960_((Entity)TwittollagerEntity.this.m_5448_(), 30.0f, 30.0f);
                }
            } else {
                TwittollagerEntity.this.m_21563_().m_24950_(TwittollagerEntity.this.m_20185_(), TwittollagerEntity.this.m_20186_(), TwittollagerEntity.this.m_20189_(), 30.0f, 30.0f);
            }
            TwittollagerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            TwittollagerEntity.this.setStaring(false);
        }
    }
}

