/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.entities.projectile.IgniterFireballEntity;
import com.yellowbrossproductions.illageandspillage.util.EntityUtil;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.EnumSet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;

public class IgniterEntity
extends AbstractIllager {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(IgniterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TORCH_BURNT_OUT = SynchedEntityData.m_135353_(IgniterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int shootTicks;
    private int fireballsShot;
    private int fireballTimer;
    private int cooldownTicks;

    public IgniterEntity(EntityType<? extends AbstractIllager> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new ShootFireballsGoal());
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.8, 1.0, p_234199_0_ -> this.shouldRunLikeCrazy()));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, IronGolem.class, 8.0f, 0.8, 1.0, p_234199_0_ -> this.shouldRunLikeCrazy()));
        this.f_21345_.m_25352_(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Sheep.class, 10, false, false, p_234199_0_ -> p_234199_0_ instanceof Sheep && ((Sheep)p_234199_0_).m_29874_() == DyeColor.PINK));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, 10, false, false, Entity::m_6060_));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(TORCH_BURNT_OUT, (Object)false);
    }

    public boolean m_6779_(LivingEntity p_186270_) {
        return p_186270_ instanceof Player && this.f_19853_.m_46791_() == Difficulty.PEACEFUL ? false : p_186270_.m_142066_();
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_()) {
            this.shootTicks = this.isAttacking() ? ++this.shootTicks : 0;
            if (this.fireballsShot > 0) {
                if (!this.isAttacking()) {
                    ++this.fireballTimer;
                    if (this.fireballTimer > 20) {
                        this.fireballTimer = 0;
                        --this.fireballsShot;
                    }
                } else {
                    this.fireballTimer = 0;
                }
            }
            if (this.fireballsShot > 25) {
                this.cooldownTicks = 300;
                this.m_5496_(SoundEvents.f_11914_, 1.0f, 0.8f);
                this.fireballsShot = 0;
            }
            --this.cooldownTicks;
            if (this.cooldownTicks < 0) {
                this.cooldownTicks = 0;
            }
            if (this.shootTicks >= 4) {
                this.m_5496_(SoundEvents.f_11798_, 1.0f, 1.0f);
                if (this.m_5448_() != null) {
                    if (this.isTorchBurntOut()) {
                        this.shootSnowball(this.m_5448_());
                    } else {
                        this.m_5496_(SoundEvents.f_11874_, 1.0f, 1.0f);
                        this.shootFireball(this.m_5448_());
                        ++this.fireballsShot;
                    }
                }
                this.shootTicks = 0;
            }
            if (this.m_5448_() instanceof Raider && !EntityUtil.isMobOnOtherTeam((Entity)this.m_5448_(), (Mob)this)) {
                if (!this.f_19853_.f_46443_) {
                    this.setTorchBurntOut(true);
                }
                if (!this.m_5448_().m_6060_()) {
                    this.m_6710_(null);
                }
            } else if (!this.f_19853_.f_46443_) {
                this.setTorchBurntOut(false);
            }
        }
    }

    public void shootSnowball(LivingEntity p_82196_1_) {
        Snowball snowballentity = new Snowball(this.f_19853_, (LivingEntity)this);
        double d0 = p_82196_1_.m_20188_() - (double)1.1f;
        double d1 = p_82196_1_.m_20185_() - this.m_20185_();
        double d2 = d0 - snowballentity.m_20186_();
        double d3 = p_82196_1_.m_20189_() - this.m_20189_();
        float f = (float)(Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f);
        snowballentity.m_6686_(d1, d2 + (double)f, d3, 1.6f, 12.0f);
        this.f_19853_.m_7967_((Entity)snowballentity);
    }

    public void shootFireball(LivingEntity target) {
        double d0 = this.m_20280_((Entity)target);
        double d1 = target.m_20185_() - this.m_20185_();
        double d2 = target.m_20227_(0.5) - this.m_20227_(0.5);
        double d3 = target.m_20189_() - this.m_20189_();
        float f = (float)(Math.sqrt(Math.sqrt(d0)) * 0.5);
        IgniterFireballEntity smallfireballentity = new IgniterFireballEntity(this.f_19853_, (LivingEntity)this, d1 + this.m_21187_().nextGaussian() * (double)f, d2, d3 + this.m_21187_().nextGaussian() * (double)f);
        smallfireballentity.m_6034_(smallfireballentity.m_20185_(), this.m_20227_(0.5) + 0.5, smallfireballentity.m_20189_());
        this.f_19853_.m_7967_((Entity)smallfireballentity);
    }

    public SoundEvent m_7930_() {
        return IllageAndSpillageSoundEvents.ENTITY_IGNITER_CELEBRATE;
    }

    protected SoundEvent m_7515_() {
        return IllageAndSpillageSoundEvents.ENTITY_IGNITER_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return IllageAndSpillageSoundEvents.ENTITY_IGNITER_HURT;
    }

    protected SoundEvent m_5592_() {
        return IllageAndSpillageSoundEvents.ENTITY_IGNITER_DEATH;
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isTorchBurntOut() {
        return (Boolean)this.f_19804_.m_135370_(TORCH_BURNT_OUT);
    }

    public void setTorchBurntOut(boolean burnt) {
        this.f_19804_.m_135381_(TORCH_BURNT_OUT, (Object)burnt);
    }

    public boolean shouldRunLikeCrazy() {
        return this.cooldownTicks > 0;
    }

    public boolean m_7327_(Entity p_70652_1_) {
        return false;
    }

    public void m_5837_(ServerLevel p_241847_1_, LivingEntity p_241847_2_) {
        super.m_5837_(p_241847_1_, p_241847_2_);
        if (p_241847_2_ instanceof Sheep && ((Sheep)p_241847_2_).m_29874_() == DyeColor.PINK && this.m_5448_() == p_241847_2_) {
            this.m_5496_(this.m_7930_(), 1.0f, 1.0f);
        }
    }

    class ShootFireballsGoal
    extends Goal {
        public ShootFireballsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return IgniterEntity.this.m_5448_() != null && IgniterEntity.this.m_20280_((Entity)IgniterEntity.this.m_5448_()) < 90.0 && IgniterEntity.this.m_142582_((Entity)IgniterEntity.this.m_5448_()) && !IgniterEntity.this.shouldRunLikeCrazy();
        }

        public void m_8056_() {
            IgniterEntity.this.setAttacking(true);
            IgniterEntity.this.m_5496_(SoundEvents.f_12088_, 1.0f, 0.6f);
        }

        public boolean m_8045_() {
            return IgniterEntity.this.m_5448_() != null && IgniterEntity.this.m_20280_((Entity)IgniterEntity.this.m_5448_()) < 90.0 && IgniterEntity.this.m_5448_().m_6084_() && IgniterEntity.this.m_142582_((Entity)IgniterEntity.this.m_5448_()) && !IgniterEntity.this.shouldRunLikeCrazy();
        }

        public void m_8037_() {
            IgniterEntity.this.m_21573_().m_26573_();
            if (IgniterEntity.this.m_5448_() != null) {
                IgniterEntity.this.m_21563_().m_24960_((Entity)IgniterEntity.this.m_5448_(), 30.0f, 30.0f);
            }
            IgniterEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            IgniterEntity.this.setAttacking(false);
            IgniterEntity.this.m_5496_(SoundEvents.f_12088_, 1.0f, 0.5f);
        }
    }
}

