/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.IllageAndSpillage;
import com.yellowbrossproductions.illageandspillage.config.IllageAndSpillageConfig;
import com.yellowbrossproductions.illageandspillage.entities.IllagerBoss;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.registries.ForgeRegistries;

public class BossRandomizerEntity
extends AbstractIllager
implements IllagerBoss {
    private static final EntityDataAccessor<Boolean> SHOULD_DELETE_ITSELF = SynchedEntityData.m_135353_(BossRandomizerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public BossRandomizerEntity(EntityType<? extends AbstractIllager> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOULD_DELETE_ITSELF, (Object)false);
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_37885_() != null && this.m_37885_().m_37771_() == 7 && this.shouldRemoveItself() && ((Boolean)IllageAndSpillageConfig.bossrandomizer_onlyOneAllowed.get()).booleanValue()) {
            this.m_37885_().m_37740_((Raider)this, true);
            if (!this.f_19853_.f_46443_) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        if (this.f_19797_ >= 15 && this.m_37885_() != null) {
            if (this.m_37885_().m_37771_() <= 7) {
                if (((Boolean)IllageAndSpillageConfig.bossrandomizer_broadcastBossSpawn.get()).booleanValue()) {
                    this.m_5496_(IllageAndSpillageSoundEvents.ENTITY_BOSSRANDOMIZER_BOSS, 15.0f, 1.0f);
                }
                this.spawnBoss();
            } else {
                if (((Boolean)IllageAndSpillageConfig.bossrandomizer_broadcastBossSpawn.get()).booleanValue()) {
                    this.m_5496_(IllageAndSpillageSoundEvents.ENTITY_BOSSRANDOMIZER_FINALBOSS, 15.0f, 1.0f);
                }
                this.spawnFinalBoss();
            }
        }
    }

    public boolean shouldRemoveItself() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_DELETE_ITSELF);
    }

    public void setShouldDeleteItself(boolean shouldDelete) {
        this.f_19804_.m_135381_(SHOULD_DELETE_ITSELF, (Object)shouldDelete);
    }

    public boolean m_7490_() {
        return false;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_213386_1_, DifficultyInstance p_213386_2_, MobSpawnType p_213386_3_, @Nullable SpawnGroupData p_213386_4_, @Nullable CompoundTag p_213386_5_) {
        if (p_213386_3_ == MobSpawnType.EVENT) {
            this.setShouldDeleteItself(true);
        }
        return super.m_6518_(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    private void spawnBoss() {
        BlockPos blockPos = this.m_20097_();
        boolean summonedMobFromConfig = this.summonMobFromConfig(blockPos);
        if (!summonedMobFromConfig) {
            if (this.f_19797_ == 15) {
                IllageAndSpillage.LOGGER.warn("Illage and Spillage couldn't spawn a boss! Check the config file for invalid registry names!");
            }
            this.m_6593_((Component)new TranslatableComponent("entity.illageandspillage.boss_randomizer.check_configs"));
        }
        if (summonedMobFromConfig && this.m_37885_() != null) {
            this.m_37885_().m_37740_((Raider)this, true);
            if (!this.f_19853_.f_46443_) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    private void spawnFinalBoss() {
        BlockPos blockPos = this.m_20097_();
        boolean summonedMobFromConfig = this.summonFinalBossFromConfig(blockPos);
        if (!summonedMobFromConfig) {
            if (this.f_19797_ == 15) {
                IllageAndSpillage.LOGGER.warn("Illage and Spillage couldn't spawn a boss! Check the config file for invalid registry names!");
            }
            this.m_6593_((Component)new TranslatableComponent("entity.illageandspillage.boss_randomizer.check_configs"));
        }
        if (summonedMobFromConfig && this.m_37885_() != null) {
            this.m_37885_().m_37740_((Raider)this, true);
            if (!this.f_19853_.f_46443_) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    private boolean summonMobFromConfig(BlockPos blockPos) {
        List mobSpawns = (List)IllageAndSpillageConfig.bossrandomizer_bosstypes.get();
        if (mobSpawns.isEmpty()) {
            return false;
        }
        Collections.shuffle(mobSpawns);
        int randomIndex = this.m_21187_().nextInt(mobSpawns.size());
        String randomMobID = (String)mobSpawns.get(randomIndex);
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(randomMobID));
        if (entityType == null) {
            return false;
        }
        Entity entity = entityType.m_20615_(this.f_19853_);
        if (!(entity instanceof Mob)) {
            return false;
        }
        Mob mobEntity = (Mob)entity;
        DifficultyInstance difficultyForLocation = this.f_19853_.m_6436_(blockPos.m_7494_());
        mobEntity.m_20035_(blockPos.m_7494_(), 0.0f, 0.0f);
        if (!this.f_19853_.f_46443_) {
            mobEntity.m_6518_((ServerLevelAccessor)this.f_19853_, difficultyForLocation, MobSpawnType.EVENT, (SpawnGroupData)null, (CompoundTag)null);
        }
        if (this.m_37885_() != null && mobEntity instanceof Raider) {
            this.m_37885_().m_37718_(this.m_37887_(), (Raider)mobEntity, false);
        }
        return this.f_19853_.m_7967_((Entity)mobEntity);
    }

    private boolean summonFinalBossFromConfig(BlockPos blockPos) {
        List mobSpawns = (List)IllageAndSpillageConfig.bossrandomizer_finalbosstypes.get();
        if (mobSpawns.isEmpty()) {
            return false;
        }
        Collections.shuffle(mobSpawns);
        int randomIndex = this.m_21187_().nextInt(mobSpawns.size());
        String randomMobID = (String)mobSpawns.get(randomIndex);
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(randomMobID));
        if (entityType == null) {
            return false;
        }
        Entity entity = entityType.m_20615_(this.f_19853_);
        if (!(entity instanceof Mob)) {
            return false;
        }
        Mob mobEntity = (Mob)entity;
        DifficultyInstance difficultyForLocation = this.f_19853_.m_6436_(blockPos.m_7494_());
        mobEntity.m_20035_(blockPos.m_7494_(), 0.0f, 0.0f);
        if (!this.f_19853_.f_46443_) {
            mobEntity.m_6518_((ServerLevelAccessor)this.f_19853_, difficultyForLocation, MobSpawnType.EVENT, (SpawnGroupData)null, (CompoundTag)null);
        }
        if (this.m_37885_() != null && mobEntity instanceof Raider) {
            this.m_37885_().m_37718_(this.m_37887_(), (Raider)mobEntity, false);
        }
        return this.f_19853_.m_7967_((Entity)mobEntity);
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12308_;
    }

    protected SoundEvent m_7515_() {
        return IllageAndSpillageSoundEvents.ENTITY_BOSSRANDOMIZER_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return IllageAndSpillageSoundEvents.ENTITY_BOSSRANDOMIZER_HURT;
    }

    protected SoundEvent m_5592_() {
        return IllageAndSpillageSoundEvents.ENTITY_BOSSRANDOMIZER_DEATH;
    }

    public boolean m_20151_() {
        return true;
    }
}

