/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import mods.thecomputerizer.reputation.Reputation;
import mods.thecomputerizer.reputation.common.ModDefinitions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public class JsonUtil {
    public static Optional<EntityType<?>> potentialEntity(JsonObject json, String element) {
        if (Objects.isNull(json) || !json.has(element)) {
            return Optional.empty();
        }
        try {
            ResourceLocation resource = new ResourceLocation(json.get(element).getAsString());
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(resource);
            return Objects.nonNull(type) ? Optional.of(type) : Optional.empty();
        }
        catch (Exception e) {
            Reputation.logError("Could not read json element {}", element, e);
            return Optional.empty();
        }
    }

    public static Map<String, List<ResourceLocation>> potentialResourceMap(JsonObject json, boolean distinctValues, String resourcePath, String ... elements) {
        HashMap<String, List<ResourceLocation>> ret = new HashMap<String, List<ResourceLocation>>();
        for (String element : elements) {
            List<ResourceLocation> potentialResources = JsonUtil.potentialResourceList(json, resourcePath, element, distinctValues);
            if (potentialResources.isEmpty()) continue;
            ret.put(element, potentialResources);
        }
        return ret;
    }

    public static List<ResourceLocation> potentialResourceList(JsonObject json, String resourcePath, String element, boolean distinct) {
        if (Objects.nonNull(json) && json.has(element)) {
            try {
                ArrayList<ResourceLocation> resources = new ArrayList<ResourceLocation>();
                for (JsonElement e : json.get(element).getAsJsonArray()) {
                    ResourceLocation resource = ModDefinitions.getResource(resourcePath.replaceFirst("\\{}", e.getAsString()));
                    if (distinct && resources.contains(resource)) continue;
                    resources.add(resource);
                }
                return resources;
            }
            catch (Exception ex) {
                Reputation.logError("Failed to read resource from json element {}", json.get(element).getAsString(), ex);
                return new ArrayList<ResourceLocation>();
            }
        }
        return new ArrayList<ResourceLocation>();
    }

    public static OptionalLong potentialLong(JsonObject json, String element) {
        try {
            return Objects.nonNull(json) && json.has(element) ? OptionalLong.of(json.get(element).getAsLong()) : OptionalLong.empty();
        }
        catch (Exception e) {
            Reputation.logError("Could not read json element {}", element, e);
            return OptionalLong.empty();
        }
    }

    public static Optional<Float> potentialFloat(JsonObject json, String element) {
        try {
            return Objects.nonNull(json) && json.has(element) ? Optional.of(Float.valueOf(json.get(element).getAsFloat())) : Optional.empty();
        }
        catch (Exception e) {
            Reputation.logError("Could not read json element {}", element, e);
            return Optional.empty();
        }
    }
}

