/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mods.thecomputerizer.reputation.Reputation;
import mods.thecomputerizer.reputation.api.Faction;
import mods.thecomputerizer.reputation.api.PlayerFactionHandler;
import mods.thecomputerizer.reputation.api.ReputationHandler;
import mods.thecomputerizer.reputation.common.ModDefinitions;
import mods.thecomputerizer.reputation.common.ai.ReputationAIPackages;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class HelperMethods {
    public static Player getNearestPlayerInCustomStandingToEntity(LivingEntity entity, double distance, String reputationStanding) {
        if (reputationStanding.matches("good")) {
            return HelperMethods.getNearestPlayerInGoodStandingToEntity(entity, distance);
        }
        if (reputationStanding.matches("neutral")) {
            return HelperMethods.getNearestPlayerInNeutralStandingToEntity(entity, distance);
        }
        return HelperMethods.getNearestPlayerInBadStandingToEntity(entity, distance);
    }

    public static Player getNearestPlayerInGoodStandingToEntity(LivingEntity entity, double distance) {
        Level level = entity.f_19853_;
        List<Player> list = level.m_6907_().stream().filter(EntitySelector.f_20408_).filter(p -> entity.m_19950_((Entity)p, distance)).filter(p -> p.getCapability(ReputationHandler.REPUTATION_CAPABILITY).isPresent()).filter(p -> HelperMethods.isPlayerInGoodStanding(entity, p)).sorted(Comparator.comparingDouble(arg_0 -> ((LivingEntity)entity).m_20280_(arg_0))).toList();
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public static Player getNearestPlayerInNeutralStandingToEntity(LivingEntity entity, double distance) {
        Level level = entity.f_19853_;
        List<Player> list = level.m_6907_().stream().filter(EntitySelector.f_20408_).filter(p -> entity.m_19950_((Entity)p, distance)).filter(p -> p.getCapability(ReputationHandler.REPUTATION_CAPABILITY).isPresent()).filter(p -> HelperMethods.isPlayerInNeutralStanding(entity, p)).sorted(Comparator.comparingDouble(arg_0 -> ((LivingEntity)entity).m_20280_(arg_0))).toList();
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public static Player getNearestPlayerInBadStandingToEntity(LivingEntity entity, double distance) {
        Level level = entity.f_19853_;
        List<Player> list = level.m_6907_().stream().filter(EntitySelector.f_20408_).filter(p -> entity.m_19950_((Entity)p, distance)).filter(p -> p.getCapability(ReputationHandler.REPUTATION_CAPABILITY).isPresent()).filter(p -> HelperMethods.isPlayerInBadStanding(entity, p)).sorted(Comparator.comparingDouble(arg_0 -> ((LivingEntity)entity).m_20280_(arg_0))).toList();
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public static boolean ensureSeparateFactions(LivingEntity entity, Player player) {
        for (Faction f : ReputationHandler.getEntityFactions(entity)) {
            if (!PlayerFactionHandler.isPlayerInFaction(player, f)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPlayerInCustomStanding(LivingEntity entity, Player player, String reputationStanding) {
        if (reputationStanding.matches("good")) {
            return HelperMethods.isPlayerInGoodStanding(entity, player);
        }
        if (reputationStanding.matches("neutral")) {
            return HelperMethods.isPlayerInNeutralStanding(entity, player);
        }
        return HelperMethods.isPlayerInBadStanding(entity, player);
    }

    public static boolean isPlayerInGoodStanding(LivingEntity entity, Player player) {
        for (Faction faction : ReputationHandler.getEntityFactions(entity)) {
            if (ReputationHandler.getReputation(player, faction) < faction.getHigherRep()) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlayerInNeutralStanding(LivingEntity entity, Player player) {
        for (Faction faction : ReputationHandler.getEntityFactions(entity)) {
            if (ReputationHandler.getReputation(player, faction) <= faction.getLowerRep() || ReputationHandler.getReputation(player, faction) >= faction.getHigherRep()) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlayerInBadStanding(LivingEntity entity, Player player) {
        for (Faction faction : ReputationHandler.getEntityFactions(entity)) {
            if (ReputationHandler.getReputation(player, faction) > faction.getLowerRep()) continue;
            return true;
        }
        return false;
    }

    public static double tradePrice(float percentage, int initialCount, int stackSize) {
        if (percentage <= 0.5f) {
            return 999.0;
        }
        if (percentage >= 1.0f && percentage < 1.5f) {
            return 1.0;
        }
        if ((double)percentage > 0.5 && percentage < 1.0f) {
            float maxStackSizePercent = (float)stackSize / (float)initialCount;
            float itemPercentage = 1.0f - (percentage - 0.5f) * 2.0f;
            return 1.0 + (double)((maxStackSizePercent - 1.0f) * itemPercentage);
        }
        double exponential = 1.0f / (percentage - 0.5f);
        return Math.pow(2.0, exponential) / 2.0;
    }

    public static float tradeMultiplier(LivingEntity entity, Player player) {
        Collection<Faction> factions = ReputationHandler.getEntityFactions(entity);
        if (!factions.isEmpty() && ModDefinitions.TRADING_ENTITIES.contains(entity.m_6095_())) {
            Faction lowest = null;
            for (Faction f : factions) {
                if (lowest == null) {
                    lowest = f;
                    continue;
                }
                if (!(HelperMethods.getPercentageAwayFromLowerBound(f, player) < HelperMethods.getPercentageAwayFromLowerBound(lowest, player))) continue;
                lowest = f;
            }
            if (lowest != null) {
                float percentage = HelperMethods.getPercentageAwayFromLowerBound(lowest, player);
                if (ReputationAIPackages.standings.getTrading(entity.m_6095_()).matches("bad")) {
                    return percentage;
                }
                if (ReputationAIPackages.standings.getTrading(entity.m_6095_()).matches("neutral")) {
                    return percentage - 0.5f;
                }
                return percentage - 1.0f;
            }
        }
        return 1.0f;
    }

    public static float getPercentageAwayFromLowerBound(Faction faction, Player player) {
        float lower = faction.getLowerRep();
        float higher = faction.getHigherRep();
        float difference = Math.abs(Math.subtractExact((int)higher, (int)lower));
        float currentReputation = ReputationHandler.getReputation(player, faction);
        if (currentReputation == lower) {
            return 0.0f;
        }
        float currentDifference = Math.abs(Math.subtractExact((int)lower, (int)currentReputation));
        float percentage = currentDifference / difference;
        if (currentReputation < lower) {
            return -1.0f * percentage;
        }
        return percentage;
    }

    public static float fleeFactor(LivingEntity entity) {
        Collection<Faction> factions;
        Player player = HelperMethods.getNearestPlayerInBadStandingToEntity(entity, 16.0);
        if (player != null && !(factions = ReputationHandler.getEntityFactions(entity)).isEmpty()) {
            int total = 0;
            int rep = 0;
            int cutoff = 0;
            for (Faction f : factions) {
                rep += ReputationHandler.getReputation(player, f);
                ++total;
                cutoff += f.getLowerRep();
            }
            float averageLowRep = (float)cutoff / (float)total;
            if ((float)rep != averageLowRep) {
                return 0.5f - ((float)rep / (float)total + Math.abs(averageLowRep)) / (2.0f * Math.abs(averageLowRep));
            }
        }
        return 1.0f;
    }

    public static List<? extends LivingEntity> getSeenEntitiesOfFaction(ServerLevel level, LivingEntity mob, int range, Brain<? extends LivingEntity> brain, Faction faction) {
        ArrayList<LivingEntity> ret = new ArrayList<LivingEntity>();
        if (brain.f_21843_.isEmpty()) {
            ret.addAll(level.m_45976_(LivingEntity.class, new AABB(mob.m_20185_() - (double)range, mob.m_20186_() - (double)((float)range / 2.0f), mob.m_20189_() - (double)range, mob.m_20185_() + (double)range, mob.m_20186_() + (double)((float)range / 2.0f), mob.m_20189_() + (double)range)));
            ret.removeIf(e -> {
                Mob m;
                if (e.m_20149_().matches(mob.m_20149_()) || !faction.getMembers().contains(e.m_6095_())) {
                    return true;
                }
                return e instanceof Mob && !(m = (Mob)e).m_21574_().m_148306_((Entity)mob);
            });
        } else {
            try {
                Optional optional = brain.m_21952_(MemoryModuleType.f_148205_);
                optional.ifPresent(nearestVisibleLivingEntities -> nearestVisibleLivingEntities.m_186123_(faction::isMember).iterator().forEachRemaining(ret::add));
            }
            catch (Exception e2) {
                Reputation.logError("Failed to collect seen entities using a brain", e2);
            }
        }
        return ret;
    }

    public static List<? extends LivingEntity> getNearEntitiesOfFaction(ServerLevel level, LivingEntity entity, Faction faction, int range) {
        List ret = level.m_45976_(LivingEntity.class, new AABB(entity.m_20185_() - (double)range, entity.m_20186_() - (double)((float)range / 2.0f), entity.m_20189_() - (double)range, entity.m_20185_() + (double)range, entity.m_20186_() + (double)((float)range / 2.0f), entity.m_20189_() + (double)range));
        return ret.stream().filter(e -> !e.m_20149_().matches(entity.m_20149_()) && faction.getMembers().contains(e.m_6095_())).collect(Collectors.toList());
    }

    public static List<? extends LivingEntity> getSeenEntitiesOfTypeInRange(ServerLevel level, LivingEntity entity, EntityType<?> type, BlockPos pos, double range) {
        return level.m_45976_(LivingEntity.class, new AABB((double)pos.m_123341_() - range, (double)pos.m_123342_() - range / 2.0, (double)pos.m_123343_() - range, (double)pos.m_123341_() + range, (double)pos.m_123342_() + range / 2.0, (double)pos.m_123343_() + range)).stream().filter(e -> e.m_6095_() == type && e != entity).filter(e -> {
            Mob mob;
            if (!e.m_6274_().f_21843_.isEmpty()) {
                return e.m_6274_().m_21952_(MemoryModuleType.f_148205_).isPresent() && ((NearestVisibleLivingEntities)e.m_6274_().m_21952_(MemoryModuleType.f_148205_).get()).m_186107_(entity);
            }
            return e instanceof Mob && (mob = (Mob)e).m_21574_().m_148306_((Entity)entity);
        }).collect(Collectors.toList());
    }

    public static int flatIndex(int width, int x, int y) {
        return width * y + x;
    }
}

