/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mods.thecomputerizer.reputation.Reputation;
import mods.thecomputerizer.reputation.api.Faction;
import mods.thecomputerizer.reputation.api.ReputationHandler;
import mods.thecomputerizer.reputation.common.ai.ReputationAIPackages;
import mods.thecomputerizer.reputation.common.ai.ServerTrackers;
import mods.thecomputerizer.reputation.common.registration.Recipes;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class FactionListener
extends SimplePreparableReloadListener<Void> {
    private static final Gson GSON = (Gson)Util.m_137537_(() -> {
        GsonBuilder builder = new GsonBuilder();
        builder.disableHtmlEscaping();
        builder.setLenient();
        builder.setPrettyPrinting();
        return builder.create();
    });

    @Nonnull
    protected Void prepare(@Nonnull ResourceManager rm, @Nonnull ProfilerFiller profiler) {
        return null;
    }

    protected void apply(@Nonnull Void value, @Nonnull ResourceManager rm, @Nonnull ProfilerFiller profiler) {
        Reputation.logInfo("Beginning to read reputation datapack", new Object[0]);
        try {
            InputStreamReader reader;
            ArrayList<ResourceLocation> checked = new ArrayList<ResourceLocation>();
            for (ResourceLocation resource : rm.m_6540_("factions", location -> location.endsWith("json"))) {
                if (checked.contains(resource)) continue;
                InputStreamReader reader2 = new InputStreamReader(rm.m_142591_(resource).m_6679_(), StandardCharsets.UTF_8);
                ReputationHandler.registerFaction(Faction.fromJson(resource, (JsonElement)GSON.fromJson((Reader)reader2, JsonElement.class)));
                reader2.close();
                checked.add(resource);
            }
            ArrayList<JsonElement> iconData = new ArrayList<JsonElement>();
            JsonElement timings = null;
            for (ResourceLocation resource : rm.m_6540_("chat", location -> location.endsWith("json"))) {
                if (checked.contains(resource)) continue;
                reader = new InputStreamReader(rm.m_142591_(resource).m_6679_(), StandardCharsets.UTF_8);
                JsonElement element = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                if (resource.m_135815_().endsWith("timings.json")) {
                    timings = element;
                } else {
                    iconData.add(element);
                }
                reader.close();
                checked.add(resource);
            }
            ServerTrackers.initTimers(timings);
            ServerTrackers.parseChatIcons(iconData);
            Reputation.logInfo("Successfully attached {} files to the chat icon data map", iconData.size());
            try {
                ResourceLocation ai = new ResourceLocation("reputation", "ai.json");
                if (rm.m_7165_(ai)) {
                    Resource AI = rm.m_142591_(ai);
                    reader = new InputStreamReader(AI.m_6679_(), StandardCharsets.UTF_8);
                    ReputationAIPackages.buildMobLists((JsonElement)GSON.fromJson((Reader)reader, JsonElement.class));
                } else {
                    ReputationAIPackages.buildMobLists(JsonParser.parseString((String)"{ }"));
                }
            }
            catch (Exception e) {
                Reputation.logError("'{}'", e.getMessage(), e);
                throw new RuntimeException("Failed to read AI data!");
            }
            Recipes.updateCurrencySet(ReputationHandler.getFactionMap().values().stream().map(Faction::getCurrencyItem).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        catch (Exception e) {
            Reputation.logError("'{}'", e.getMessage(), e);
            throw new RuntimeException("Failed to read faction data!");
        }
    }
}

