/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.mixin;

import mods.thecomputerizer.reputation.api.ReputationHandler;
import mods.thecomputerizer.reputation.util.HelperMethods;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.trading.MerchantOffer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Villager.class})
public abstract class MixinVillager {
    @Inject(at={@At(value="HEAD")}, method={"startTrading(Lnet/minecraft/world/entity/player/Player;)V"}, cancellable=true)
    private void startTrading(Player player, CallbackInfo ci) {
        if (player.getCapability(ReputationHandler.REPUTATION_CAPABILITY).isPresent()) {
            Villager villager = (Villager)this;
            float priceMultiplier = HelperMethods.tradeMultiplier((LivingEntity)villager, player);
            if ((double)priceMultiplier < 0.5) {
                villager.m_35518_();
                ci.cancel();
            } else {
                for (MerchantOffer merchantoffer : villager.m_6616_()) {
                    double multiplier = HelperMethods.tradePrice(priceMultiplier, merchantoffer.m_45352_().m_41613_(), merchantoffer.m_45352_().m_41741_());
                    if (multiplier == 0.0 || multiplier == 1.0) continue;
                    int totalCount = (int)Math.floor(multiplier * (double)merchantoffer.m_45352_().m_41613_());
                    merchantoffer.m_45353_(totalCount - merchantoffer.m_45352_().m_41613_());
                }
            }
        }
    }
}

