/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.common.registration;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mods.thecomputerizer.reputation.Reputation;
import mods.thecomputerizer.reputation.api.Faction;
import mods.thecomputerizer.reputation.api.ReputationHandler;
import mods.thecomputerizer.reputation.common.registration.Items;
import mods.thecomputerizer.reputation.util.HelperMethods;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class Recipes {
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_REGISTRY = DeferredRegister.create((ResourceKey)Registry.f_122915_, (String)"reputation");
    public static RegistryObject<RecipeSerializer<?>> CURRENCY_RECIPE_SERIALIZER = Recipes.register("currency_recipe");
    private static Set<Item> CURRENCY_SET = Set.of();

    public static void updateCurrencySet(Set<Item> items) {
        CURRENCY_SET = items;
        Reputation.logStringCollection(org.apache.logging.log4j.Level.INFO, "Adding items to the currency set", CURRENCY_SET.stream().map(item -> Optional.ofNullable(item.getRegistryName()).map(ResourceLocation::toString).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet()), 10);
    }

    public static void register(IEventBus bus) {
        RECIPE_REGISTRY.register(bus);
    }

    private static RegistryObject<RecipeSerializer<?>> register(String name) {
        return RECIPE_REGISTRY.register(name, () -> new SimpleRecipeSerializer(DoughnutRecipe::new));
    }

    private static class DoughnutRecipe
    extends CustomRecipe {
        private String faction;

        public DoughnutRecipe(ResourceLocation id) {
            super(id);
        }

        public boolean matches(@NotNull CraftingContainer container, @NotNull Level level) {
            for (int i = 0; i <= container.m_39346_() - 3; ++i) {
                for (int j = 0; j <= container.m_39347_() - 3; ++j) {
                    int flatIndex = HelperMethods.flatIndex(container.m_39347_(), j, i);
                    if (container.m_8020_(flatIndex).m_41619_()) continue;
                    return this.matches(container, container.m_8020_(flatIndex), j, i);
                }
            }
            return false;
        }

        private boolean matches(@NotNull CraftingContainer container, ItemStack topLeft, int x, int y) {
            if (!topLeft.m_41619_() && CURRENCY_SET.contains(topLeft.m_41720_()) && x >= 0) {
                if (!container.m_8020_(HelperMethods.flatIndex(container.m_39347_(), x + 1, y + 1)).m_150930_(net.minecraft.world.item.Items.f_42454_)) {
                    return false;
                }
                for (int i = 0; i <= y; ++i) {
                    for (int j = 0; j <= container.m_39347_() - 3; ++j) {
                        if (j == x + 1 && i == y + 1) continue;
                        int temp = HelperMethods.flatIndex(container.m_39347_(), j, i);
                        if (!(j >= x && j <= x + 2 && i >= y && i <= y + 2 || container.m_8020_(temp).m_41619_())) {
                            return false;
                        }
                        if (container.m_8020_(temp).m_150930_(topLeft.m_41720_())) continue;
                        return false;
                    }
                }
                Faction faction = ReputationHandler.getFactionFromCurrency(topLeft.m_41720_());
                if (Objects.nonNull(faction)) {
                    this.faction = faction.getID().toString();
                }
                return true;
            }
            return false;
        }

        @NotNull
        public ItemStack assemble(@NotNull CraftingContainer container) {
            ItemStack stack = new ItemStack((ItemLike)Items.FACTION_BAG.get());
            if (Objects.nonNull(this.faction)) {
                stack.m_41784_().m_128359_("factionID", this.faction);
            }
            return stack;
        }

        public boolean m_8004_(int width, int height) {
            return width >= 3 && height >= 3;
        }

        @NotNull
        public RecipeSerializer<?> m_7707_() {
            return (RecipeSerializer)CURRENCY_RECIPE_SERIALIZER.get();
        }
    }
}

