/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.common.objects.blocks;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import mods.thecomputerizer.reputation.api.Faction;
import mods.thecomputerizer.reputation.api.ReputationHandler;
import mods.thecomputerizer.reputation.common.objects.blockentities.LedgerBookEntity;
import mods.thecomputerizer.reputation.common.objects.items.FactionCurrencyBag;
import mods.thecomputerizer.reputation.common.registration.BlockEntities;
import mods.thecomputerizer.reputation.common.registration.Sounds;
import mods.thecomputerizer.reputation.util.HelperMethods;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class LedgerBook
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public LedgerBook(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        LedgerBookEntity ledgerBookEntity;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof LedgerBookEntity && (ledgerBookEntity = (LedgerBookEntity)entity).canUse() && level instanceof ServerLevel) {
            ItemStack stack = player.m_21205_();
            CompoundTag tag = stack.m_41784_();
            if (stack.m_41720_() instanceof FactionCurrencyBag && player.m_21206_().m_41720_() == Items.f_42532_ && tag.m_128441_("factionID")) {
                Faction faction = ReputationHandler.getFaction(new ResourceLocation(tag.m_128461_("factionID")));
                if (Objects.nonNull(faction) && !tag.m_128441_("signed")) {
                    float factor = 2.0f;
                    if (HelperMethods.getNearEntitiesOfFaction((ServerLevel)level, (LivingEntity)player, faction, 8).isEmpty()) {
                        player.m_6352_((Component)new TextComponent("The book acknowledges the tribute"), Util.f_137441_);
                        factor = 1.0f;
                        level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)Sounds.LEDGER_SIGN.get(), SoundSource.BLOCKS, 1.0f, Mth.m_144924_((Random)ReputationHandler.RANDOM, (float)0.88f, (float)1.12f), false);
                    } else {
                        player.m_6352_((Component)new TextComponent("The book acknowledges the tribute and the presence of a fitting 3rd party"), Util.f_137441_);
                        if (!player.m_21205_().m_41784_().m_128441_("Enchantments")) {
                            player.m_21205_().m_41784_().m_128365_("Enchantments", (Tag)new ListTag());
                            CompoundTag compoundtag = new CompoundTag();
                            compoundtag.m_128359_("id", "signed");
                            compoundtag.m_128376_("lvl", (short)1);
                            player.m_21205_().m_41784_().m_128437_("Enchantments", 10).add((Object)compoundtag);
                            level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)Sounds.LEDGER_SIGN.get(), SoundSource.BLOCKS, 1.0f, Mth.m_144924_((Random)ReputationHandler.RANDOM, (float)0.88f, (float)1.12f), false);
                        }
                    }
                    player.m_21205_().m_41784_().m_128350_("signed", factor);
                    player.m_21206_().m_41774_(1);
                    ledgerBookEntity.setCooldown();
                    return InteractionResult.CONSUME_PARTIAL;
                }
            } else {
                Faction faction = ReputationHandler.getFactionFromCurrency(player.m_21205_().m_41720_());
                if (Objects.isNull(faction)) {
                    faction = ReputationHandler.getFactionFromCurrency(player.m_21206_().m_41720_());
                }
                if (Objects.nonNull(faction)) {
                    String builder = "The writing in the book seems to be shifting but briefly settles on some numbers as you look at it: \n" + faction.getName() + " -> " + ReputationHandler.getReputation(player, faction);
                    player.m_6352_((Component)new TextComponent(builder), Util.f_137441_);
                    ledgerBookEntity.setCooldown();
                }
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)12.0, (double)4.0, (double)12.0);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return LedgerBook.createTicker(level, type, (BlockEntityType<? extends LedgerBookEntity>)((BlockEntityType)BlockEntities.LEDGER_BOOK_ENTITY.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level level, @NotNull BlockEntityType<T> type, BlockEntityType<? extends LedgerBookEntity> bookType) {
        return level.f_46443_ ? null : LedgerBook.m_152132_(type, bookType, LedgerBookEntity::tick);
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new LedgerBookEntity(pos, state);
    }
}

