/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.common.objects.blockentities;

import java.util.Objects;
import java.util.Random;
import mods.thecomputerizer.reputation.api.Faction;
import mods.thecomputerizer.reputation.api.ReputationHandler;
import mods.thecomputerizer.reputation.common.registration.BlockEntities;
import mods.thecomputerizer.reputation.common.registration.Items;
import mods.thecomputerizer.reputation.common.registration.Sounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LedgerEntity
extends BaseContainerBlockEntity
implements LidBlockEntity {
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private int cooldownTimer = 0;

    public static void tick(Level level, BlockPos pos, BlockState state, LedgerEntity ledger) {
        ledger.tick(level, pos);
    }

    protected LedgerEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public LedgerEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntities.LEDGER_ENTITY.get(), pos, state);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        if (tag.m_128441_("ledger_cooldown")) {
            this.cooldownTimer = tag.m_128451_("ledger_cooldown");
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128405_("ledger_cooldown", this.cooldownTimer);
    }

    private void tick(Level level, BlockPos pos) {
        if (this.cooldownTimer > 0) {
            --this.cooldownTimer;
            this.m_58638_((Component)new TranslatableComponent("ledger.reputation.checked"));
        } else {
            long time = level.m_8044_();
            if (time >= 12000L && time <= 13000L) {
                this.runCollection(level, pos);
            }
        }
    }

    protected void runCollection(Level level, BlockPos pos) {
        for (ItemStack stack : this.items) {
            Player player;
            CompoundTag tag;
            if (stack == ItemStack.f_41583_ || stack.m_41720_() != Items.FACTION_BAG.get() || !(tag = stack.m_41784_()).m_128441_("signed") || !tag.m_128441_("factionID") || !tag.m_128441_("playerUUID") || !Objects.nonNull(player = level.m_46003_(tag.m_128342_("playerUUID")))) continue;
            Faction faction = ReputationHandler.getFaction(new ResourceLocation(tag.m_128461_("factionID")));
            int amount = (int)tag.m_128457_("signed");
            ReputationHandler.changeReputation(player, faction, amount);
        }
        level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)Sounds.LEDGER_PLACE.get(), SoundSource.BLOCKS, 1.0f, Mth.m_144924_((Random)ReputationHandler.RANDOM, (float)0.88f, (float)1.12f), false);
        this.m_6211_();
        this.m_58638_((Component)new TranslatableComponent("ledger.reputation.checked"));
        this.cooldownTimer = 2000;
    }

    @NotNull
    protected Component m_6820_() {
        return new TranslatableComponent("ledger.reputation.container");
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int containerId, @NotNull Inventory inventory) {
        return new Menu(MenuType.f_39959_, containerId, this, inventory);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean m_7013_(int index, @NotNull ItemStack stack) {
        return false;
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    @NotNull
    public ItemStack m_7407_(int index, int count) {
        return this.m_8020_(index);
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        return this.m_8020_(index);
    }

    public void m_6836_(int index, @NotNull ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(@NotNull Player player) {
        if (Objects.nonNull(this.f_58857_) && this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.items.clear();
        this.m_6596_();
    }

    public float m_6683_(float pPartialTicks) {
        return 0.0f;
    }

    private static class Menu
    extends AbstractContainerMenu {
        private final LedgerEntity container;

        protected Menu(@Nullable MenuType<?> menuType, int containerId, LedgerEntity container, Inventory inventory) {
            super(menuType, containerId);
            int j;
            int i;
            this.container = container;
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 9; ++j) {
                    this.m_38897_(new LedgerSlot((Container)container, j + i * 9, 8 + j * 18, 18 + i * 18));
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 9; ++j) {
                    this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 85 + i * 18));
                }
            }
            for (i = 0; i < 9; ++i) {
                this.m_38897_(new Slot((Container)inventory, i, 8 + i * 18, 143));
            }
        }

        public boolean m_6875_(@NotNull Player player) {
            return this.container.m_6542_(player);
        }

        @NotNull
        public ItemStack m_7648_(@NotNull Player player, int index) {
            ItemStack ret = ItemStack.f_41583_;
            Slot slot = (Slot)this.f_38839_.get(index);
            if (slot != null && slot.m_6657_()) {
                ItemStack stack = slot.m_7993_();
                ret = stack.m_41777_();
                if (index < 27 ? !this.m_38903_(stack, 27, this.f_38839_.size(), true) : !this.m_38903_(stack, 0, 27, false)) {
                    return ItemStack.f_41583_;
                }
                if (stack.m_41619_()) {
                    slot.m_5852_(ItemStack.f_41583_);
                } else {
                    slot.m_6654_();
                }
            }
            return ret;
        }
    }

    private static final class LedgerSlot
    extends Slot {
        private LedgerSlot(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return this.m_7993_() == ItemStack.f_41583_;
        }

        public boolean m_8010_(@NotNull Player player) {
            return false;
        }
    }
}

