/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.common.network;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import mods.thecomputerizer.reputation.api.Faction;
import mods.thecomputerizer.reputation.api.ReputationHandler;
import mods.thecomputerizer.reputation.client.ClientHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SyncFactionPlayersMessage {
    private final ResourceLocation faction;
    private final List<UUID> uuids;
    private final int uuidSize;

    public SyncFactionPlayersMessage(FriendlyByteBuf buf) {
        this.faction = new ResourceLocation(buf.m_130277_());
        this.uuidSize = buf.readInt();
        this.uuids = new ArrayList<UUID>();
        for (int i = 0; i < this.uuidSize; ++i) {
            this.uuids.add(buf.m_130259_());
        }
    }

    public SyncFactionPlayersMessage(Faction faction, List<UUID> uuids) {
        this.faction = faction.getID();
        this.uuids = uuids;
        this.uuidSize = uuids.size();
    }

    public static void encode(SyncFactionPlayersMessage message, FriendlyByteBuf buf) {
        if (message.faction != null) {
            buf.m_130070_(message.faction.toString());
        }
        if (message.uuids != null) {
            buf.writeInt(message.uuidSize);
            for (UUID uuid : message.uuids) {
                buf.m_130077_(uuid);
            }
        }
    }

    public static void handle(SyncFactionPlayersMessage message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeRunnable & Serializable)() -> ClientHandler.readReputationPlayersMessage(message)));
        ctx.setPacketHandled(true);
    }

    public Faction getFaction() {
        return ReputationHandler.getFaction(this.faction);
    }

    public List<UUID> getPlayerUUIDS() {
        return this.uuids;
    }
}

