/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.common.network;

import java.util.UUID;
import java.util.function.Supplier;
import mods.thecomputerizer.reputation.client.ClientHandler;
import mods.thecomputerizer.reputation.client.event.RenderEvents;
import mods.thecomputerizer.reputation.common.registration.Sounds;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.network.NetworkEvent;

public class FleeIconMessage {
    private final UUID uuid;
    private final boolean add;

    public FleeIconMessage(FriendlyByteBuf buf) {
        this.uuid = buf.m_130259_();
        this.add = buf.readBoolean();
    }

    public FleeIconMessage(UUID uuid, boolean add) {
        this.uuid = uuid;
        this.add = add;
    }

    public static void encode(FleeIconMessage message, FriendlyByteBuf buf) {
        buf.m_130077_(message.uuid);
        buf.writeBoolean(message.add);
    }

    public static void handle(FleeIconMessage message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {});
        if (!RenderEvents.fleeingMobs.contains(message.uuid) && message.add) {
            RenderEvents.fleeingMobs.add(message.uuid);
            ClientHandler.playPacketSound((SoundEvent)Sounds.FLEE.get());
        } else if (!message.add) {
            RenderEvents.fleeingMobs.remove(message.uuid);
        }
        ctx.setPacketHandled(true);
    }
}

