/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.common.event;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import mods.thecomputerizer.reputation.api.Faction;
import mods.thecomputerizer.reputation.api.PlayerFactionHandler;
import mods.thecomputerizer.reputation.api.ReputationHandler;
import mods.thecomputerizer.reputation.api.capability.IReputation;
import mods.thecomputerizer.reputation.common.ModDefinitions;
import mods.thecomputerizer.reputation.common.ai.ChatTracker;
import mods.thecomputerizer.reputation.common.ai.ReputationAIPackages;
import mods.thecomputerizer.reputation.common.ai.ServerTrackers;
import mods.thecomputerizer.reputation.common.ai.goals.FleeBattleGoal;
import mods.thecomputerizer.reputation.common.ai.goals.FleeBattleTargetOverride;
import mods.thecomputerizer.reputation.common.ai.goals.FleeGoal;
import mods.thecomputerizer.reputation.common.ai.goals.ReputationAttackableTargetGoal;
import mods.thecomputerizer.reputation.common.ai.goals.ReputationPacifyHostileCustomStandingGoal;
import mods.thecomputerizer.reputation.common.capability.PlayerFactionProvider;
import mods.thecomputerizer.reputation.common.command.AddPlayerToFactionCommand;
import mods.thecomputerizer.reputation.common.command.AddReputationCommand;
import mods.thecomputerizer.reputation.common.command.RemovePlayerFromFactionCommand;
import mods.thecomputerizer.reputation.common.command.SetReputationCommand;
import mods.thecomputerizer.reputation.common.network.ChatIconMessage;
import mods.thecomputerizer.reputation.common.network.PacketHandler;
import mods.thecomputerizer.reputation.common.network.SyncFactionsMessage;
import mods.thecomputerizer.reputation.util.HelperMethods;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="reputation")
public class WorldEvents {
    private static int tickTimer = 0;
    public static final Map<LivingEntity, ChatTracker> TRACKER_MAP = new ConcurrentHashMap<LivingEntity, ChatTracker>();
    private static final Random RANDOM = new Random();
    private static final List<ServerPlayer> players = new ArrayList<ServerPlayer>();

    @SubscribeEvent
    public static void attachLevelCapabilities(AttachCapabilitiesEvent<Level> event) {
        Level level = (Level)event.getObject();
        if (level.m_46472_() == Level.f_46428_ && !level.m_5776_()) {
            for (Faction faction : ReputationHandler.getFactionMap().values()) {
                PlayerFactionProvider playerFactionProvider = new PlayerFactionProvider(faction);
                PlayerFactionHandler.PLAYER_FACTIONS.put(faction, playerFactionProvider);
                event.addCapability(faction.getID(), (ICapabilityProvider)playerFactionProvider);
            }
        }
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        SetReputationCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        AddReputationCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        AddPlayerToFactionCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        RemovePlayerFromFactionCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onJoin(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (!event.getWorld().f_46443_) {
                Brain brain = entity2.m_6274_();
                if (!brain.f_21843_.isEmpty()) {
                    brain.f_21844_.putIfAbsent(SensorType.f_26811_, SensorType.f_26811_.m_26827_());
                    brain.f_21843_.putIfAbsent(MemoryModuleType.f_148205_, Optional.empty());
                    ReputationAIPackages.buildReputationSensor((Brain<? extends LivingEntity>)brain);
                }
                if (entity2 instanceof Player) {
                    Player player = (Player)entity2;
                    IReputation reputation = ReputationHandler.getCapability(player);
                    if (Objects.nonNull(reputation)) {
                        HashMap<Faction, Integer> toSync = reputation.allReputations();
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        PacketHandler.sendTo(new SyncFactionsMessage(toSync, ReputationAIPackages.standings.getData()), serverPlayer);
                        for (Faction f : toSync.keySet()) {
                            reputation.setReputation(player, f, toSync.get(f));
                        }
                        ServerTrackers.syncChatIcons(serverPlayer);
                        players.add(serverPlayer);
                    }
                } else {
                    PathfinderMob mob;
                    if (ModDefinitions.INJURED_FLEEING_ENTITIES.contains(entity2.m_6095_())) {
                        if (!brain.f_21843_.isEmpty()) {
                            ReputationAIPackages.buildReputationInjuredAI(brain, 0.5f);
                        } else if (entity2 instanceof PathfinderMob) {
                            mob = (PathfinderMob)entity2;
                            FleeBattleGoal fleeBattleGoal = new FleeBattleGoal(mob, 0.5f);
                            mob.f_21345_.m_25352_(0, (Goal)fleeBattleGoal);
                            mob.f_21346_.m_25352_(0, (Goal)new FleeBattleTargetOverride(fleeBattleGoal, mob));
                        }
                    }
                    if (ModDefinitions.PASSIVE_FLEEING_ENTITIES.contains(entity2.m_6095_())) {
                        if (!brain.f_21843_.isEmpty()) {
                            ReputationAIPackages.buildReputationFleeAI(brain, HelperMethods.fleeFactor(entity2), ReputationAIPackages.standings.getPassiveFleeing(entity2.m_6095_()));
                        } else if (entity2 instanceof Mob) {
                            mob = (Mob)entity2;
                            mob.f_21345_.m_25352_(0, (Goal)new FleeGoal((Mob)mob, HelperMethods.fleeFactor(entity2), true));
                        }
                    }
                    if (ModDefinitions.HOSTILE_ENTITIES.contains(entity2.m_6095_()) && entity2 instanceof Mob) {
                        mob = (Mob)entity2;
                        if (!brain.f_21843_.isEmpty()) {
                            ReputationAIPackages.buildReputationHostileAI((Mob)mob, brain, ReputationAIPackages.standings.getHostile(entity2.m_6095_()));
                        } else if (entity2 instanceof NeutralMob) {
                            mob.f_21346_.m_25352_(2, new ReputationAttackableTargetGoal<Player>((Mob)mob, Player.class, true, false));
                        }
                    }
                    if (ModDefinitions.PASSIVE_ENTITIES.contains(entity2.m_6095_())) {
                        if (!brain.f_21843_.isEmpty()) {
                            ReputationAIPackages.buildReputationPassiveAI(brain, 1, ReputationAIPackages.standings.getPassive(entity2.m_6095_()));
                        } else if (entity2 instanceof Mob) {
                            mob = (Mob)entity2;
                            Set goalSet = mob.f_21346_.m_148105_();
                            List<WrappedGoal> newGoals = goalSet.stream().filter(g -> {
                                Goal patt8097$temp = g.m_26015_();
                                if (patt8097$temp instanceof NearestAttackableTargetGoal) {
                                    NearestAttackableTargetGoal targetGoal = (NearestAttackableTargetGoal)patt8097$temp;
                                    return targetGoal.f_26048_ != Player.class && targetGoal.f_26048_ != ServerPlayer.class;
                                }
                                return false;
                            }).toList();
                            mob.f_21346_.m_148096_();
                            for (WrappedGoal wrappedGoal : newGoals) {
                                mob.f_21346_.m_25352_(wrappedGoal.m_26012_(), wrappedGoal.m_26015_());
                            }
                            mob.f_21346_.m_25352_(2, new ReputationPacifyHostileCustomStandingGoal<Player>((Mob)mob, Player.class, true, false, ReputationAIPackages.standings.getPassive(entity2.m_6095_())));
                        }
                    }
                }
                Map<LivingEntity, ChatTracker> map = TRACKER_MAP;
                synchronized (map) {
                    if (ServerTrackers.hasAnyIcons(entity2.m_6095_())) {
                        TRACKER_MAP.put(entity2, new ChatTracker(entity2));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        Player respawned = event.getPlayer();
        if (original instanceof ServerPlayer) {
            ServerPlayer serverOriginal = (ServerPlayer)original;
            if (respawned instanceof ServerPlayer) {
                ServerPlayer serverRespawned = (ServerPlayer)respawned;
                players.remove(serverOriginal);
                players.add(serverRespawned);
            }
        }
        Brain brain = respawned.m_6274_();
        brain.f_21844_.putIfAbsent(SensorType.f_26811_, SensorType.f_26811_.m_26827_());
        brain.f_21843_.putIfAbsent(MemoryModuleType.f_148205_, Optional.empty());
        original.reviveCaps();
        for (Faction f : ReputationHandler.getFactionMap().values()) {
            ((IReputation)respawned.getCapability(ReputationHandler.REPUTATION_CAPABILITY).orElseThrow(RuntimeException::new)).setReputation(respawned, f, ReputationHandler.getReputation(original, f));
        }
        original.invalidateCaps();
    }

    @SubscribeEvent
    public static void onServerClose(ServerStoppedEvent e) {
        ReputationHandler.emptyMaps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.END && ServerTrackers.hasAnyIcons()) {
            Map<LivingEntity, ChatTracker> map = TRACKER_MAP;
            synchronized (map) {
                ++tickTimer;
                for (ChatTracker tracker : TRACKER_MAP.values()) {
                    tracker.queryChatTimer();
                }
                if (tickTimer >= 20) {
                    ArrayList<ChatTracker> toUpdate = new ArrayList<ChatTracker>();
                    for (LivingEntity entity : TRACKER_MAP.keySet()) {
                        Level level;
                        ChatTracker tracker;
                        if (!ServerTrackers.rollRandom(RANDOM, entity.m_6095_()) || (tracker = TRACKER_MAP.get(entity)).getRecent()) continue;
                        if (!tracker.getRandom() && ServerTrackers.hasIconsForEvent(tracker.getEntityType(), "idle")) {
                            tracker.setRandom(true);
                            tracker.setChanged(true);
                            tracker.setRecent(true);
                        }
                        if (!tracker.getInRange() && ServerTrackers.hasIconsForEvent(tracker.getEntityType(), "idle_faction") && (level = entity.m_183503_()) instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            for (Faction f : ReputationHandler.getEntityFactions(entity)) {
                                if (HelperMethods.getSeenEntitiesOfFaction(serverLevel, entity, 16, (Brain<? extends LivingEntity>)entity.m_6274_(), f).isEmpty()) continue;
                                tracker.setInRange(true);
                                tracker.setChanged(true);
                                tracker.setRecent(true);
                            }
                        }
                        if (!tracker.getChanged()) continue;
                        toUpdate.add(tracker);
                    }
                    if (!toUpdate.isEmpty()) {
                        for (ServerPlayer player : players) {
                            PacketHandler.sendTo(new ChatIconMessage(toUpdate), player);
                        }
                        for (ChatTracker tracker : toUpdate) {
                            tracker.setRandom(false);
                            tracker.setInRange(false);
                            tracker.setEngage(false);
                            tracker.setFlee(false);
                            tracker.setChanged(false);
                        }
                    }
                    tickTimer = 0;
                }
            }
        }
    }
}

