/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.common.event;

import java.util.Map;
import java.util.Objects;
import mods.thecomputerizer.reputation.api.Faction;
import mods.thecomputerizer.reputation.api.ReputationHandler;
import mods.thecomputerizer.reputation.common.ai.ChatTracker;
import mods.thecomputerizer.reputation.common.event.WorldEvents;
import mods.thecomputerizer.reputation.common.objects.items.FactionCurrencyBag;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="reputation")
public class TweakEvents {
    @SubscribeEvent
    public static void livingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        Level level = entity.f_19853_;
        if (!level.f_46443_ && entity instanceof AbstractSkeleton & !entity.m_6060_() & !entity.m_5825_() && level.m_6042_().m_63951_()) {
            entity.m_7311_(100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntityLiving();
        Level level = entity.f_19853_;
        if (!level.f_46443_) {
            if (event.getSource() == DamageSource.f_19307_ && entity instanceof AbstractSkeleton && level.m_204166_(entity.m_142538_()).m_203543_().isPresent() && BiomeDictionary.hasType((ResourceKey)((ResourceKey)level.m_204166_(entity.m_142538_()).m_203543_().get()), (BiomeDictionary.Type)BiomeDictionary.Type.HOT)) {
                BlockPos pos = entity.m_142538_();
                WitherSkeleton newentity = new WitherSkeleton(EntityType.f_20497_, level);
                newentity.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    newentity.m_8061_(slot, entity.m_6844_(slot));
                }
                if (entity.m_8077_()) {
                    newentity.m_6593_(entity.m_7770_());
                }
                level.m_7967_((Entity)newentity);
            }
            LivingEntity toRemove = null;
            Map<LivingEntity, ChatTracker> map = WorldEvents.TRACKER_MAP;
            synchronized (map) {
                for (LivingEntity living : WorldEvents.TRACKER_MAP.keySet()) {
                    if (entity.m_142049_() != WorldEvents.TRACKER_MAP.get(living).getEntityID()) continue;
                    toRemove = living;
                }
                if (toRemove != null) {
                    WorldEvents.TRACKER_MAP.remove(toRemove);
                }
            }
        }
    }

    @SubscribeEvent
    public static void arrowCollide(ProjectileImpactEvent event) {
        BlockHitResult blockHit;
        BlockPos pos;
        HitResult hit;
        Projectile entity = event.getProjectile();
        Level level = entity.f_19853_;
        if (level.f_46443_ && entity.isAddedToWorld() && event.getEntity().m_6060_() && (hit = event.getRayTraceResult()) instanceof BlockHitResult && level.m_8055_(pos = (blockHit = (BlockHitResult)hit).m_82425_().m_142300_(blockHit.m_82434_())).m_60795_()) {
            level.m_46597_(pos, Blocks.f_50083_.m_49966_());
        }
    }

    @SubscribeEvent
    public static void onCraft(PlayerEvent.ItemCraftedEvent event) {
        Faction faction;
        CompoundTag tag;
        ItemStack stack = event.getCrafting();
        if (stack.m_41720_() instanceof FactionCurrencyBag && event.getCrafting().m_41782_() && (tag = event.getCrafting().m_41784_()).m_128441_("factionID") && Objects.nonNull(faction = ReputationHandler.getFaction(new ResourceLocation(tag.m_128461_("factionID"))))) {
            tag.m_128362_("playerUUID", event.getPlayer().m_142081_());
            stack.m_41714_((Component)new TextComponent("Bag of " + new TranslatableComponent(faction.getCurrencyItem().m_5524_()).getString()));
        }
    }
}

