/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.common.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mods.thecomputerizer.reputation.api.ContainerHandler;
import mods.thecomputerizer.reputation.api.Faction;
import mods.thecomputerizer.reputation.api.ReputationHandler;
import mods.thecomputerizer.reputation.common.ModDefinitions;
import mods.thecomputerizer.reputation.common.ai.ChatTracker;
import mods.thecomputerizer.reputation.common.ai.ServerTrackers;
import mods.thecomputerizer.reputation.common.capability.PlacedContainerProvider;
import mods.thecomputerizer.reputation.common.capability.ReputationProvider;
import mods.thecomputerizer.reputation.common.event.WorldEvents;
import mods.thecomputerizer.reputation.util.HelperMethods;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="reputation")
public class ReputationEvents {
    public static final List<LivingEntity> tickThese = new ArrayList<LivingEntity>();

    @SubscribeEvent
    public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof Player & !(entity instanceof FakePlayer)) {
            event.addCapability(ModDefinitions.getResource("reputation"), (ICapabilityProvider)new ReputationProvider());
        }
    }

    @SubscribeEvent
    public static void attachBlockCapabilities(AttachCapabilitiesEvent<BlockEntity> event) {
        BlockEntity block = (BlockEntity)event.getObject();
        if (block instanceof LidBlockEntity || block instanceof BarrelBlockEntity) {
            event.addCapability(ModDefinitions.getResource("container_placed"), (ICapabilityProvider)new PlacedContainerProvider());
        }
    }

    @SubscribeEvent
    public static void useBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getWorld();
        if (!level.m_5776_()) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (event.getUseBlock() != Event.Result.DENY && level.m_7702_(event.getPos()) instanceof Container && Objects.requireNonNull(level.m_7702_(event.getPos())).getCapability(PlacedContainerProvider.PLACED_CONTAINER_CAPABILITY).isPresent() && ContainerHandler.changesReputation(Objects.requireNonNull(level.m_7702_(event.getPos())))) {
                for (LivingEntity livingEntity : HelperMethods.getSeenEntitiesOfTypeInRange(serverLevel, (LivingEntity)event.getPlayer(), EntityType.f_20492_, event.getPos(), 16.0)) {
                    Villager villager = (Villager)livingEntity;
                    for (Faction faction : ReputationHandler.getEntityFactions((LivingEntity)villager)) {
                        ReputationHandler.changeReputation(event.getPlayer(), faction, -1 * faction.getActionWeighting("looting"));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void placeBlock(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor level = event.getWorld();
        if (event.getEntity() instanceof Player && (level.m_7702_(event.getPos()) instanceof LidBlockEntity || level.m_7702_(event.getPos()) instanceof BarrelBlockEntity)) {
            ContainerHandler.setChangesReputation(Objects.requireNonNull(level.m_7702_(event.getPos())), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void setTarget(LivingSetAttackTargetEvent event) {
        LivingEntity entity = event.getEntityLiving();
        Map<LivingEntity, ChatTracker> map = WorldEvents.TRACKER_MAP;
        synchronized (map) {
            ChatTracker tracker;
            if (WorldEvents.TRACKER_MAP.containsKey(entity) && !(tracker = WorldEvents.TRACKER_MAP.get(entity)).getRecent() && !tracker.getEngage() && ServerTrackers.hasIconsForEvent(tracker.getEntityType(), "engage")) {
                tracker.setEngage(true);
                tracker.setChanged(true);
                tracker.setRecent(true);
            }
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntityLiving();
        Level level = entity.f_19853_;
        if (!level.f_46443_) {
            tickThese.remove(entity);
            DamageSource source = event.getSource();
            Player player = null;
            if (source.m_7639_() instanceof Player) {
                player = (Player)source.m_7639_();
            } else if (source.m_7640_() instanceof Player) {
                player = (Player)source.m_7640_();
            }
            if (player != null) {
                for (Faction faction : ReputationHandler.getEntityFactions(entity)) {
                    for (LivingEntity livingEntity : HelperMethods.getSeenEntitiesOfFaction((ServerLevel)level, entity, 16, (Brain<? extends LivingEntity>)entity.m_6274_(), faction)) {
                        ReputationHandler.changeReputation(player, faction, -1 * faction.getActionWeighting("murder"));
                        for (Faction enemy : faction.getEnemies()) {
                            if (!enemy.isMember(livingEntity)) continue;
                            ReputationHandler.changeReputation(player, enemy, faction.getActionWeighting("murder"));
                        }
                    }
                }
            }
        }
    }
}

