/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.common.capability;

import java.util.HashMap;
import mods.thecomputerizer.reputation.api.Faction;
import mods.thecomputerizer.reputation.api.ReputationHandler;
import mods.thecomputerizer.reputation.api.capability.IReputation;
import mods.thecomputerizer.reputation.common.network.PacketHandler;
import mods.thecomputerizer.reputation.common.network.SyncReputationMessage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ReputationCapability
implements IReputation {
    private HashMap<Faction, Integer> FACTIONS = new HashMap();
    private HashMap<String, Integer> FACTION_IDS = new HashMap();

    @Override
    public HashMap<Faction, Integer> allReputations() {
        return this.FACTIONS;
    }

    @Override
    public int getReputation(Faction faction) {
        if (!this.FACTION_IDS.containsKey(faction.getID().toString())) {
            this.FACTION_IDS.put(faction.getID().toString(), faction.getDefaultRep());
        }
        return this.FACTION_IDS.get(faction.getID().toString());
    }

    @Override
    public void setReputation(Player player, Faction faction, int reputation) {
        this.FACTIONS.put(faction, reputation);
        this.FACTION_IDS.put(faction.getID().toString(), reputation);
        if (player instanceof ServerPlayer) {
            PacketHandler.sendTo(new SyncReputationMessage(faction, reputation), (ServerPlayer)player);
        }
    }

    @Override
    public void changeReputation(Player player, Faction faction, int reputation) {
        int base = this.FACTION_IDS.containsKey(faction.getID().toString()) ? this.FACTION_IDS.get(faction.getID().toString()).intValue() : faction.getDefaultRep();
        this.FACTION_IDS.put(faction.getID().toString(), base + reputation);
        this.FACTIONS.put(faction, base + reputation);
        if (player instanceof ServerPlayer) {
            PacketHandler.sendTo(new SyncReputationMessage(faction, base + reputation), (ServerPlayer)player);
        }
    }

    @Override
    public CompoundTag writeNBT(CompoundTag nbt) {
        for (Faction entry : this.FACTIONS.keySet()) {
            if (nbt.m_128441_(entry.getID().toString())) continue;
            nbt.m_128405_(entry.getID().toString(), this.FACTIONS.get(entry).intValue());
        }
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag nbt) {
        this.FACTIONS = new HashMap();
        this.FACTION_IDS = new HashMap();
        for (Faction f : ReputationHandler.getFactionMap().values()) {
            if (nbt.m_128441_(f.getID().toString())) {
                this.FACTIONS.put(f, nbt.m_128451_(f.getID().toString()));
                this.FACTION_IDS.put(f.getID().toString(), nbt.m_128451_(f.getID().toString()));
                continue;
            }
            this.FACTIONS.put(f, f.getDefaultRep());
            this.FACTION_IDS.put(f.getID().toString(), f.getDefaultRep());
        }
    }
}

