/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.common.capability;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mods.thecomputerizer.reputation.api.Faction;
import mods.thecomputerizer.reputation.api.capability.IPlayerFaction;
import mods.thecomputerizer.reputation.common.network.PacketHandler;
import mods.thecomputerizer.reputation.common.network.SyncFactionPlayersMessage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;

public class PlayerFaction
implements IPlayerFaction {
    private final Faction faction;
    private final List<UUID> PLAYER_UUIDS;

    public PlayerFaction(Faction faction) {
        this.faction = faction;
        this.PLAYER_UUIDS = new ArrayList<UUID>();
    }

    @Override
    public Faction getFaction() {
        return this.faction;
    }

    @Override
    public boolean isPlayerAttached(Player player) {
        return this.PLAYER_UUIDS.contains(player.m_142081_());
    }

    @Override
    public boolean addPlayer(Player player) {
        if (this.isPlayerAttached(player)) {
            return false;
        }
        this.PLAYER_UUIDS.add(player.m_142081_());
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && player instanceof ServerPlayer) {
            PacketHandler.sendTo(new SyncFactionPlayersMessage(this.faction, this.PLAYER_UUIDS), (ServerPlayer)player);
        }
        return true;
    }

    @Override
    public boolean removePlayer(Player player) {
        if (!this.isPlayerAttached(player)) {
            return false;
        }
        this.PLAYER_UUIDS.remove(player.m_142081_());
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && player instanceof ServerPlayer) {
            PacketHandler.sendTo(new SyncFactionPlayersMessage(this.faction, this.PLAYER_UUIDS), (ServerPlayer)player);
        }
        return true;
    }

    @Override
    public CompoundTag writeNBT(CompoundTag nbt) {
        nbt.m_128405_("player:size", this.PLAYER_UUIDS.size());
        int i = 0;
        for (UUID uuid : this.PLAYER_UUIDS) {
            nbt.m_128362_("player:" + i, uuid);
            ++i;
        }
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag nbt) {
        if (nbt.m_128441_("player:size")) {
            for (int i = 0; i < nbt.m_128451_("player:size"); ++i) {
                this.PLAYER_UUIDS.add(nbt.m_128342_("player:" + i));
            }
        }
    }
}

