/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.common.ai.goals;

import java.util.Comparator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mods.thecomputerizer.reputation.api.Faction;
import mods.thecomputerizer.reputation.api.PlayerFactionHandler;
import mods.thecomputerizer.reputation.api.ReputationHandler;
import mods.thecomputerizer.reputation.client.event.RenderEvents;
import mods.thecomputerizer.reputation.common.network.FleeIconMessage;
import mods.thecomputerizer.reputation.common.network.PacketHandler;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class FleeGoal
extends Goal {
    @Nullable
    protected Path path;
    protected final PathNavigation pathNav;
    private final Mob mob;
    private Player player;
    private final double speed;
    private final boolean checkReputation;
    private boolean startFlee;
    private final Random random;

    public FleeGoal(Mob mob, double speed, boolean checkReputation) {
        this.mob = mob;
        this.player = null;
        this.speed = speed;
        this.checkReputation = checkReputation;
        this.startFlee = false;
        this.random = new Random();
        this.pathNav = mob.m_21573_();
    }

    public boolean m_8036_() {
        if (this.checkReputation) {
            return this.checkWithReputation();
        }
        return this.checkWithPlayerReputation();
    }

    private boolean checkWithReputation() {
        Level level = this.mob.f_19853_;
        List<Player> list = level.m_6907_().stream().filter(EntitySelector.f_20408_).filter(p -> this.mob.m_19950_((Entity)p, 16.0)).filter(p -> p.getCapability(ReputationHandler.REPUTATION_CAPABILITY).isPresent()).sorted(Comparator.comparingDouble(arg_0 -> ((Mob)this.mob).m_20280_(arg_0))).toList();
        if (!list.isEmpty()) {
            Player nearest = list.get(0);
            for (Faction f : ReputationHandler.getEntityFactions((LivingEntity)this.mob)) {
                int reputation = ReputationHandler.getReputation(nearest, f);
                if (reputation <= f.getLowerRep()) {
                    this.player = nearest;
                    Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)((PathfinderMob)this.mob), (int)16, (int)7, (Vec3)this.player.m_20182_());
                    if (vec3 == null) {
                        return false;
                    }
                    if (this.player.m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) < this.player.m_20280_((Entity)this.mob)) {
                        return false;
                    }
                    this.pathNav.m_26517_(this.speed);
                    this.path = this.pathNav.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
                    if (this.path == null) continue;
                    this.startFlee = true;
                    return true;
                }
                this.startFlee = false;
                return false;
            }
        }
        this.startFlee = false;
        return false;
    }

    private boolean checkWithPlayerReputation() {
        float percent = this.mob.m_21223_() / this.mob.m_21233_();
        if (this.player != null || this.mob.m_142581_() instanceof Player) {
            LivingEntity livingEntity = this.mob.m_142581_();
            if (livingEntity instanceof Player) {
                Player p;
                this.player = p = (Player)livingEntity;
            }
            if (this.mob.m_20270_((Entity)this.player) <= 28.0f && percent <= 0.5f) {
                boolean inFaction = ReputationHandler.getEntityFactions((LivingEntity)this.mob).isEmpty();
                for (Faction f : ReputationHandler.getEntityFactions((LivingEntity)this.mob)) {
                    if (!PlayerFactionHandler.isPlayerInFaction(this.player, f)) continue;
                    inFaction = true;
                }
                if (!inFaction && this.random.nextFloat(51.0f) >= 0.0f && !this.startFlee) {
                    this.startFlee = true;
                    if (this.player instanceof ServerPlayer) {
                        PacketHandler.sendTo(new FleeIconMessage(this.mob.m_142081_(), true), (ServerPlayer)this.player);
                    } else if (!RenderEvents.fleeingMobs.contains(this.mob.m_142081_())) {
                        RenderEvents.fleeingMobs.add(this.mob.m_142081_());
                    }
                }
                if (this.startFlee) {
                    Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)((PathfinderMob)this.mob), (int)32, (int)7, (Vec3)this.player.m_20182_());
                    if (vec3 == null) {
                        return false;
                    }
                    if (this.player.m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) < this.player.m_20280_((Entity)this.mob)) {
                        return false;
                    }
                    this.pathNav.m_26517_(this.speed);
                    this.path = this.pathNav.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
                    return this.path != null;
                }
            } else if (this.startFlee) {
                this.startFlee = false;
                if (this.player instanceof ServerPlayer) {
                    PacketHandler.sendTo(new FleeIconMessage(this.mob.m_142081_(), false), (ServerPlayer)this.player);
                } else {
                    RenderEvents.fleeingMobs.remove(this.mob.m_142081_());
                }
            }
        } else if (this.startFlee) {
            this.startFlee = false;
            if (this.player != null && this.player instanceof ServerPlayer) {
                PacketHandler.sendTo(new FleeIconMessage(this.mob.m_142081_(), false), (ServerPlayer)this.player);
            } else {
                RenderEvents.fleeingMobs.remove(this.mob.m_142081_());
            }
        }
        if (percent <= 0.5f && this.startFlee && !this.mob.m_21224_() && this.mob.m_20270_((Entity)this.player) > 28.0f) {
            for (Faction f : ReputationHandler.getEntityFactions((LivingEntity)this.mob)) {
                ReputationHandler.changeReputation(this.player, f, -1 * f.getActionWeighting("fleeing"));
            }
            this.mob.m_146870_();
        }
        return this.startFlee;
    }

    public boolean m_8045_() {
        Vec3 vec3;
        if (this.pathNav.m_26571_() && this.startFlee && (vec3 = DefaultRandomPos.m_148407_((PathfinderMob)((PathfinderMob)this.mob), (int)32, (int)7, (Vec3)this.player.m_20182_())) != null && !(this.player.m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) < this.player.m_20280_((Entity)this.mob))) {
            this.path = this.pathNav.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
            this.pathNav.m_26536_(this.path, this.speed);
        }
        return this.startFlee;
    }

    public void m_8056_() {
        this.pathNav.m_26536_(this.path, this.speed);
    }

    public void m_8041_() {
        this.player = null;
    }

    public void m_8037_() {
        this.pathNav.m_26517_(this.speed);
        this.mob.m_21573_().m_26517_(this.speed);
    }
}

