/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.common.ai.goals;

import java.util.EnumSet;
import java.util.Map;
import mods.thecomputerizer.reputation.api.Faction;
import mods.thecomputerizer.reputation.api.ReputationHandler;
import mods.thecomputerizer.reputation.common.ai.ChatTracker;
import mods.thecomputerizer.reputation.common.ai.ReputationAIPackages;
import mods.thecomputerizer.reputation.common.ai.ServerTrackers;
import mods.thecomputerizer.reputation.common.event.WorldEvents;
import mods.thecomputerizer.reputation.common.network.FleeIconMessage;
import mods.thecomputerizer.reputation.common.network.PacketHandler;
import mods.thecomputerizer.reputation.util.HelperMethods;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class FleeBattleGoal
extends Goal {
    private final PathfinderMob mob;
    private final float fleeFactor;
    private final PathNavigation pathNav;
    private Path path;
    private Player fleeFrom;
    public boolean isFleeing;

    public FleeBattleGoal(PathfinderMob mob, float fleeFactor) {
        this.mob = mob;
        this.pathNav = mob.m_21573_();
        this.fleeFactor = fleeFactor;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.isFleeing = false;
    }

    private boolean escaped() {
        if (this.fleeFrom != null && this.mob.m_20270_((Entity)this.fleeFrom) >= 28.0f) {
            for (Faction f : ReputationHandler.getEntityFactions((LivingEntity)this.mob)) {
                ReputationHandler.changeReputation(this.fleeFrom, f, -1 * f.getActionWeighting("fleeing"));
            }
            this.mob.m_146870_();
            this.isFleeing = false;
            return true;
        }
        return false;
    }

    private boolean ensureCorrectConditions(Player player) {
        return this.mob.m_21223_() / this.mob.m_21233_() <= 0.5f && this.mob.m_20270_((Entity)player) <= 32.0f && HelperMethods.ensureSeparateFactions((LivingEntity)this.mob, player) && HelperMethods.isPlayerInCustomStanding((LivingEntity)this.mob, player, ReputationAIPackages.standings.getInjured(this.mob.m_6095_()));
    }

    public boolean m_8036_() {
        Player player;
        LivingEntity livingEntity = this.mob.m_142581_();
        if (livingEntity instanceof Player && this.ensureCorrectConditions(player = (Player)livingEntity)) {
            this.isFleeing = true;
            this.fleeFrom = player;
            PacketHandler.sendTo(new FleeIconMessage(this.mob.m_142081_(), true), (ServerPlayer)this.fleeFrom);
            Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this.mob, (int)32, (int)16, (Vec3)this.fleeFrom.m_20182_());
            if (vec3 == null) {
                return false;
            }
            if (this.fleeFrom.m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) < this.fleeFrom.m_20280_((Entity)this.mob)) {
                return false;
            }
            this.path = this.pathNav.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
            return this.path != null;
        }
        return false;
    }

    public boolean m_8045_() {
        if (!this.isFleeing) {
            return false;
        }
        if (!this.ensureCorrectConditions(this.fleeFrom)) {
            this.isFleeing = false;
        }
        return this.isFleeing;
    }

    public void m_8056_() {
        this.pathNav.m_26536_(this.path, (double)this.fleeFactor);
    }

    public void m_8041_() {
        if (!this.mob.m_146910_() && !this.ensureCorrectConditions(this.fleeFrom)) {
            PacketHandler.sendTo(new FleeIconMessage(this.mob.m_142081_(), false), (ServerPlayer)this.fleeFrom);
        }
        this.fleeFrom = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_8037_() {
        if (!this.escaped()) {
            if (this.pathNav.m_26571_() || this.path == null) {
                Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this.mob, (int)32, (int)16, (Vec3)this.fleeFrom.m_20182_());
                if (vec3 != null && this.fleeFrom.m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) >= this.fleeFrom.m_20280_((Entity)this.mob)) {
                    this.path = this.pathNav.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
                }
                this.pathNav.m_26536_(this.path, (double)this.fleeFactor);
            } else {
                this.mob.m_21573_().m_26517_((double)this.fleeFactor);
            }
            Map<LivingEntity, ChatTracker> map = WorldEvents.TRACKER_MAP;
            synchronized (map) {
                ChatTracker tracker;
                if (WorldEvents.TRACKER_MAP.containsKey(this.mob) && !(tracker = WorldEvents.TRACKER_MAP.get(this.mob)).getRecent() && !tracker.getFlee() && ServerTrackers.hasIconsForEvent(tracker.getEntityType(), "flee")) {
                    tracker.setFlee(true);
                    tracker.setChanged(true);
                    tracker.setRecent(true);
                }
            }
        }
    }
}

