/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.common.ai;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Random;
import java.util.stream.Collectors;
import mods.thecomputerizer.reputation.Reputation;
import mods.thecomputerizer.reputation.common.network.PacketHandler;
import mods.thecomputerizer.reputation.common.network.SyncChatIconsMessage;
import mods.thecomputerizer.reputation.util.JsonUtil;
import mods.thecomputerizer.reputation.util.NetworkUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;

public class ServerTrackers {
    public static final HashMap<EntityType<?>, Data> SERVER_ICON_DATA = new HashMap();
    private static float DEFAULT_CHANCE;
    private static float DEFAULT_CHANCE_VARIATION;
    public static long DEFAULT_COOLDOWN;
    public static long DEFAULT_DISPLAY;

    public static void initTimers(JsonElement element) {
        JsonObject json = element instanceof JsonObject ? element.getAsJsonObject() : null;
        DEFAULT_CHANCE = JsonUtil.potentialFloat(json, "default_chance").orElse(Float.valueOf(0.5f)).floatValue();
        DEFAULT_CHANCE_VARIATION = JsonUtil.potentialFloat(json, "default_chance_variation").orElse(Float.valueOf(0.1f)).floatValue();
        DEFAULT_COOLDOWN = JsonUtil.potentialLong(json, "default_icon_cooldown_time").orElse(100L);
        DEFAULT_DISPLAY = JsonUtil.potentialLong(json, "default_icon_display_time").orElse(50L);
    }

    public static void parseChatIcons(List<JsonElement> jsons) {
        SERVER_ICON_DATA.clear();
        SERVER_ICON_DATA.putAll(jsons.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(Data::new).filter(Data::isValid).collect(Collectors.toMap(Data::getType, data -> data)));
    }

    public static void syncChatIcons(ServerPlayer player) {
        if (!SERVER_ICON_DATA.isEmpty()) {
            PacketHandler.sendTo(new SyncChatIconsMessage(new ArrayList<Data>(SERVER_ICON_DATA.values())), player);
        }
    }

    public static boolean hasAnyIcons() {
        for (EntityType<?> type : SERVER_ICON_DATA.keySet()) {
            if (!ServerTrackers.hasAnyIcons(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnyIcons(EntityType<?> type) {
        return SERVER_ICON_DATA.containsKey(type);
    }

    public static boolean hasIconsForEvent(EntityType<?> type, String event) {
        return SERVER_ICON_DATA.containsKey(type) && SERVER_ICON_DATA.get(type).hasEventForEntity(type, event);
    }

    public static long getQuery(EntityType<?> type) {
        return ServerTrackers.SERVER_ICON_DATA.get(type).queryTimer;
    }

    public static boolean rollRandom(Random rand, EntityType<?> type) {
        float rand2;
        float max;
        float min = Math.max(0.0f, ServerTrackers.SERVER_ICON_DATA.get(type).chance - ServerTrackers.SERVER_ICON_DATA.get(type).chanceVariation);
        float rand1 = rand.nextFloat(min, max = Math.min(1.0f, ServerTrackers.SERVER_ICON_DATA.get(type).chance + ServerTrackers.SERVER_ICON_DATA.get(type).chanceVariation));
        return rand1 > (rand2 = rand.nextFloat());
    }

    public static class Data {
        private final EntityType<?> type;
        private final Map<String, List<ResourceLocation>> iconMap;
        private final long queryTimer;
        private final long displayTimer;
        private final float chance;
        private final float chanceVariation;

        private Data(JsonObject json) {
            this.type = JsonUtil.potentialEntity(json, "name").orElse(null);
            this.iconMap = JsonUtil.potentialResourceMap(json, true, "textures/chat/{}.png", "idle", "idle_faction", "engage", "flee");
            Optional<Float> potentialChance = JsonUtil.potentialFloat(json, "chance");
            this.chance = potentialChance.orElse(Float.valueOf(DEFAULT_CHANCE)).floatValue();
            potentialChance = JsonUtil.potentialFloat(json, "chance_variation");
            this.chanceVariation = potentialChance.orElse(Float.valueOf(DEFAULT_CHANCE_VARIATION)).floatValue();
            OptionalLong potentialTime = JsonUtil.potentialLong(json, "query_timer");
            this.queryTimer = potentialTime.orElse(DEFAULT_COOLDOWN);
            potentialTime = JsonUtil.potentialLong(json, "display_timer");
            this.displayTimer = potentialTime.orElse(DEFAULT_DISPLAY);
            Reputation.logInfo("Read in entity {} with {} icon sets", this.type, this.iconMap.size());
        }

        private boolean isValid() {
            return !this.iconMap.isEmpty();
        }

        private boolean hasEventForEntity(EntityType<?> type, String event) {
            return Objects.nonNull(type) && this.iconMap.containsKey(event);
        }

        public EntityType<?> getType() {
            return this.type;
        }

        public void encode(FriendlyByteBuf buf) {
            NetworkUtil.writeEntityType(buf, this.type);
            NetworkUtil.writeGenericMap(buf, this.iconMap, NetworkUtil::writeString, (buf1, list) -> NetworkUtil.writeGenericList(buf1, list, FriendlyByteBuf::m_130085_));
            buf.writeLong(this.displayTimer);
        }
    }
}

