/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.common.ai;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import mods.thecomputerizer.reputation.api.Faction;
import mods.thecomputerizer.reputation.api.PlayerFactionHandler;
import mods.thecomputerizer.reputation.api.ReputationHandler;
import mods.thecomputerizer.reputation.client.event.RenderEvents;
import mods.thecomputerizer.reputation.common.ModDefinitions;
import mods.thecomputerizer.reputation.common.ai.ChatTracker;
import mods.thecomputerizer.reputation.common.ai.ReputationMemoryModule;
import mods.thecomputerizer.reputation.common.ai.ServerTrackers;
import mods.thecomputerizer.reputation.common.event.WorldEvents;
import mods.thecomputerizer.reputation.common.network.FleeIconMessage;
import mods.thecomputerizer.reputation.common.network.PacketHandler;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class ReputationSensor
extends Sensor<LivingEntity> {
    private boolean startFlee = false;
    private final Random random = new Random();
    private Player player = null;

    @NotNull
    public Set<MemoryModuleType<?>> m_7163_() {
        return ImmutableSet.of((Object)((MemoryModuleType)ReputationMemoryModule.NEAREST_PLAYER_BAD_REPUTATION.get()), (Object)((MemoryModuleType)ReputationMemoryModule.NEAREST_PLAYER_NEUTRAL_REPUTATION.get()), (Object)((MemoryModuleType)ReputationMemoryModule.NEAREST_PLAYER_GOOD_REPUTATION.get()), (Object)((MemoryModuleType)ReputationMemoryModule.FLEE_FROM_PLAYER.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void m_5578_(ServerLevel level, LivingEntity entity) {
        List<ServerPlayer> list = level.m_6907_().stream().filter(EntitySelector.f_20408_).filter(p -> entity.m_19950_((Entity)p, 16.0)).filter(p -> ReputationSensor.m_26803_((LivingEntity)entity, (LivingEntity)p)).filter(p -> p.getCapability(ReputationHandler.REPUTATION_CAPABILITY).isPresent()).sorted(Comparator.comparingDouble(arg_0 -> ((LivingEntity)entity).m_20280_(arg_0))).toList();
        if (!list.isEmpty()) {
            Player nearest = (Player)list.get(0);
            for (Faction f : ReputationHandler.getEntityFactions(entity)) {
                int reputation = ReputationHandler.getReputation(nearest, f);
                if (reputation <= f.getLowerRep()) {
                    entity.m_6274_().m_21879_((MemoryModuleType)ReputationMemoryModule.NEAREST_PLAYER_BAD_REPUTATION.get(), (Object)nearest);
                    entity.m_6274_().m_21886_((MemoryModuleType)ReputationMemoryModule.NEAREST_PLAYER_NEUTRAL_REPUTATION.get(), Optional.empty());
                    entity.m_6274_().m_21886_((MemoryModuleType)ReputationMemoryModule.NEAREST_PLAYER_GOOD_REPUTATION.get(), Optional.empty());
                    continue;
                }
                if (reputation < f.getHigherRep()) {
                    entity.m_6274_().m_21879_((MemoryModuleType)ReputationMemoryModule.NEAREST_PLAYER_NEUTRAL_REPUTATION.get(), (Object)nearest);
                    entity.m_6274_().m_21886_((MemoryModuleType)ReputationMemoryModule.NEAREST_PLAYER_BAD_REPUTATION.get(), Optional.empty());
                    entity.m_6274_().m_21886_((MemoryModuleType)ReputationMemoryModule.NEAREST_PLAYER_GOOD_REPUTATION.get(), Optional.empty());
                    continue;
                }
                entity.m_6274_().m_21879_((MemoryModuleType)ReputationMemoryModule.NEAREST_PLAYER_GOOD_REPUTATION.get(), (Object)nearest);
                entity.m_6274_().m_21886_((MemoryModuleType)ReputationMemoryModule.NEAREST_PLAYER_BAD_REPUTATION.get(), Optional.empty());
                entity.m_6274_().m_21886_((MemoryModuleType)ReputationMemoryModule.NEAREST_PLAYER_NEUTRAL_REPUTATION.get(), Optional.empty());
            }
        }
        if (ModDefinitions.INJURED_FLEEING_ENTITIES.contains(entity.m_6095_()) && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            float percent = mob.m_21223_() / mob.m_21233_();
            if (this.player != null || mob.m_142581_() instanceof Player) {
                Object reputation = mob.m_142581_();
                if (reputation instanceof Player) {
                    Player p2;
                    this.player = p2 = (Player)reputation;
                }
                if (mob.m_20270_((Entity)this.player) <= 28.0f && percent <= 0.5f) {
                    boolean inFaction = ReputationHandler.getEntityFactions((LivingEntity)mob).isEmpty();
                    for (Faction f : ReputationHandler.getEntityFactions((LivingEntity)mob)) {
                        if (!PlayerFactionHandler.isPlayerInFaction(this.player, f)) continue;
                        inFaction = true;
                    }
                    if (!inFaction && this.random.nextFloat(21.0f) >= 2.0f && !this.startFlee) {
                        this.startFlee = true;
                        if (this.player instanceof ServerPlayer) {
                            PacketHandler.sendTo(new FleeIconMessage(mob.m_142081_(), true), (ServerPlayer)this.player);
                        } else if (!RenderEvents.fleeingMobs.contains(mob.m_142081_())) {
                            RenderEvents.fleeingMobs.add(mob.m_142081_());
                        }
                    }
                    reputation = WorldEvents.TRACKER_MAP;
                    synchronized (reputation) {
                        ChatTracker tracker;
                        if (this.startFlee && WorldEvents.TRACKER_MAP.containsKey(mob) && !(tracker = WorldEvents.TRACKER_MAP.get(mob)).getRecent() && !tracker.getFlee() && ServerTrackers.hasIconsForEvent(tracker.getEntityType(), "flee")) {
                            tracker.setFlee(true);
                            tracker.setChanged(true);
                            tracker.setRecent(true);
                        }
                    }
                } else if (this.startFlee) {
                    this.startFlee = false;
                    if (this.player instanceof ServerPlayer) {
                        PacketHandler.sendTo(new FleeIconMessage(mob.m_142081_(), false), (ServerPlayer)this.player);
                    } else {
                        RenderEvents.fleeingMobs.remove(mob.m_142081_());
                    }
                    if (percent <= 0.5f) {
                        for (Faction f : ReputationHandler.getEntityFactions((LivingEntity)mob)) {
                            ReputationHandler.changeReputation(this.player, f, -1 * f.getActionWeighting("fleeing"));
                        }
                        mob.m_146870_();
                    }
                }
            } else if (this.startFlee) {
                this.startFlee = false;
                if (this.player != null && this.player instanceof ServerPlayer) {
                    PacketHandler.sendTo(new FleeIconMessage(mob.m_142081_(), false), (ServerPlayer)this.player);
                } else {
                    RenderEvents.fleeingMobs.remove(mob.m_142081_());
                }
            }
            if (this.startFlee) {
                entity.m_6274_().m_21879_((MemoryModuleType)ReputationMemoryModule.FLEE_FROM_PLAYER.get(), (Object)this.player);
            } else {
                entity.m_6274_().m_21886_((MemoryModuleType)ReputationMemoryModule.FLEE_FROM_PLAYER.get(), Optional.empty());
            }
        }
    }
}

