/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.common.ai;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Optional;
import mods.thecomputerizer.reputation.common.ai.ReputationMemoryModule;
import mods.thecomputerizer.reputation.common.ai.ReputationSenorType;
import mods.thecomputerizer.reputation.common.ai.ReputationStandings;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BecomePassiveIfMemoryPresent;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class ReputationAIPackages {
    public static ReputationStandings standings;

    public static void buildMobLists(JsonElement data) {
        standings = new ReputationStandings(data);
    }

    public static void buildReputationSensor(Brain<? extends LivingEntity> brain) {
        brain.f_21843_.put((MemoryModuleType)ReputationMemoryModule.NEAREST_PLAYER_BAD_REPUTATION.get(), Optional.empty());
        brain.f_21843_.put((MemoryModuleType)ReputationMemoryModule.NEAREST_PLAYER_NEUTRAL_REPUTATION.get(), Optional.empty());
        brain.f_21843_.put((MemoryModuleType)ReputationMemoryModule.NEAREST_PLAYER_GOOD_REPUTATION.get(), Optional.empty());
        brain.f_21843_.put((MemoryModuleType)ReputationMemoryModule.FLEE_FROM_PLAYER.get(), Optional.empty());
        brain.f_21844_.put((SensorType)ReputationSenorType.NEAREST_PLAYER_REPUTATION.get(), ((SensorType)ReputationSenorType.NEAREST_PLAYER_REPUTATION.get()).m_26827_());
    }

    public static void buildReputationFleeAI(Brain brain, float f, String reputationBound) {
        for (Activity activity : Arrays.asList(Activity.f_37984_, Activity.f_37978_, Activity.f_37983_, Activity.f_37979_, Activity.f_37982_, Activity.f_37987_)) {
            brain.m_21900_(activity, ReputationAIPackages.getFleePackage(f, reputationBound));
        }
    }

    public static void buildReputationInjuredAI(Brain brain, float f) {
        for (Activity activity : Arrays.asList(Activity.f_37984_, Activity.f_37978_, Activity.f_37983_, Activity.f_37979_, Activity.f_37982_, Activity.f_37987_)) {
            brain.m_21900_(activity, ReputationAIPackages.getInjuredFleePackage(f));
        }
    }

    public static void buildReputationPassiveAI(Brain brain, int time, String reputationBound) {
        brain.m_21900_(Activity.f_37978_, ReputationAIPackages.getPassivePackage(time, reputationBound));
        brain.m_21900_(Activity.f_37988_, ReputationAIPackages.getPassivePackage(time, reputationBound));
    }

    public static void buildReputationHostileAI(Mob mob, Brain brain, String reputationBound) {
        brain.m_21900_(Activity.f_37979_, ReputationAIPackages.getHostilePackage(mob, (Brain<? extends LivingEntity>)brain, reputationBound));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? extends LivingEntity>>> getFleePackage(float f, String reputationBound) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)SetWalkTargetAwayFrom.m_24019_(ReputationMemoryModule.getNearestModuleFromString(reputationBound), (float)f, (int)6, (boolean)false)));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? extends LivingEntity>>> getInjuredFleePackage(float f) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)SetWalkTargetAwayFrom.m_24019_((MemoryModuleType)((MemoryModuleType)ReputationMemoryModule.FLEE_FROM_PLAYER.get()), (float)f, (int)32, (boolean)false)));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? extends LivingEntity>>> getPassivePackage(int time, String reputationBound) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new BecomePassiveIfMemoryPresent(ReputationMemoryModule.getNearestModuleFromString(reputationBound), time)));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? extends LivingEntity>>> getHostilePackage(Mob mob, Brain<? extends LivingEntity> brain, String reputationBound) {
        return ImmutableList.of((Object)Pair.of((Object)1, (Object)new StartAttacking(attackFunction -> {
            Optional optional = brain.m_21952_(ReputationMemoryModule.getNearestModuleFromString(reputationBound));
            return optional.isPresent() && Sensor.m_148312_((LivingEntity)mob, (LivingEntity)((LivingEntity)optional.get())) ? optional : Optional.empty();
        })));
    }
}

