/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class RenderIcon {
    public static List<RenderIcon> renderable = new ArrayList<RenderIcon>();
    private ResourceLocation ICON_LOCATION = null;
    private ResourceLocation FACTION = null;
    private int fadeCount = 1000;
    private boolean activated = false;
    private int timer = 0;
    private int startDelayCount = 0;

    public static void setIcon(ResourceLocation icon, ResourceLocation faction) {
        RenderIcon toRender = new RenderIcon();
        toRender.ICON_LOCATION = icon;
        toRender.FACTION = faction;
        toRender.activated = true;
        renderable.add(toRender);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (!renderable.isEmpty()) {
            renderable = renderable.stream().filter(icon -> icon.ICON_LOCATION != null).collect(Collectors.toList());
            for (RenderIcon icon2 : renderable) {
                if (icon2.activated) {
                    ++icon2.timer;
                    ++icon2.startDelayCount;
                    if (icon2.startDelayCount > 0 && icon2.fadeCount > 1) {
                        icon2.fadeCount -= 70;
                        if (icon2.fadeCount < 1) {
                            icon2.fadeCount = 1;
                        }
                    }
                    if (icon2.timer <= 100) continue;
                    icon2.activated = false;
                    continue;
                }
                if (icon2.fadeCount >= 1000) continue;
                icon2.fadeCount += 70;
                if (icon2.fadeCount <= 1000) continue;
                icon2.ICON_LOCATION = null;
            }
        }
    }

    @SubscribeEvent
    public static void renderIcons(RenderGameOverlayEvent.Post e) {
        if (!renderable.isEmpty()) {
            RenderIcon toRemove = null;
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            if (e.getType() == RenderGameOverlayEvent.ElementType.ALL) {
                renderable = renderable.stream().filter(icon -> icon.ICON_LOCATION != null).collect(Collectors.toList());
                for (RenderIcon icon2 : renderable) {
                    if (player != null && icon2.ICON_LOCATION != null) {
                        int x = mc.m_91268_().m_85445_();
                        int y = mc.m_91268_().m_85446_();
                        if (icon2.fadeCount == 1000 || mc.f_91080_ != null) continue;
                        float opacity = (int)(17.0f - (float)icon2.fadeCount / 80.0f);
                        opacity = opacity * 1.15f / 15.0f;
                        int sizeX = 20;
                        int sizeY = 20;
                        float scaleY = 0.36f;
                        float scaleX = 0.36f;
                        float posY = (float)y / scaleY / 2.0f - (float)sizeY * scaleY / 2.0f;
                        float posX = (float)x / scaleX - (float)sizeX * scaleX - 25.0f / scaleX;
                        e.getMatrixStack().m_85836_();
                        e.getMatrixStack().m_85841_(scaleX, scaleY, 1.0f);
                        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.max(0.0f, Math.min(0.95f, opacity)));
                        RenderSystem.m_157456_((int)0, (ResourceLocation)icon2.ICON_LOCATION);
                        GuiComponent.m_93133_((PoseStack)e.getMatrixStack(), (int)((int)posX), (int)((int)posY), (float)0.0f, (float)0.0f, (int)sizeX, (int)sizeY, (int)sizeX, (int)sizeY);
                        e.getMatrixStack().m_85849_();
                        e.getMatrixStack().m_85836_();
                        scaleY = 0.6f;
                        scaleX = 0.6f;
                        posY = (float)y / scaleY / 2.0f - (float)sizeY * scaleY / 2.0f;
                        posX = (float)x / scaleX - (float)sizeX * scaleX - 16.0f;
                        e.getMatrixStack().m_85841_(scaleX, scaleY, 1.0f);
                        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.max(0.0f, Math.min(0.95f, opacity)));
                        RenderSystem.m_157456_((int)0, (ResourceLocation)icon2.FACTION);
                        GuiComponent.m_93133_((PoseStack)e.getMatrixStack(), (int)((int)posX), (int)((int)posY), (float)0.0f, (float)0.0f, (int)sizeX, (int)sizeY, (int)sizeX, (int)sizeY);
                        e.getMatrixStack().m_85849_();
                        continue;
                    }
                    toRemove = icon2;
                }
                renderable.remove(toRemove);
            }
        }
    }
}

