/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.client.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import mods.thecomputerizer.reputation.api.Faction;
import mods.thecomputerizer.reputation.api.ReputationHandler;
import mods.thecomputerizer.reputation.client.ClientTrackers;
import mods.thecomputerizer.reputation.config.ClientConfigHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class RenderEvents {
    public static final int RENDER_DISTANCE = 64;
    public static final ResourceLocation BAD_REPUTATION = new ResourceLocation("reputation", "textures/icons/reputation_decrease.png");
    public static final ResourceLocation GOOD_REPUTATION = new ResourceLocation("reputation", "textures/icons/reputation_increase.png");
    public static final ResourceLocation FLEE = new ResourceLocation("reputation", "textures/icons/flee.png");
    public static HashMap<ResourceLocation, Faction> CLIENT_FACTIONS = new HashMap();
    public static HashMap<Faction, Integer> CLIENT_FACTIONS_REPUTATION = new HashMap();
    public static ArrayList<UUID> fleeingMobs = new ArrayList();
    private static int tickTimer = 0;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent e) {
        if (++tickTimer == 40) {
            tickTimer = 0;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderName(RenderNameplateEvent e) {
        LivingEntity living;
        Entity entity;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (entity = e.getEntity()) instanceof LivingEntity && (living = (LivingEntity)entity).m_20270_((Entity)player) <= 64.0f) {
            if (!fleeingMobs.contains(living.m_142081_())) {
                ResourceLocation chatIcon;
                if (((Boolean)ClientConfigHandler.debug.get()).booleanValue()) {
                    int offset = 0;
                    ResourceLocation icon = null;
                    for (Faction f : ReputationHandler.getEntityFactions(living)) {
                        if (ReputationHandler.isGoodReputation((Player)player, f)) {
                            icon = GOOD_REPUTATION;
                        } else if (ReputationHandler.isBadReputation((Player)player, f)) {
                            icon = BAD_REPUTATION;
                        }
                        double xTranslate = (double)(living.m_20205_() / 2.0f) - (double)(living.m_20205_() * 0.0125f) * 1.1 * (double)offset;
                        RenderEvents.render(e, living, (Player)player, new ResourceLocation("reputation", "textures/icons/faction_" + f.getID().m_135815_() + ".png"), xTranslate, 0.25, 0.22f);
                        if (icon != null) {
                            RenderEvents.render(e, living, (Player)player, icon, xTranslate, 0.28, 0.15f);
                        }
                        ++offset;
                    }
                }
                if ((chatIcon = ClientTrackers.getChatIcon(living)) != null) {
                    RenderEvents.render(e, living, (Player)player, chatIcon, 0.0, 1.0, 1.5f);
                }
            } else if (tickTimer < 20) {
                RenderEvents.render(e, living, (Player)player, FLEE, 0.0, 1.0, 1.5f);
            }
        }
    }

    private static void render(RenderNameplateEvent e, LivingEntity living, Player player, ResourceLocation icon, double xTranslate, double yTranslate, float scale) {
        float opacity = Mth.m_14036_((float)((64.0f - living.m_20270_((Entity)player)) / 64.0f), (float)0.0f, (float)1.0f);
        PoseStack poseStack = e.getPoseStack();
        EntityRenderer renderer = e.getEntityRenderer();
        poseStack.m_85836_();
        poseStack.m_85837_(xTranslate, (double)living.m_20206_() + yTranslate, 0.0);
        poseStack.m_85845_(renderer.f_114476_.m_114470_());
        poseStack.m_85841_(-0.025f * scale, -0.025f * scale, 0.025f * scale);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        poseStack.m_85836_();
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        Minecraft.m_91087_().m_91097_().m_118506_(icon).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)icon);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(matrix, -8.0f, 16.0f, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_85982_(matrix, 8.0f, 16.0f, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_85982_(matrix, 8.0f, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_85982_(matrix, -8.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        poseStack.m_85849_();
        RenderSystem.m_69461_();
        RenderSystem.m_69465_();
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void debugInfo(RenderGameOverlayEvent.Text e) {
        if (((Boolean)ClientConfigHandler.debug.get()).booleanValue() && Minecraft.m_91087_().f_91074_ != null) {
            for (Faction f : CLIENT_FACTIONS.values()) {
                e.getLeft().add("Reputation for the " + f.getID() + " faction: " + CLIENT_FACTIONS_REPUTATION.get(f));
            }
        }
    }
}

