/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.client;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import mods.thecomputerizer.reputation.common.ai.ChatTracker;
import mods.thecomputerizer.reputation.util.NetworkUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.mutable.MutableInt;

public class ClientTrackers {
    private static final HashMap<EntityType<?>, Data> CLIENT_ICON_DATA = new HashMap();

    @SubscribeEvent
    public static void tickTrackers(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            for (Data clientData : CLIENT_ICON_DATA.values()) {
                clientData.tick();
            }
        }
    }

    public static void onSync(FriendlyByteBuf buf) {
        CLIENT_ICON_DATA.clear();
        CLIENT_ICON_DATA.putAll(NetworkUtil.readGenericList(buf, Data::new).stream().filter(Data::isValid).collect(Collectors.toMap(Data::getType, data -> data)));
    }

    public static void setIcons(List<ChatTracker> trackers) {
        if (Objects.nonNull(Minecraft.m_91087_().f_91074_)) {
            for (ChatTracker tracker : trackers) {
                Entity entity = Minecraft.m_91087_().f_91074_.f_19853_.m_6815_(tracker.getEntityID());
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity;
                if (!CLIENT_ICON_DATA.containsKey(entity.m_6095_())) continue;
                CLIENT_ICON_DATA.get(entity.m_6095_()).set(living, tracker.getEvent());
            }
        }
    }

    public static boolean hasIcon(EntityType<?> type) {
        return CLIENT_ICON_DATA.containsKey(type) && CLIENT_ICON_DATA.get(type).isTicking();
    }

    public static ResourceLocation getChatIcon(LivingEntity entity) {
        return ClientTrackers.hasIcon(entity.m_6095_()) ? ClientTrackers.CLIENT_ICON_DATA.get((Object)entity.m_6095_()).currentIcons.get(entity) : null;
    }

    public static class Data {
        private final Random selector = new Random();
        private final EntityType<?> type;
        private final Map<String, List<ResourceLocation>> iconMap;
        private final long displayTimer;
        private final Map<LivingEntity, ResourceLocation> currentIcons;
        private final Map<LivingEntity, MutableInt> currentTimers;

        private Data(FriendlyByteBuf buf) {
            this.type = NetworkUtil.readEntityType(buf).orElse(null);
            this.iconMap = NetworkUtil.readGenericMap(buf, NetworkUtil::readString, buf1 -> NetworkUtil.readGenericList(buf1, FriendlyByteBuf::m_130281_));
            this.displayTimer = buf.readLong();
            this.currentIcons = new HashMap<LivingEntity, ResourceLocation>();
            this.currentTimers = new HashMap<LivingEntity, MutableInt>();
        }

        private void set(LivingEntity entity, String event) {
            if (Objects.nonNull(this.type) && this.iconMap.containsKey(event) && !this.iconMap.get(event).isEmpty() && this.displayTimer > 0L) {
                this.currentIcons.put(entity, this.iconMap.get(event).get(this.selector.nextInt(this.iconMap.get(event).size())));
                this.currentTimers.put(entity, new MutableInt((Number)this.displayTimer));
            }
        }

        private boolean isTicking() {
            return !this.currentIcons.isEmpty();
        }

        private void tick() {
            if (!this.currentTimers.isEmpty()) {
                for (MutableInt timer : this.currentTimers.values()) {
                    timer.decrement();
                }
                Iterator<Map.Entry<LivingEntity, MutableInt>> itr = this.currentTimers.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry<LivingEntity, MutableInt> entry = itr.next();
                    if (entry.getValue().getValue() > 0) continue;
                    this.currentIcons.remove(entry.getKey());
                    itr.remove();
                }
            }
        }

        public boolean isValid() {
            return Objects.nonNull(this.type);
        }

        public EntityType<?> getType() {
            return this.type;
        }
    }
}

