/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.api;

import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import mods.thecomputerizer.reputation.Reputation;
import mods.thecomputerizer.reputation.api.Faction;
import mods.thecomputerizer.reputation.api.capability.IReputation;
import mods.thecomputerizer.reputation.client.ClientHandler;
import mods.thecomputerizer.reputation.client.event.RenderEvents;
import mods.thecomputerizer.reputation.common.ai.ReputationStandings;
import mods.thecomputerizer.reputation.common.network.PacketHandler;
import mods.thecomputerizer.reputation.common.network.SetIconMessage;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;

public class ReputationHandler {
    public static Capability<IReputation> REPUTATION_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IReputation>(){});
    private static HashMap<ResourceLocation, Faction> FACTIONS = new HashMap();
    public static Random RANDOM = new Random();

    public static void registerFaction(Faction faction) {
        if (!faction.getID().toString().isEmpty() && !FACTIONS.containsKey(faction.getID())) {
            Reputation.logInfo("registered faction at location {}", faction.getID().toString());
            FACTIONS.put(faction.getID(), faction);
        }
    }

    public static Faction getFaction(ResourceLocation loc) {
        return ReputationHandler.getFactionMap().get(loc);
    }

    public static Map<ResourceLocation, Faction> getFactionMap() {
        return FACTIONS;
    }

    public static Collection<Faction> getEntityFactions(LivingEntity entity) {
        HashSet<Faction> factions = new HashSet<Faction>();
        for (Faction faction : ReputationHandler.getFactionMap().values()) {
            if (!faction.isMember(entity)) continue;
            factions.add(faction);
        }
        return factions;
    }

    public static Faction getFactionFromCurrency(Item currencyItem) {
        for (Faction faction : FACTIONS.values()) {
            if (faction.getCurrencyItem() != currencyItem) continue;
            return faction;
        }
        return null;
    }

    public static IReputation getCapability(Player player) {
        LazyOptional optional = player.getCapability(REPUTATION_CAPABILITY);
        return optional.isPresent() ? (optional.resolve().isPresent() ? (IReputation)optional.resolve().get() : null) : null;
    }

    public static int getReputation(Player player, Faction faction) {
        IReputation reputation = ReputationHandler.getCapability(player);
        return Objects.nonNull(reputation) ? reputation.getReputation(faction) : 0;
    }

    public static void changeReputation(Player player, Faction faction, int amount) {
        IReputation reputation;
        if (amount != 0 && player instanceof ServerPlayer && Objects.nonNull(reputation = ReputationHandler.getCapability(player))) {
            reputation.changeReputation(player, faction, amount);
            PacketHandler.sendTo(new SetIconMessage(amount > 0, faction.getID(), amount), (ServerPlayer)player);
        }
    }

    public static boolean isGoodReputation(Player player, Faction faction) {
        IReputation reputation = ReputationHandler.getCapability(player);
        if (Objects.isNull(reputation)) {
            return false;
        }
        return ReputationHandler.getReputation(player, faction) >= faction.getHigherRep();
    }

    public static boolean isBadReputation(Player player, Faction faction) {
        IReputation reputation = ReputationHandler.getCapability(player);
        if (Objects.isNull(reputation)) {
            return false;
        }
        return ReputationHandler.getReputation(player, faction) <= faction.getHigherRep();
    }

    public static void emptyMaps() {
        FACTIONS = new HashMap();
    }

    public static void readPacketData(HashMap<Faction, Integer> factions, JsonElement reputationStandingsData) {
        ClientHandler.standings = new ReputationStandings(reputationStandingsData);
        for (Faction faction : factions.keySet()) {
            RenderEvents.CLIENT_FACTIONS.put(faction.getID(), faction);
            RenderEvents.CLIENT_FACTIONS_REPUTATION.put(faction, factions.get(faction));
        }
    }
}

