/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.reputation.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mods.thecomputerizer.reputation.api.Faction;
import mods.thecomputerizer.reputation.api.ReputationHandler;
import mods.thecomputerizer.reputation.api.capability.IPlayerFaction;
import mods.thecomputerizer.reputation.common.capability.PlayerFactionProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PlayerFactionHandler {
    public static Map<Faction, PlayerFactionProvider> PLAYER_FACTIONS = new HashMap<Faction, PlayerFactionProvider>();

    public static IPlayerFaction getCapability(Faction faction) {
        LazyOptional optional = ServerLifecycleHooks.getCurrentServer().m_129783_().getCapability(PlayerFactionHandler.PLAYER_FACTIONS.get((Object)faction).PLAYER_FACTION);
        return optional.isPresent() ? (optional.resolve().isPresent() ? (IPlayerFaction)optional.resolve().get() : null) : null;
    }

    public static boolean isPlayerInFaction(Player player, Faction faction) {
        IPlayerFaction playerFaction = PlayerFactionHandler.getCapability(faction);
        if (Objects.isNull(playerFaction)) {
            return false;
        }
        return playerFaction.isPlayerAttached(player);
    }

    public static boolean addPlayerToFaction(Player player, Faction faction) {
        boolean pass = false;
        for (Faction other : ReputationHandler.getFactionMap().values()) {
            if (other == faction) {
                IPlayerFaction playerFaction = PlayerFactionHandler.getCapability(faction);
                if (!Objects.nonNull(playerFaction)) continue;
                pass = playerFaction.addPlayer(player);
                continue;
            }
            PlayerFactionHandler.removePlayerFromFaction(player, faction);
        }
        return pass;
    }

    public static boolean removePlayerFromFaction(Player player, Faction faction) {
        IPlayerFaction playerFaction = PlayerFactionHandler.getCapability(faction);
        if (Objects.nonNull(playerFaction)) {
            return playerFaction.removePlayer(player);
        }
        return false;
    }
}

