/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.structures;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import org.infernalstudios.infernalexp.world.gen.structures.StructureUtil;
import org.infernalstudios.infernalexp.world.gen.structures.config.SizeCheckingConfiguration;
import org.jetbrains.annotations.NotNull;

public class SizeCheckingNetherStructure
extends StructureFeature<SizeCheckingConfiguration> {
    public SizeCheckingNetherStructure() {
        super(SizeCheckingConfiguration.CODEC, SizeCheckingNetherStructure::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    @NotNull
    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.UNDERGROUND_DECORATION;
    }

    @NotNull
    private static Optional<PieceGenerator<SizeCheckingConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<SizeCheckingConfiguration> context) {
        Optional<Integer> yLevel = StructureUtil.getSuitableNetherYLevel(context, context.f_197355_().m_151394_(0));
        if (yLevel.isEmpty()) {
            return Optional.empty();
        }
        BlockPos pos = context.f_197355_().m_151394_(yLevel.get().intValue());
        int size = ((SizeCheckingConfiguration)context.f_197356_()).sizeToCheck();
        for (int x = pos.m_123341_() - size; x <= pos.m_123341_() + size; x += size) {
            for (int z = pos.m_123343_() - size; z <= pos.m_123343_() + size; z += size) {
                if (StructureUtil.checkLandAtHeight(context, pos, 5)) continue;
                return Optional.empty();
            }
        }
        return StructureUtil.addPieces(context, PoolElementStructurePiece::new, pos, false);
    }
}

