/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.init;

import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StoneButtonBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.infernalstudios.infernalexp.InfernalExpansion;
import org.infernalstudios.infernalexp.blocks.BasaltIronOreBlock;
import org.infernalstudios.infernalexp.blocks.BasalticMagmaBlock;
import org.infernalstudios.infernalexp.blocks.BuriedBoneBlock;
import org.infernalstudios.infernalexp.blocks.CrumblingBlackstoneBlock;
import org.infernalstudios.infernalexp.blocks.DullthornsBlock;
import org.infernalstudios.infernalexp.blocks.DullthornsBlockBlock;
import org.infernalstudios.infernalexp.blocks.FungusCapBlock;
import org.infernalstudios.infernalexp.blocks.GlowCampfireBlock;
import org.infernalstudios.infernalexp.blocks.GlowFireBlock;
import org.infernalstudios.infernalexp.blocks.GlowSandBlock;
import org.infernalstudios.infernalexp.blocks.GlowTorchBlock;
import org.infernalstudios.infernalexp.blocks.GlowWallTorchBlock;
import org.infernalstudios.infernalexp.blocks.GlowdustBlock;
import org.infernalstudios.infernalexp.blocks.LightUpPressurePlateBlock;
import org.infernalstudios.infernalexp.blocks.LuminousFungusBlock;
import org.infernalstudios.infernalexp.blocks.NetherCarpetBlock;
import org.infernalstudios.infernalexp.blocks.NetherrackPathBlock;
import org.infernalstudios.infernalexp.blocks.PlantedQuartzBlock;
import org.infernalstudios.infernalexp.blocks.ShroomlightFungusBlock;
import org.infernalstudios.infernalexp.blocks.SoulSoilPathBlock;
import org.infernalstudios.infernalexp.blocks.TrappedGlowSandBlock;
import org.infernalstudios.infernalexp.blocks.VerticalSlabBlock;
import org.infernalstudios.infernalexp.init.IEItems;
import org.infernalstudios.infernalexp.init.IESoundEvents;

public class IEBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"infernalexp");
    public static final RegistryObject<Block> DIMSTONE = IEBlocks.registerBlockWithDefaultItem("dimstone", () -> new Block(IEBlocks.getProperties(Material.f_76275_, 1.8f, 2.0f).m_60918_(IESoundEvents.DIMSTONE_TYPE).m_60999_().m_60953_(value -> 12)));
    public static final RegistryObject<Block> DULLSTONE = IEBlocks.registerBlockWithDefaultItem("dullstone", () -> new Block(IEBlocks.getProperties(Material.f_76275_, 1.5f, 6.0f).m_60918_(IESoundEvents.DULLSTONE_TYPE).m_60999_()));
    public static final RegistryObject<Block> SMOOTH_GLOWSTONE = IEBlocks.registerBlockWithDefaultItem("smooth_glowstone", () -> new Block(IEBlocks.getProperties(Material.f_76275_, 1.5f, 6.0f).m_60918_(SoundType.f_56744_).m_60999_().m_60953_(value -> 15)));
    public static final RegistryObject<Block> SMOOTH_DIMSTONE = IEBlocks.registerBlockWithDefaultItem("smooth_dimstone", () -> new Block(IEBlocks.getProperties((Block)DIMSTONE.get()).m_60913_(1.5f, 6.0f).m_60953_(value -> 12)));
    public static final RegistryObject<Block> SMOOTH_DULLSTONE = IEBlocks.registerBlockWithDefaultItem("smooth_dullstone", () -> new Block(IEBlocks.getProperties((Block)DULLSTONE.get()).m_60913_(1.5f, 6.0f)));
    public static final RegistryObject<Block> GLOWSTONE_BRICKS = IEBlocks.registerBlockWithDefaultItem("glowstone_bricks", () -> new Block(IEBlocks.getProperties((Block)SMOOTH_GLOWSTONE.get())));
    public static final RegistryObject<Block> DIMSTONE_BRICKS = IEBlocks.registerBlockWithDefaultItem("dimstone_bricks", () -> new Block(IEBlocks.getProperties((Block)SMOOTH_DIMSTONE.get())));
    public static final RegistryObject<Block> DULLSTONE_BRICKS = IEBlocks.registerBlockWithDefaultItem("dullstone_bricks", () -> new Block(IEBlocks.getProperties((Block)SMOOTH_DULLSTONE.get())));
    public static final RegistryObject<Block> CRACKED_GLOWSTONE_BRICKS = IEBlocks.registerBlockWithDefaultItem("cracked_glowstone_bricks", () -> new Block(IEBlocks.getProperties((Block)SMOOTH_GLOWSTONE.get())));
    public static final RegistryObject<Block> CRACKED_DIMSTONE_BRICKS = IEBlocks.registerBlockWithDefaultItem("cracked_dimstone_bricks", () -> new Block(IEBlocks.getProperties((Block)SMOOTH_DIMSTONE.get())));
    public static final RegistryObject<Block> CRACKED_DULLSTONE_BRICKS = IEBlocks.registerBlockWithDefaultItem("cracked_dullstone_bricks", () -> new Block(IEBlocks.getProperties((Block)SMOOTH_DULLSTONE.get())));
    public static final RegistryObject<Block> CHISELED_GLOWSTONE_BRICKS = IEBlocks.registerBlockWithDefaultItem("chiseled_glowstone_bricks", () -> new Block(IEBlocks.getProperties((Block)SMOOTH_GLOWSTONE.get())));
    public static final RegistryObject<Block> CHISELED_DIMSTONE_BRICKS = IEBlocks.registerBlockWithDefaultItem("chiseled_dimstone_bricks", () -> new Block(IEBlocks.getProperties((Block)SMOOTH_DIMSTONE.get())));
    public static final RegistryObject<Block> CHISELED_DULLSTONE_BRICKS = IEBlocks.registerBlockWithDefaultItem("chiseled_dullstone_bricks", () -> new Block(IEBlocks.getProperties((Block)SMOOTH_DULLSTONE.get())));
    public static final RegistryObject<Block> SMOOTH_GLOWSTONE_SLAB = IEBlocks.registerBlockWithDefaultItem("smooth_glowstone_slab", () -> new SlabBlock(IEBlocks.getProperties((Block)SMOOTH_GLOWSTONE.get())));
    public static final RegistryObject<Block> SMOOTH_GLOWSTONE_VERTICAL_SLAB = IEBlocks.registerBlockWithDefaultItemConditioned("smooth_glowstone_vertical_slab", () -> new VerticalSlabBlock(IEBlocks.getProperties((Block)SMOOTH_GLOWSTONE.get())), "quark");
    public static final RegistryObject<Block> SMOOTH_GLOWSTONE_STAIRS = IEBlocks.registerBlockWithDefaultItem("smooth_glowstone_stairs", () -> new StairBlock(() -> ((Block)SMOOTH_GLOWSTONE.get()).m_49966_(), IEBlocks.getProperties((Block)SMOOTH_GLOWSTONE.get())));
    public static final RegistryObject<Block> SMOOTH_GLOWSTONE_BUTTON = IEBlocks.registerBlockWithDefaultItem("smooth_glowstone_button", () -> new StoneButtonBlock(IEBlocks.getProperties(Material.f_76310_, 0.5f).m_60918_(SoundType.f_56744_).m_60953_(value -> 15).m_60910_()));
    public static final RegistryObject<Block> SMOOTH_GLOWSTONE_PRESSURE_PLATE = IEBlocks.registerBlockWithDefaultItem("smooth_glowstone_pressure_plate", () -> new LightUpPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, IEBlocks.getProperties((Block)SMOOTH_GLOWSTONE.get()).m_60953_(IEBlocks.getLightValueLit(15))));
    public static final RegistryObject<Block> SMOOTH_DIMSTONE_SLAB = IEBlocks.registerBlockWithDefaultItem("smooth_dimstone_slab", () -> new SlabBlock(IEBlocks.getProperties((Block)SMOOTH_DIMSTONE.get())));
    public static final RegistryObject<Block> SMOOTH_DIMSTONE_VERTICAL_SLAB = IEBlocks.registerBlockWithDefaultItemConditioned("smooth_dimstone_vertical_slab", () -> new VerticalSlabBlock(IEBlocks.getProperties((Block)SMOOTH_DIMSTONE.get())), "quark");
    public static final RegistryObject<Block> SMOOTH_DIMSTONE_STAIRS = IEBlocks.registerBlockWithDefaultItem("smooth_dimstone_stairs", () -> new StairBlock(() -> ((Block)SMOOTH_DIMSTONE.get()).m_49966_(), IEBlocks.getProperties((Block)SMOOTH_DIMSTONE.get())));
    public static final RegistryObject<Block> SMOOTH_DIMSTONE_BUTTON = IEBlocks.registerBlockWithDefaultItem("smooth_dimstone_button", () -> new StoneButtonBlock(IEBlocks.getProperties(Material.f_76310_, 0.5f).m_60918_(SoundType.f_56744_).m_60953_(value -> 12).m_60910_()));
    public static final RegistryObject<Block> SMOOTH_DULLSTONE_SLAB = IEBlocks.registerBlockWithDefaultItem("smooth_dullstone_slab", () -> new SlabBlock(IEBlocks.getProperties((Block)SMOOTH_DULLSTONE.get())));
    public static final RegistryObject<Block> SMOOTH_DULLSTONE_VERTICAL_SLAB = IEBlocks.registerBlockWithDefaultItemConditioned("smooth_dullstone_vertical_slab", () -> new VerticalSlabBlock(IEBlocks.getProperties((Block)SMOOTH_DULLSTONE.get())), "quark");
    public static final RegistryObject<Block> SMOOTH_DULLSTONE_STAIRS = IEBlocks.registerBlockWithDefaultItem("smooth_dullstone_stairs", () -> new StairBlock(() -> ((Block)SMOOTH_DULLSTONE.get()).m_49966_(), IEBlocks.getProperties((Block)SMOOTH_DULLSTONE.get())));
    public static final RegistryObject<Block> SMOOTH_DULLSTONE_BUTTON = IEBlocks.registerBlockWithDefaultItem("smooth_dullstone_button", () -> new StoneButtonBlock(IEBlocks.getProperties(Material.f_76310_, 0.5f).m_60918_(IESoundEvents.DULLSTONE_TYPE).m_60910_()));
    public static final RegistryObject<Block> GLOWSTONE_BRICK_SLAB = IEBlocks.registerBlockWithDefaultItem("glowstone_brick_slab", () -> new SlabBlock(IEBlocks.getProperties((Block)GLOWSTONE_BRICKS.get())));
    public static final RegistryObject<Block> GLOWSTONE_BRICK_VERTICAL_SLAB = IEBlocks.registerBlockWithDefaultItemConditioned("glowstone_brick_vertical_slab", () -> new VerticalSlabBlock(IEBlocks.getProperties((Block)GLOWSTONE_BRICKS.get())), "quark");
    public static final RegistryObject<Block> GLOWSTONE_BRICK_STAIRS = IEBlocks.registerBlockWithDefaultItem("glowstone_brick_stairs", () -> new StairBlock(() -> ((Block)GLOWSTONE_BRICKS.get()).m_49966_(), IEBlocks.getProperties((Block)GLOWSTONE_BRICKS.get())));
    public static final RegistryObject<Block> GLOWSTONE_BRICK_WALL = IEBlocks.registerBlockWithDefaultItem("glowstone_brick_wall", () -> new WallBlock(IEBlocks.getProperties((Block)GLOWSTONE_BRICKS.get())));
    public static final RegistryObject<Block> DIMSTONE_BRICK_SLAB = IEBlocks.registerBlockWithDefaultItem("dimstone_brick_slab", () -> new SlabBlock(IEBlocks.getProperties((Block)DIMSTONE_BRICKS.get())));
    public static final RegistryObject<Block> DIMSTONE_BRICK_VERTICAL_SLAB = IEBlocks.registerBlockWithDefaultItemConditioned("dimstone_brick_vertical_slab", () -> new VerticalSlabBlock(IEBlocks.getProperties((Block)DIMSTONE_BRICKS.get())), "quark");
    public static final RegistryObject<Block> DIMSTONE_BRICK_STAIRS = IEBlocks.registerBlockWithDefaultItem("dimstone_brick_stairs", () -> new StairBlock(() -> ((Block)DIMSTONE_BRICKS.get()).m_49966_(), IEBlocks.getProperties((Block)DIMSTONE_BRICKS.get())));
    public static final RegistryObject<Block> DIMSTONE_BRICK_WALL = IEBlocks.registerBlockWithDefaultItem("dimstone_brick_wall", () -> new WallBlock(IEBlocks.getProperties((Block)DIMSTONE_BRICKS.get())));
    public static final RegistryObject<Block> DULLSTONE_BRICK_SLAB = IEBlocks.registerBlockWithDefaultItem("dullstone_brick_slab", () -> new SlabBlock(IEBlocks.getProperties((Block)DULLSTONE_BRICKS.get())));
    public static final RegistryObject<Block> DULLSTONE_BRICK_VERTICAL_SLAB = IEBlocks.registerBlockWithDefaultItemConditioned("dullstone_brick_vertical_slab", () -> new VerticalSlabBlock(IEBlocks.getProperties((Block)DULLSTONE_BRICKS.get())), "quark");
    public static final RegistryObject<Block> DULLSTONE_BRICK_STAIRS = IEBlocks.registerBlockWithDefaultItem("dullstone_brick_stairs", () -> new StairBlock(() -> ((Block)DULLSTONE_BRICKS.get()).m_49966_(), IEBlocks.getProperties((Block)DULLSTONE_BRICKS.get())));
    public static final RegistryObject<Block> DULLSTONE_BRICK_WALL = IEBlocks.registerBlockWithDefaultItem("dullstone_brick_wall", () -> new WallBlock(IEBlocks.getProperties((Block)DULLSTONE_BRICKS.get())));
    public static final RegistryObject<Block> LUMINOUS_WART_BLOCK = IEBlocks.registerBlockWithDefaultItem("luminous_wart_block", () -> new Block(IEBlocks.getProperties(Blocks.f_50451_).m_60953_(value -> 8)));
    public static final RegistryObject<RotatedPillarBlock> LUMINOUS_STEM = IEBlocks.registerBlockWithDefaultItem("luminous_stem", () -> new RotatedPillarBlock(IEBlocks.getProperties(Blocks.f_50695_)));
    public static final RegistryObject<RotatedPillarBlock> LUMINOUS_HYPHAE = IEBlocks.registerBlockWithDefaultItem("luminous_hyphae", () -> new RotatedPillarBlock(IEBlocks.getProperties(Blocks.f_50697_)));
    public static final RegistryObject<RotatedPillarBlock> STRIPPED_LUMINOUS_STEM = IEBlocks.registerBlockWithDefaultItem("stripped_luminous_stem", () -> new RotatedPillarBlock(IEBlocks.getProperties(Blocks.f_50696_)));
    public static final RegistryObject<RotatedPillarBlock> STRIPPED_LUMINOUS_HYPHAE = IEBlocks.registerBlockWithDefaultItem("stripped_luminous_hyphae", () -> new RotatedPillarBlock(IEBlocks.getProperties(Blocks.f_50698_)));
    public static final RegistryObject<Block> GLOWDUST_SAND = IEBlocks.registerBlockWithDefaultItem("glowdust_sand", () -> new GlowSandBlock(16761447, BlockBehaviour.Properties.m_60944_((Material)Material.f_76280_, (MaterialColor)MaterialColor.f_76400_).m_60999_().m_60978_(0.5f).m_60918_(SoundType.f_56746_)));
    public static final RegistryObject<Block> GLOWDUST = IEBlocks.registerBlockWithDefaultItem("glowdust", () -> new GlowdustBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76308_, (MaterialColor)MaterialColor.f_76400_).m_60999_().m_60978_(0.2f).m_60918_(SoundType.f_56746_)));
    public static final RegistryObject<Block> TRAPPED_GLOWDUST_SAND = IEBlocks.registerBlockWithDefaultItem("trapped_glowdust_sand", () -> new TrappedGlowSandBlock(16761447, IEBlocks.getProperties((Block)GLOWDUST_SAND.get()).m_60978_(0.2f)));
    public static final RegistryObject<Block> GLOWDUST_STONE = IEBlocks.registerBlockWithDefaultItem("glowdust_stone", () -> new Block(IEBlocks.getProperties(Blocks.f_50062_)));
    public static final RegistryObject<Block> GLOWDUST_STONE_SLAB = IEBlocks.registerBlockWithDefaultItem("glowdust_stone_slab", () -> new SlabBlock(IEBlocks.getProperties((Block)GLOWDUST_STONE.get())));
    public static final RegistryObject<Block> GLOWDUST_STONE_VERTICAL_SLAB = IEBlocks.registerBlockWithDefaultItemConditioned("glowdust_stone_vertical_slab", () -> new VerticalSlabBlock(IEBlocks.getProperties((Block)GLOWDUST_STONE.get())), "quark");
    public static final RegistryObject<Block> GLOWDUST_STONE_STAIRS = IEBlocks.registerBlockWithDefaultItem("glowdust_stone_stairs", () -> new StairBlock(() -> ((Block)GLOWDUST_STONE.get()).m_49966_(), IEBlocks.getProperties((Block)GLOWDUST_STONE.get())));
    public static final RegistryObject<Block> GLOWDUST_STONE_WALL = IEBlocks.registerBlockWithDefaultItem("glowdust_stone_wall", () -> new WallBlock(IEBlocks.getProperties((Block)GLOWDUST_STONE.get())));
    public static final RegistryObject<Block> GLOWDUST_STONE_BRICKS = IEBlocks.registerBlockWithDefaultItem("glowdust_stone_bricks", () -> new Block(IEBlocks.getProperties(Blocks.f_50062_)));
    public static final RegistryObject<Block> GLOWDUST_STONE_BRICK_SLAB = IEBlocks.registerBlockWithDefaultItem("glowdust_stone_brick_slab", () -> new SlabBlock(IEBlocks.getProperties((Block)GLOWDUST_STONE_BRICKS.get())));
    public static final RegistryObject<Block> GLOWDUST_STONE_BRICK_VERTICAL_SLAB = IEBlocks.registerBlockWithDefaultItemConditioned("glowdust_stone_brick_vertical_slab", () -> new VerticalSlabBlock(IEBlocks.getProperties((Block)GLOWDUST_STONE_BRICKS.get())), "quark");
    public static final RegistryObject<Block> GLOWDUST_STONE_BRICK_STAIRS = IEBlocks.registerBlockWithDefaultItem("glowdust_stone_brick_stairs", () -> new StairBlock(() -> ((Block)GLOWDUST_STONE_BRICKS.get()).m_49966_(), IEBlocks.getProperties((Block)GLOWDUST_STONE_BRICKS.get())));
    public static final RegistryObject<Block> GLOWDUST_STONE_BRICK_WALL = IEBlocks.registerBlockWithDefaultItem("glowdust_stone_brick_wall", () -> new WallBlock(IEBlocks.getProperties((Block)GLOWDUST_STONE_BRICKS.get())));
    public static final RegistryObject<Block> CRACKED_GLOWDUST_STONE_BRICKS = IEBlocks.registerBlockWithDefaultItem("cracked_glowdust_stone_bricks", () -> new Block(IEBlocks.getProperties((Block)GLOWDUST_STONE_BRICKS.get())));
    public static final RegistryObject<Block> CHISELED_GLOWDUST_STONE_BRICKS = IEBlocks.registerBlockWithDefaultItem("chiseled_glowdust_stone_bricks", () -> new Block(IEBlocks.getProperties((Block)GLOWDUST_STONE_BRICKS.get())));
    public static final RegistryObject<Block> CRUMBLING_BLACKSTONE = IEBlocks.registerBlockWithDefaultItem("crumbling_blackstone", () -> new CrumblingBlackstoneBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50134_)));
    public static final RegistryObject<Block> RUBBLE = IEBlocks.registerBlockWithDefaultItem("rubble", () -> new Block(IEBlocks.getProperties(Blocks.f_49994_)));
    public static final RegistryObject<Block> SILT = IEBlocks.registerBlockWithDefaultItem("silt", () -> new Block(IEBlocks.getProperties(Blocks.f_49992_)));
    public static final RegistryObject<Block> BASALT_COBBLED = IEBlocks.registerBlockWithDefaultItem("basalt_cobbled", () -> new RotatedPillarBlock(IEBlocks.getProperties(Blocks.f_49994_).m_60918_(SoundType.f_56718_)));
    public static final RegistryObject<Block> BASALT_COBBLED_SLAB = IEBlocks.registerBlockWithDefaultItem("basalt_cobbled_slab", () -> new SlabBlock(IEBlocks.getProperties(Blocks.f_49994_).m_60918_(SoundType.f_56718_)));
    public static final RegistryObject<Block> BASALT_COBBLED_VERTICAL_SLAB = IEBlocks.registerBlockWithDefaultItemConditioned("basalt_cobbled_vertical_slab", () -> new VerticalSlabBlock(IEBlocks.getProperties(Blocks.f_49994_).m_60918_(SoundType.f_56718_)), "quark");
    public static final RegistryObject<Block> BASALT_SLAB = IEBlocks.registerBlockWithDefaultItem("basalt_slab", () -> new SlabBlock(IEBlocks.getProperties(Blocks.f_50137_)));
    public static final RegistryObject<Block> BASALT_VERTICAL_SLAB = IEBlocks.registerBlockWithDefaultItemConditioned("basalt_vertical_slab", () -> new VerticalSlabBlock(IEBlocks.getProperties(Blocks.f_50137_)), "quark");
    public static final RegistryObject<Block> BASALT_STAIRS = IEBlocks.registerBlockWithDefaultItem("basalt_stairs", () -> new StairBlock(() -> ((Block)Blocks.f_50137_).m_49966_(), IEBlocks.getProperties(Blocks.f_50137_)));
    public static final RegistryObject<Block> BASALT_WALL = IEBlocks.registerBlockWithDefaultItem("basalt_wall", () -> new WallBlock(IEBlocks.getProperties(Blocks.f_50137_)));
    public static final RegistryObject<Block> BASALT_BUTTON = IEBlocks.registerBlockWithDefaultItem("basalt_button", () -> new StoneButtonBlock(IEBlocks.getProperties(Blocks.f_50137_)));
    public static final RegistryObject<Block> POLISHED_BASALT_PRESSURE_PLATE = IEBlocks.registerBlockWithDefaultItem("polished_basalt_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, IEBlocks.getProperties(Blocks.f_50138_)));
    public static final RegistryObject<Block> POLISHED_BASALT_SLAB = IEBlocks.registerBlockWithDefaultItem("polished_basalt_slab", () -> new SlabBlock(IEBlocks.getProperties(Blocks.f_50138_)));
    public static final RegistryObject<Block> POLISHED_BASALT_VERTICAL_SLAB = IEBlocks.registerBlockWithDefaultItemConditioned("polished_basalt_vertical_slab", () -> new VerticalSlabBlock(IEBlocks.getProperties(Blocks.f_50138_)), "quark");
    public static final RegistryObject<Block> POLISHED_BASALT_TILES = IEBlocks.registerBlockWithDefaultItem("polished_basalt_tiles", () -> new RotatedPillarBlock(IEBlocks.getProperties(Blocks.f_50138_)));
    public static final RegistryObject<Block> POLISHED_BASALT_TILES_SLAB = IEBlocks.registerBlockWithDefaultItem("polished_basalt_tiles_slab", () -> new SlabBlock(IEBlocks.getProperties(Blocks.f_50138_)));
    public static final RegistryObject<Block> POLISHED_BASALT_TILES_VERTICAL_SLAB = IEBlocks.registerBlockWithDefaultItemConditioned("polished_basalt_tiles_vertical_slab", () -> new VerticalSlabBlock(IEBlocks.getProperties(Blocks.f_50138_)), "quark");
    public static final RegistryObject<Block> BASALT_BRICKS = IEBlocks.registerBlockWithDefaultItem("basalt_bricks", () -> new RotatedPillarBlock(IEBlocks.getProperties(Blocks.f_50137_)));
    public static final RegistryObject<Block> BASALT_BRICK_SLAB = IEBlocks.registerBlockWithDefaultItem("basalt_brick_slab", () -> new SlabBlock(IEBlocks.getProperties((Block)BASALT_BRICKS.get())));
    public static final RegistryObject<Block> BASALT_BRICK_VERTICAL_SLAB = IEBlocks.registerBlockWithDefaultItemConditioned("basalt_brick_vertical_slab", () -> new VerticalSlabBlock(IEBlocks.getProperties((Block)BASALT_BRICKS.get())), "quark");
    public static final RegistryObject<Block> BASALT_BRICK_STAIRS = IEBlocks.registerBlockWithDefaultItem("basalt_brick_stairs", () -> new StairBlock(() -> ((Block)BASALT_BRICKS.get()).m_49966_(), IEBlocks.getProperties((Block)BASALT_BRICKS.get())));
    public static final RegistryObject<Block> BASALT_BRICK_WALL = IEBlocks.registerBlockWithDefaultItem("basalt_brick_wall", () -> new WallBlock(IEBlocks.getProperties((Block)BASALT_BRICKS.get())));
    public static final RegistryObject<Block> CRACKED_BASALT_BRICKS = IEBlocks.registerBlockWithDefaultItem("cracked_basalt_bricks", () -> new RotatedPillarBlock(IEBlocks.getProperties(Blocks.f_50137_)));
    public static final RegistryObject<Block> CHISELED_BASALT_BRICKS = IEBlocks.registerBlockWithDefaultItem("chiseled_basalt_bricks", () -> new RotatedPillarBlock(IEBlocks.getProperties(Blocks.f_50137_)));
    public static final RegistryObject<Block> MAGMATIC_CHISELED_BASALT_BRICKS = IEBlocks.registerBlockWithDefaultItem("magmatic_chiseled_basalt_bricks", () -> new RotatedPillarBlock(IEBlocks.getProperties(Blocks.f_50137_)));
    public static final RegistryObject<Block> BASALT_IRON_ORE = IEBlocks.registerBlockWithDefaultItem("basalt_iron_ore", () -> new BasaltIronOreBlock(IEBlocks.getProperties(Blocks.f_49998_)));
    public static final RegistryObject<Block> BASALTIC_MAGMA = IEBlocks.registerBlockWithDefaultItem("basaltic_magma", () -> new BasalticMagmaBlock(IEBlocks.getProperties(Blocks.f_50450_).m_60953_(value -> 2)));
    public static final RegistryObject<Block> SOUL_SAND_SLAB = IEBlocks.registerBlockWithDefaultItem("soul_sand_slab", () -> new SlabBlock(IEBlocks.getProperties(Blocks.f_50135_)));
    public static final RegistryObject<Block> SOUL_SAND_VERTICAL_SLAB = IEBlocks.registerBlockWithDefaultItemConditioned("soul_sand_vertical_slab", () -> new VerticalSlabBlock(IEBlocks.getProperties(Blocks.f_50135_)), "quark");
    public static final RegistryObject<Block> SOUL_SAND_STAIRS = IEBlocks.registerBlockWithDefaultItem("soul_sand_stairs", () -> new StairBlock(() -> ((Block)Blocks.f_50135_).m_49966_(), IEBlocks.getProperties(Blocks.f_50135_)));
    public static final RegistryObject<Block> SOUL_SOIL_SLAB = IEBlocks.registerBlockWithDefaultItem("soul_soil_slab", () -> new SlabBlock(IEBlocks.getProperties(Blocks.f_50136_)));
    public static final RegistryObject<Block> SOUL_SOIL_VERTICAL_SLAB = IEBlocks.registerBlockWithDefaultItemConditioned("soul_soil_vertical_slab", () -> new VerticalSlabBlock(IEBlocks.getProperties(Blocks.f_50136_)), "quark");
    public static final RegistryObject<Block> SOUL_SOIL_STAIRS = IEBlocks.registerBlockWithDefaultItem("soul_soil_stairs", () -> new StairBlock(() -> ((Block)Blocks.f_50136_).m_49966_(), IEBlocks.getProperties(Blocks.f_50136_)));
    public static final RegistryObject<Block> SOUL_STONE = IEBlocks.registerBlockWithDefaultItem("soul_stone", () -> new Block(IEBlocks.getProperties(Blocks.f_50652_).m_60918_(IESoundEvents.SOUL_STONE_TYPE)));
    public static final RegistryObject<Block> SOUL_STONE_SLAB = IEBlocks.registerBlockWithDefaultItem("soul_stone_slab", () -> new SlabBlock(IEBlocks.getProperties(Blocks.f_50652_).m_60918_(SoundType.f_56717_)));
    public static final RegistryObject<Block> SOUL_STONE_VERTICAL_SLAB = IEBlocks.registerBlockWithDefaultItemConditioned("soul_stone_vertical_slab", () -> new VerticalSlabBlock(IEBlocks.getProperties(Blocks.f_50652_).m_60918_(SoundType.f_56717_)), "quark");
    public static final RegistryObject<Block> SOUL_STONE_STAIRS = IEBlocks.registerBlockWithDefaultItem("soul_stone_stairs", () -> new StairBlock(() -> ((Block)Blocks.f_50652_).m_49966_(), IEBlocks.getProperties(Blocks.f_50136_)));
    public static final RegistryObject<Block> SOUL_STONE_WALL = IEBlocks.registerBlockWithDefaultItem("soul_stone_wall", () -> new WallBlock(IEBlocks.getProperties(Blocks.f_50274_)));
    public static final RegistryObject<Block> SOUL_SLATE = IEBlocks.registerBlockWithDefaultItem("soul_slate", () -> new Block(IEBlocks.getProperties(Blocks.f_50222_).m_60918_(IESoundEvents.SOUL_STONE_TYPE)));
    public static final RegistryObject<Block> SOUL_SLATE_SLAB = IEBlocks.registerBlockWithDefaultItem("soul_slate_slab", () -> new SlabBlock(IEBlocks.getProperties((Block)SOUL_SLATE.get())));
    public static final RegistryObject<Block> SOUL_SLATE_VERTICAL_SLAB = IEBlocks.registerBlockWithDefaultItemConditioned("soul_slate_vertical_slab", () -> new VerticalSlabBlock(IEBlocks.getProperties((Block)SOUL_SLATE.get())), "quark");
    public static final RegistryObject<Block> SOUL_SLATE_STAIRS = IEBlocks.registerBlockWithDefaultItem("soul_slate_stairs", () -> new StairBlock(() -> ((Block)SOUL_SLATE.get()).m_49966_(), IEBlocks.getProperties((Block)SOUL_SLATE.get())));
    public static final RegistryObject<Block> SOUL_SLATE_BUTTON = IEBlocks.registerBlockWithDefaultItem("soul_slate_button", () -> new StoneButtonBlock(IEBlocks.getProperties((Block)SOUL_SLATE.get())));
    public static final RegistryObject<Block> SOUL_SLATE_PRESSURE_PLATE = IEBlocks.registerBlockWithDefaultItem("soul_slate_pressure_plate", () -> new LightUpPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, IEBlocks.getProperties((Block)SOUL_SLATE.get()).m_60953_(IEBlocks.getLightValueLit(15))));
    public static final RegistryObject<Block> SOUL_STONE_BRICKS = IEBlocks.registerBlockWithDefaultItem("soul_stone_bricks", () -> new Block(IEBlocks.getProperties((Block)SOUL_STONE.get())));
    public static final RegistryObject<Block> SOUL_STONE_BRICK_SLAB = IEBlocks.registerBlockWithDefaultItem("soul_stone_brick_slab", () -> new SlabBlock(IEBlocks.getProperties((Block)SOUL_STONE_BRICKS.get())));
    public static final RegistryObject<Block> SOUL_STONE_BRICK_VERTICAL_SLAB = IEBlocks.registerBlockWithDefaultItemConditioned("soul_stone_brick_vertical_slab", () -> new VerticalSlabBlock(IEBlocks.getProperties((Block)SOUL_STONE_BRICKS.get())), "quark");
    public static final RegistryObject<Block> SOUL_STONE_BRICK_STAIRS = IEBlocks.registerBlockWithDefaultItem("soul_stone_brick_stairs", () -> new StairBlock(() -> ((Block)SOUL_STONE_BRICKS.get()).m_49966_(), IEBlocks.getProperties((Block)SOUL_STONE_BRICKS.get())));
    public static final RegistryObject<Block> SOUL_STONE_BRICK_WALL = IEBlocks.registerBlockWithDefaultItem("soul_stone_brick_wall", () -> new WallBlock(IEBlocks.getProperties((Block)SOUL_STONE_BRICKS.get())));
    public static final RegistryObject<Block> CRACKED_SOUL_STONE_BRICKS = IEBlocks.registerBlockWithDefaultItem("cracked_soul_stone_bricks", () -> new Block(IEBlocks.getProperties((Block)SOUL_STONE.get())));
    public static final RegistryObject<Block> CHISELED_SOUL_STONE_BRICKS = IEBlocks.registerBlockWithDefaultItem("chiseled_soul_stone_bricks", () -> new RotatedPillarBlock(IEBlocks.getProperties((Block)SOUL_STONE.get())));
    public static final RegistryObject<Block> CHARGED_CHISELED_SOUL_STONE_BRICKS = IEBlocks.registerBlockWithDefaultItem("charged_chiseled_soul_stone_bricks", () -> new RotatedPillarBlock(IEBlocks.getProperties((Block)SOUL_SLATE.get())));
    public static final RegistryObject<Block> SOUL_SLATE_BRICKS = IEBlocks.registerBlockWithDefaultItem("soul_slate_bricks", () -> new Block(IEBlocks.getProperties((Block)SOUL_SLATE.get())));
    public static final RegistryObject<Block> SOUL_SLATE_BRICK_SLAB = IEBlocks.registerBlockWithDefaultItem("soul_slate_brick_slab", () -> new SlabBlock(IEBlocks.getProperties((Block)SOUL_SLATE_BRICKS.get())));
    public static final RegistryObject<Block> SOUL_SLATE_BRICK_VERTICAL_SLAB = IEBlocks.registerBlockWithDefaultItemConditioned("soul_slate_brick_vertical_slab", () -> new VerticalSlabBlock(IEBlocks.getProperties((Block)SOUL_SLATE_BRICKS.get())), "quark");
    public static final RegistryObject<Block> SOUL_SLATE_BRICK_STAIRS = IEBlocks.registerBlockWithDefaultItem("soul_slate_brick_stairs", () -> new StairBlock(() -> ((Block)SOUL_SLATE_BRICKS.get()).m_49966_(), IEBlocks.getProperties((Block)SOUL_SLATE_BRICKS.get())));
    public static final RegistryObject<Block> SOUL_SLATE_BRICK_WALL = IEBlocks.registerBlockWithDefaultItem("soul_slate_brick_wall", () -> new WallBlock(IEBlocks.getProperties((Block)SOUL_SLATE_BRICKS.get())));
    public static final RegistryObject<Block> CRACKED_SOUL_SLATE_BRICKS = IEBlocks.registerBlockWithDefaultItem("cracked_soul_slate_bricks", () -> new Block(IEBlocks.getProperties((Block)SOUL_SLATE.get())));
    public static final RegistryObject<Block> CHISELED_SOUL_SLATE_BRICKS = IEBlocks.registerBlockWithDefaultItem("chiseled_soul_slate_bricks", () -> new RotatedPillarBlock(IEBlocks.getProperties((Block)SOUL_SLATE.get())));
    public static final RegistryObject<Block> CHARGED_CHISELED_SOUL_SLATE_BRICKS = IEBlocks.registerBlockWithDefaultItem("charged_chiseled_soul_slate_bricks", () -> new RotatedPillarBlock(IEBlocks.getProperties((Block)SOUL_SLATE.get())));
    public static final RegistryObject<Block> CRIMSON_FUNGUS_CAP = IEBlocks.registerBlockWithDefaultItem("crimson_fungus_cap", () -> new FungusCapBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50451_)));
    public static final RegistryObject<Block> WARPED_FUNGUS_CAP = IEBlocks.registerBlockWithDefaultItem("warped_fungus_cap", () -> new FungusCapBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50692_)));
    public static final RegistryObject<Block> LUMINOUS_FUNGUS_CAP = IEBlocks.registerBlockWithDefaultItem("luminous_fungus_cap", () -> new FungusCapBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50451_).m_60953_(value -> 14)));
    public static final RegistryObject<Block> GLOW_LANTERN = IEBlocks.registerBlockWithDefaultItem("glow_lantern", () -> new LanternBlock(IEBlocks.getProperties(Blocks.f_50681_)));
    public static final RegistryObject<Block> GLOW_TORCH = IEBlocks.registerBlock("glow_torch", () -> new GlowTorchBlock(IEBlocks.getProperties(Blocks.f_50081_)));
    public static final RegistryObject<Block> GLOW_TORCH_WALL = IEBlocks.registerBlock("glow_torch_wall", () -> new GlowWallTorchBlock(IEBlocks.getProperties((Block)GLOW_TORCH.get()).m_60916_((Block)GLOW_TORCH.get())));
    public static final RegistryObject<Block> GLOW_CAMPFIRE = IEBlocks.registerBlockWithDefaultItem("glow_campfire", () -> new GlowCampfireBlock(true, 2, IEBlocks.getProperties(Blocks.f_50683_)));
    public static final RegistryObject<Block> GLOW_FIRE = IEBlocks.registerBlock("glow_fire", () -> new GlowFireBlock(IEBlocks.getProperties(Blocks.f_50083_)));
    public static final RegistryObject<Block> GLOWSILK_COCOON = IEBlocks.registerBlockWithDefaultItem("glowsilk_cocoon", () -> new RotatedPillarBlock(IEBlocks.getProperties(Material.f_76315_).m_60918_(SoundType.f_56745_).m_60999_().m_60913_(5.0f, 1200.0f).m_60953_(value -> 5)));
    public static final RegistryObject<Block> LUMINOUS_FUNGUS = IEBlocks.registerBlockWithDefaultItem("luminous_fungus", () -> new LuminousFungusBlock(IEBlocks.getProperties(Material.f_76300_).m_60953_(IEBlocks.getLightValueLit(15)).m_60910_().m_60918_(SoundType.f_56740_)));
    public static final RegistryObject<Block> DULLTHORNS = IEBlocks.registerBlock("dullthorns", () -> new DullthornsBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60953_(value -> 3).m_60910_().m_60977_().m_60978_(0.1f).m_60918_(SoundType.f_56740_)));
    public static final RegistryObject<Block> DULLTHORNS_BLOCK = IEBlocks.registerBlockWithDefaultItem("dullthorns_block", () -> new DullthornsBlockBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76277_).m_60978_(1.0f).m_60918_(SoundType.f_56719_)));
    public static final RegistryObject<FlowerPotBlock> POTTED_LUMINOUS_FUNGUS = IEBlocks.registerBlock("potted_luminous_fungus", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, LUMINOUS_FUNGUS, IEBlocks.getProperties(Blocks.f_50276_)));
    public static final RegistryObject<FlowerPotBlock> POTTED_DULLTHORNS = IEBlocks.registerBlock("potted_dullthorns", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, DULLTHORNS, IEBlocks.getProperties(Blocks.f_50276_)));
    public static final RegistryObject<Block> SHROOMLIGHT_FUNGUS = IEBlocks.registerBlockWithDefaultItem("shroomlight_fungus", () -> new ShroomlightFungusBlock(IEBlocks.getProperties(Material.f_76300_).m_60953_(value -> 13).m_60910_().m_60918_(SoundType.f_56740_)));
    public static final RegistryObject<FlowerPotBlock> POTTED_SHROOMLIGHT_FUNGUS = IEBlocks.registerBlock("potted_shroomlight_fungus", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, SHROOMLIGHT_FUNGUS, IEBlocks.getProperties(Blocks.f_50276_)));
    public static final RegistryObject<BuriedBoneBlock> BURIED_BONE = IEBlocks.registerBlock("buried_bone", () -> new BuriedBoneBlock(IEBlocks.getProperties(Material.f_76300_).m_60910_().m_60918_(SoundType.f_56724_)));
    public static final RegistryObject<FlowerPotBlock> POTTED_BURIED_BONE = IEBlocks.registerBlock("potted_buried_bone", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, BURIED_BONE, IEBlocks.getProperties(Blocks.f_50276_)));
    public static final RegistryObject<PlantedQuartzBlock> PLANTED_QUARTZ = IEBlocks.registerBlock("planted_quartz", () -> new PlantedQuartzBlock(IEBlocks.getProperties(Material.f_76278_).m_60978_(1.5f).m_60999_().m_60910_().m_60918_(SoundType.f_56723_)));
    public static final RegistryObject<Block> CRIMSON_NYLIUM_PATH = IEBlocks.registerBlockWithDefaultItem("crimson_nylium_path", () -> new NetherrackPathBlock(IEBlocks.getProperties(Blocks.f_50134_)));
    public static final RegistryObject<Block> WARPED_NYLIUM_PATH = IEBlocks.registerBlockWithDefaultItem("warped_nylium_path", () -> new NetherrackPathBlock(IEBlocks.getProperties(Blocks.f_50134_)));
    public static final RegistryObject<Block> CRIMSON_NYLIUM_CARPET = IEBlocks.registerBlockWithDefaultItem("crimson_nylium_carpet", () -> new NetherCarpetBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76299_, (MaterialColor)MaterialColor.f_76389_).m_60978_(0.1f).m_60918_(SoundType.f_56710_)));
    public static final RegistryObject<Block> WARPED_NYLIUM_CARPET = IEBlocks.registerBlockWithDefaultItem("warped_nylium_carpet", () -> new NetherCarpetBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76299_, (MaterialColor)MaterialColor.f_76392_).m_60978_(0.1f).m_60918_(SoundType.f_56710_)));
    public static final RegistryObject<Block> SOUL_SOIL_PATH = IEBlocks.registerBlockWithDefaultItem("soul_soil_path", () -> new SoulSoilPathBlock(IEBlocks.getProperties(Blocks.f_50136_)));
    public static final RegistryObject<Block> QUARTZ_GLASS = IEBlocks.registerBlockWithDefaultItem("quartz_glass", () -> new GlassBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56744_).m_60955_().m_60922_(IEBlocks::neverAllowSpawn).m_60924_(IEBlocks::isntSolid).m_60960_(IEBlocks::isntSolid).m_60971_(IEBlocks::isntSolid)));
    public static final RegistryObject<Block> QUARTZ_GLASS_PANE = IEBlocks.registerBlockWithDefaultItem("quartz_glass_pane", () -> new IronBarsBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56744_).m_60955_()));
    public static final RegistryObject<Block> GLOW_GLASS = IEBlocks.registerBlockWithDefaultItem("glow_glass", () -> new GlassBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60978_(0.3f).m_60918_(SoundType.f_56744_).m_60955_().m_60922_(IEBlocks::neverAllowSpawn).m_60924_(IEBlocks::isntSolid).m_60960_(IEBlocks::isntSolid).m_60971_(IEBlocks::isntSolid).m_60953_(value -> 10)));
    public static final RegistryObject<Block> GLOW_GLASS_PANE = IEBlocks.registerBlockWithDefaultItem("glow_glass_pane", () -> new IronBarsBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60978_(0.3f).m_60918_(SoundType.f_56744_).m_60955_().m_60953_(value -> 10)));

    private static boolean isntSolid(BlockState state, BlockGetter reader, BlockPos pos) {
        return false;
    }

    private static Boolean neverAllowSpawn(BlockState state, BlockGetter reader, BlockPos pos, EntityType<?> entity) {
        return false;
    }

    public static BlockBehaviour.Properties getProperties(Material materialIn, float hardnessAndResistanceIn) {
        return IEBlocks.getProperties(materialIn, hardnessAndResistanceIn, hardnessAndResistanceIn);
    }

    public static BlockBehaviour.Properties getProperties(Material materialIn, float hardnessIn, float resistanceIn) {
        return BlockBehaviour.Properties.m_60939_((Material)materialIn).m_60913_(hardnessIn, resistanceIn);
    }

    public static BlockBehaviour.Properties getProperties(Material materialIn) {
        return BlockBehaviour.Properties.m_60939_((Material)materialIn).m_60966_();
    }

    public static BlockBehaviour.Properties getProperties(Block block) {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)block);
    }

    private static ToIntFunction<BlockState> getLightValueLit(int lightValue) {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? lightValue : 0;
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
        InfernalExpansion.LOGGER.info("Infernal Expansion: Blocks Registered!");
    }

    public static <T extends Block> RegistryObject<T> registerBlockWithDefaultItem(String name, Supplier<? extends T> blockSupplier) {
        RegistryObject block = BLOCKS.register(name, blockSupplier);
        IEItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(InfernalExpansion.TAB)));
        return block;
    }

    public static <T extends Block> RegistryObject<T> registerBlockWithDefaultItemConditioned(String name, Supplier<? extends T> blockSupplier, String modID) {
        if (ModList.get().isLoaded(modID)) {
            RegistryObject block = BLOCKS.register(name, blockSupplier);
            IEItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(InfernalExpansion.TAB)));
            return block;
        }
        RegistryObject block = BLOCKS.register(name, blockSupplier);
        IEItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    public static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<? extends T> blockSupplier) {
        return BLOCKS.register(name, blockSupplier);
    }
}

