/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.entities;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.init.IESoundEvents;
import org.infernalstudios.infernalexp.init.IETags;

public class EmbodyEntity
extends Monster {
    public EmbodyEntity(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.randomizeAttributes();
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22282_, 1.2);
    }

    protected void randomizeAttributes() {
        this.m_21051_(Attributes.f_22279_).m_22100_(this.getModifiedMovementSpeed());
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.6, true));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        if (InfernalExpansionConfig.MobInteractions.SKELETON_ATTACK_EMBODY.getBoolean()) {
            this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, true, false));
        }
        if (InfernalExpansionConfig.MobInteractions.EMBODY_ATTACK_PLAYER.getBoolean()) {
            this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        }
        if (InfernalExpansionConfig.MobInteractions.EMBODY_ATTACK_PIGLIN.getBoolean()) {
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractPiglin.class, true, false));
        }
    }

    protected double getModifiedMovementSpeed() {
        return ((double)0.45f + this.f_19796_.nextDouble() * 0.3 + this.f_19796_.nextDouble() * 0.3 + this.f_19796_.nextDouble() * 0.3) * 0.5;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_19385_().equals("fall") && this.m_20075_().m_204336_(IETags.Blocks.EMBODY_FALL_BLOCKS)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6126_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected int m_6552_(Player player) {
        return 1 + this.f_19853_.f_46441_.nextInt(2);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)IESoundEvents.EMBODY_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IESoundEvents.EMBODY_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)IESoundEvents.EMBODY_HURT.get();
    }
}

