/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.entities;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolActions;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.entities.GlowsquitoEntity;
import org.infernalstudios.infernalexp.init.IESoundEvents;

public class BlackstoneDwarfEntity
extends PathfinderMob
implements NeutralMob {
    private static final UniformInt RANGED_INT = TimeUtil.m_145020_((int)20, (int)39);
    private int attackTimer;
    private int angerTime;
    private UUID angerTarget;

    public BlackstoneDwarfEntity(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22278_, 2.0).m_22268_(Attributes.f_22279_, 0.4);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.m_5496_((SoundEvent)IESoundEvents.BASALT_GIANT_DEATH.get(), 1.0f, 1.0f);
        } else {
            super.m_7822_(id);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag;
        Player player;
        this.attackTimer = 10;
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        boolean disableShield = false;
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (int)f > 0 ? f / 2.0f + (float)this.f_19796_.nextInt((int)f) : f;
        float f2 = (float)this.m_21133_(Attributes.f_22282_);
        if (entityIn instanceof Player && (player = (Player)entityIn).m_21211_().canPerformAction(ToolActions.SHIELD_BLOCK)) {
            this.attackFling(entityIn, f2 * 3.0f, 2.0);
            entityIn.f_19864_ = true;
            disableShield = true;
        }
        if (flag = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), f1)) {
            this.attackFling(entityIn, f2, 0.6);
        }
        if (disableShield) {
            ((Player)entityIn).m_36384_(true);
        }
        this.m_5496_((SoundEvent)IESoundEvents.BASALT_GIANT_HURT.get(), 1.0f, 1.0f);
        return flag;
    }

    private void attackFling(Entity entityIn, float f2, double height) {
        ((LivingEntity)entityIn).m_147240_((double)f2, (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
        entityIn.m_20256_(entityIn.m_20184_().m_82520_(0.0, height, 0.0));
        this.m_19970_((LivingEntity)this, entityIn);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.6, true));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        if (InfernalExpansionConfig.MobInteractions.DWARF_ATTACK_PIGLIN.getBoolean()) {
            this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractPiglin.class, true, false));
        }
        if (InfernalExpansionConfig.MobInteractions.DWARF_ATTACK_ZOMBIE_PIGLIN.getBoolean()) {
            this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, ZombifiedPiglin.class, true, false));
        }
        if (InfernalExpansionConfig.MobInteractions.DWARF_ATTACK_PLAYER.getBoolean()) {
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        }
        if (InfernalExpansionConfig.MobInteractions.GLOWSQUITO_ATTACK_DWARF.getBoolean()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, GlowsquitoEntity.class, true));
        }
    }

    protected int m_6552_(Player player) {
        return 2 + this.f_19853_.f_46441_.nextInt(2);
    }

    public boolean m_5825_() {
        return true;
    }

    public int m_6784_() {
        return this.angerTime;
    }

    public void m_7870_(int time) {
        this.angerTime = time;
    }

    @Nullable
    public UUID m_6120_() {
        return this.angerTarget;
    }

    public void m_6925_(@Nullable UUID target) {
        this.angerTarget = target;
    }

    public void m_6825_() {
        this.m_7870_(RANGED_INT.m_142270_(this.f_19796_));
    }
}

