/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.config;

import java.util.Arrays;
import java.util.Locale;
import javax.annotation.Nonnull;

public final class InfernalExpansionConfig {

    public static enum Miscellaneous {
        SHROOMLIGHT_GROWABLE("isShroomlightGrowable", false, 0.0, 0.0, 0.0f),
        SHROOMLIGHT_GROW_CHANCE("shroomlightGrowChance", true, 0.0, 1.0, 0.01f),
        LUMINOUS_FUNGUS_ACTIVATE_DISTANCE("luminousFungusActivateDistance", true, 0.0, 100.0, 1.0f),
        FIRE_CHARGE_EXPLOSION("fireChargeExplosion", false, 0.0, 1.0, 1.0f),
        JERKY_EFFECT_DURATION("jerkyEffectDuration", true, 1.0, 120.0, 1.0f),
        JERKY_EFFECT_AMPLIFIER("jerkyEffectAmplifier", true, 0.0, 2.0, 1.0f),
        LUMINOUS_FUNGUS_GIVES_EFFECT("luminousFungusGivesEffect", false, 0.0, 0.0, 0.0f),
        USE_THROWABLE_BRICKS("useThrowableBricks", false, 0.0, 0.0, 0.0f);

        private final String translationName;
        private final boolean isSlider;
        private final double minValue;
        private final double maxValue;
        private final float stepSize;
        private double value;

        private Miscellaneous(String translationName, boolean isSlider, double minValue, double maxValue, float stepSize) {
            this.translationName = translationName;
            this.isSlider = isSlider;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.stepSize = stepSize;
            this.value = 0.0;
        }

        public String getTranslationName() {
            return this.translationName;
        }

        public double getMinValue() {
            return this.minValue;
        }

        public double getMaxValue() {
            return this.maxValue;
        }

        public float getStepSize() {
            return this.stepSize;
        }

        public void set(double value) {
            this.value = value;
        }

        public void set(boolean value) {
            this.value = value ? 1.0 : 0.0;
        }

        public double getDouble() {
            return this.value;
        }

        public int getInt() {
            return (int)this.value;
        }

        public boolean getBool() {
            return this.value > 0.0;
        }

        public boolean isSlider() {
            return this.isSlider;
        }
    }

    public static enum MobSpawning {
        VOLINE("voline"),
        WARPBEETLE("warpbeetle"),
        SHROOMLOIN("shroomloin"),
        BASALT_GIANT("basalt_giant"),
        EMBODY("embody"),
        GLOWSQUITO("glowsquito"),
        GLOWSILK_MOTH("glowsilk_moth"),
        BLINDSIGHT("blindsight"),
        BLACKSTONE_DWARF("blackstone_dwarf");

        private final String translationName;
        private String spawnableBiomes;

        private MobSpawning(String translationName) {
            this.translationName = translationName;
            this.spawnableBiomes = "";
        }

        public String getTranslationName() {
            return this.translationName;
        }

        public void setSpawnableBiomes(String spawnableBiomes) {
            this.spawnableBiomes = spawnableBiomes;
        }

        public String getSpawnableBiomes() {
            return this.spawnableBiomes;
        }

        public static MobSpawning getByName(@Nonnull String name) {
            return MobSpawning.valueOf(name.toUpperCase(Locale.ROOT));
        }

        public static boolean contains(@Nonnull String name) {
            return Arrays.stream(MobSpawning.values()).anyMatch(entity -> entity.getTranslationName().equals(name));
        }
    }

    public static enum MobInteractions {
        PIGLIN_FEAR_WARPBEETLE("piglinFearWarpbeetle", false),
        PIGLIN_FEAR_EMBODY("piglinFearEmbody", false),
        PIGLIN_FEAR_DWARF("piglinFearDwarf", false),
        HOGLIN_FEAR_WARPBEETLE("hoglinFearWarpbeetle", false),
        HOGLIN_FEAR_EMBODY("hoglinFearEmbody", false),
        SPIDER_ATTACK_WARPBEETLE("spiderAttackWarpbeetle", false),
        SKELETON_ATTACK_PIGLIN("skeletonAttackPiglin", false),
        SKELETON_ATTACK_BRUTE("skeletonAttackBrute", false),
        SKELETON_ATTACK_EMBODY("skeletonAttackEmbody", false),
        SKELETON_ATTACK_GIANT("skeletonAttackGiant", false),
        PIGLIN_ATTACK_SKELETON("piglinAttackSkeleton", false),
        PIGLIN_ATTACK_VOLINE("piglinAttackVoline", false),
        BRUTE_ATTACK_SKELETON("bruteAttackSkeleton", false),
        BRUTE_ATTACK_VOLINE("bruteAttackVoline", false),
        GHAST_ATTACK_EMBODY("ghastAttackEmbody", false),
        GHAST_ATTACK_VOLINE("ghastAttackVoline", false),
        GHAST_ATTACK_SKELETON("ghastAttackSkeleton", false),
        GHAST_ATTACK_GLOWSQUITO("ghastAttackGlowsquito", false),
        GLOWSQUITO_ATTACK_DWARF("glowsquitoAttackDwarf", false),
        GLOWSQUITO_ATTACK_LUMINOUS("glowsquitoAttackLuminous", false),
        DWARF_ATTACK_PIGLIN("dwarfAttackPiglin", false),
        DWARF_ATTACK_ZOMBIE_PIGLIN("dwarfAttackZombiePiglin", false),
        DWARF_ATTACK_PLAYER("dwarfAttackPlayer", false),
        BLINDSIGHT_ATTACK_GLOWSQUITO("blindsightAttackGlowsquito", false),
        BLINDSIGHT_ATTACK_PLAYER("blindsightAttackPlayer", false),
        GIANT_ATTACK_MAGMA_CUBE("giantAttackMagmaCube", false),
        EMBODY_ATTACK_PIGLIN("embodyAttackPiglin", false),
        EMBODY_ATTACK_PLAYER("embodyAttackPlayer", false),
        VOLINE_ATTACK_FIRE_RESISTANCE("volineAttackFireResistance", false),
        VOLINE_ATTACK_PLAYER("volineAttackPlayer", false),
        VOLINE_ATTACK_MAGMA_CUBE("volineAttackMagmaCube", false),
        USE_HOGCHOPS("useHogchops", false),
        GLOWSILK_SPEED("glowsilkSpeed", true);

        private final String translationName;
        private final boolean isSlider;
        private boolean booleanValue;
        private double doubleValue;

        private MobInteractions(String translationName, boolean isSlider) {
            this.translationName = translationName;
            this.isSlider = isSlider;
            this.booleanValue = false;
            this.doubleValue = 0.0;
        }

        public String getTranslationName() {
            return this.translationName;
        }

        public boolean getBoolean() {
            return this.booleanValue;
        }

        public void setBoolean(boolean value) {
            this.booleanValue = value;
        }

        public double getDouble() {
            return this.doubleValue;
        }

        public void setDouble(double value) {
            this.doubleValue = value;
        }

        public boolean isSlider() {
            return this.isSlider;
        }
    }

    public static enum ClientConfig {
        LUMINOUS_REFRESH_DELAY("luminousRefreshDelay", true, 1.0, 20.0, 1.0f);

        private final String translationName;
        private final boolean isSlider;
        private final double minValue;
        private final double maxValue;
        private final float stepSize;
        private double value;

        private ClientConfig(String translationName, boolean isSlider, double minValue, double maxValue, float stepSize) {
            this.translationName = translationName;
            this.isSlider = isSlider;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.stepSize = stepSize;
            this.value = 0.0;
        }

        public String getTranslationName() {
            return this.translationName;
        }

        public double getMinValue() {
            return this.minValue;
        }

        public double getMaxValue() {
            return this.maxValue;
        }

        public float getStepSize() {
            return this.stepSize;
        }

        public void set(double value) {
            this.value = value;
        }

        public void set(boolean value) {
            this.value = value ? 1.0 : 0.0;
        }

        public double getDouble() {
            return this.value;
        }

        public boolean getBool() {
            return this.value > 0.0;
        }

        public boolean isSlider() {
            return this.isSlider;
        }
    }
}

