/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.infernalstudios.infernalexp.entities.CerobeetleEntity;

public class CerobeetleModel<T extends CerobeetleEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("infernalexp", "cerobeetle"), "main");
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftShield;
    private final ModelPart leftWing;
    private final ModelPart leftWing2;
    private final ModelPart rightShield;
    private final ModelPart rightWing;
    private final ModelPart rightWing2;
    private final ModelPart leftLeg1;
    private final ModelPart leftLeg2;
    private final ModelPart leftLeg3;
    private final ModelPart rightLeg1;
    private final ModelPart rightLeg2;
    private final ModelPart rightLeg3;

    public CerobeetleModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.head = root.m_171324_("head");
        this.leftShield = root.m_171324_("left_shield");
        this.leftWing = root.m_171324_("left_wing");
        this.leftWing2 = root.m_171324_("left_wing_2");
        this.rightShield = root.m_171324_("right_shield");
        this.rightWing = root.m_171324_("right_wing");
        this.rightWing2 = root.m_171324_("right_wing_2");
        this.leftLeg1 = root.m_171324_("left_leg_1");
        this.leftLeg2 = root.m_171324_("left_leg_2");
        this.leftLeg3 = root.m_171324_("left_leg_3");
        this.rightLeg1 = root.m_171324_("right_leg_1");
        this.rightLeg2 = root.m_171324_("right_leg_2");
        this.rightLeg3 = root.m_171324_("right_leg_3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-10.0f, -12.0f, -18.0f, 20.0f, 12.0f, 34.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)22.0f, (float)0.0f));
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(86, 16).m_171488_(-6.0f, -4.0f, -8.0f, 12.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 31).m_171488_(0.0f, -17.0f, -16.0f, 0.0f, 19.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)-18.0f));
        partdefinition.m_171599_("left_shield", CubeListBuilder.m_171558_().m_171514_(56, 58).m_171488_(-1.0f, -3.0f, 0.0f, 12.0f, 12.0f, 32.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)10.0f, (float)-12.0f));
        partdefinition.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(94, 41).m_171488_(-4.0f, 0.0f, -1.0f, 10.0f, 0.0f, 19.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)10.0f, (float)-11.0f));
        partdefinition.m_171599_("left_wing_2", CubeListBuilder.m_171558_().m_171514_(82, 60).m_171488_(-5.0f, 0.0f, 0.0f, 12.0f, 0.0f, 30.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)10.0f, (float)-10.0f));
        partdefinition.m_171599_("right_shield", CubeListBuilder.m_171558_().m_171514_(0, 46).m_171488_(-11.0f, -3.0f, 0.0f, 12.0f, 12.0f, 32.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)10.0f, (float)-12.0f));
        partdefinition.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(94, 41).m_171480_().m_171488_(-6.0f, 0.0f, -2.0f, 10.0f, 0.0f, 19.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)10.0f, (float)-10.0f));
        partdefinition.m_171599_("right_wing_2", CubeListBuilder.m_171558_().m_171514_(82, 60).m_171480_().m_171488_(-7.0f, 0.0f, 0.0f, 12.0f, 0.0f, 30.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)10.0f, (float)-10.0f));
        partdefinition.m_171599_("left_leg_1", CubeListBuilder.m_171558_().m_171514_(62, 12).m_171488_(0.0f, 0.0f, -7.5f, 10.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)10.0f, (float)20.0f, (float)-14.5f, (float)0.0f, (float)0.0f, (float)0.3491f));
        partdefinition.m_171599_("left_leg_2", CubeListBuilder.m_171558_().m_171514_(62, 0).m_171488_(0.0f, 0.0f, -7.5f, 10.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)10.0f, (float)20.0f, (float)1.5f, (float)0.0f, (float)0.0f, (float)0.3927f));
        partdefinition.m_171599_("left_leg_3", CubeListBuilder.m_171558_().m_171514_(44, 58).m_171488_(0.0f, 0.0f, -5.5f, 10.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)10.0f, (float)20.0f, (float)11.5f, (float)0.0f, (float)0.0f, (float)0.3491f));
        partdefinition.m_171599_("right_leg_1", CubeListBuilder.m_171558_().m_171514_(44, 46).m_171488_(-10.0f, 0.0f, -7.5f, 10.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-10.0f, (float)20.0f, (float)-14.5f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        partdefinition.m_171599_("right_leg_2", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-10.0f, 0.0f, -7.5f, 10.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-10.0f, (float)20.0f, (float)1.5f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        partdefinition.m_171599_("right_leg_3", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-10.0f, 0.0f, -5.5f, 10.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-10.0f, (float)20.0f, (float)11.5f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(CerobeetleEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.leftLeg1.f_104205_ = Mth.m_14089_((float)(limbSwing * 1.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg2.f_104205_ = Mth.m_14089_((float)(limbSwing * 1.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leftLeg3.f_104205_ = Mth.m_14089_((float)(limbSwing * 1.6662f)) * 1.4f * limbSwingAmount;
        this.rightLeg1.f_104205_ = Mth.m_14089_((float)(limbSwing * 1.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightLeg2.f_104205_ = Mth.m_14089_((float)(limbSwing * 1.6662f)) * 1.4f * limbSwingAmount;
        this.rightLeg3.f_104205_ = Mth.m_14089_((float)(limbSwing * 1.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        if (!entity.m_20096_()) {
            entity.shellRotationMultiplier += 0.1f;
            if (entity.shellRotationMultiplier > 1.0f) {
                entity.shellRotationMultiplier = 1.0f;
            }
            float wingRotation = Mth.m_14089_((float)(ageInTicks * 2.1f)) * (float)Math.PI * 0.15f + 1.0f;
            this.setRotationAngle(this.leftWing, wingRotation, 0.5f, 0.3f);
            this.setRotationAngle(this.rightWing, wingRotation, -0.5f, -0.3f);
            this.setRotationAngle(this.leftWing2, wingRotation, 0.4f, 0.2f);
            this.setRotationAngle(this.rightWing2, wingRotation, -0.4f, -0.2f);
        } else {
            entity.shellRotationMultiplier -= 0.1f;
            if (entity.shellRotationMultiplier < 0.0f) {
                entity.shellRotationMultiplier = 0.0f;
            }
            this.setRotationAngle(this.leftWing, 0.0f, 0.0f, 0.0f);
            this.setRotationAngle(this.rightWing, 0.0f, 0.0f, 0.0f);
            this.setRotationAngle(this.leftWing2, 0.0f, 0.0f, 0.0f);
            this.setRotationAngle(this.rightWing2, 0.0f, -0.0f, -0.0f);
        }
        this.setRotationAngle(this.leftShield, 1.2f * entity.shellRotationMultiplier, -0.4f * entity.shellRotationMultiplier, 0.9f * entity.shellRotationMultiplier);
        this.setRotationAngle(this.rightShield, 1.2f * entity.shellRotationMultiplier, 0.4f * entity.shellRotationMultiplier, -0.9f * entity.shellRotationMultiplier);
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
        this.head.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
        this.leftShield.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
        this.leftWing.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
        this.leftWing2.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
        this.rightShield.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
        this.rightWing.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
        this.rightWing2.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
        this.leftLeg1.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
        this.leftLeg2.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
        this.leftLeg3.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
        this.rightLeg1.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
        this.rightLeg2.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
        this.rightLeg3.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
    }

    public void prepareMobModel(CerobeetleEntity entity, float limbSwing, float limbSwingAmount, float partialTick) {
        int i = entity.getAttackTimer();
        if (i > 0) {
            this.head.f_104203_ = -0.9f + 0.9f * Mth.m_14156_((float)((float)i - partialTick), (float)10.0f);
        }
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }
}

