/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponpassive;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.skill.weaponinnate.TrueBerserkSkill;
import reascer.wom.world.capabilities.item.WOMWeaponCategories;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.level.block.FractureBlockState;

public class TormentPassiveSkill
extends PassiveSkill {
    private static final SkillDataManager.SkillDataKey<Integer> TIMER = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    private static final SkillDataManager.SkillDataKey<Boolean> ACTIVE = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    public static final SkillDataManager.SkillDataKey<Integer> CHARGING_TIME = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    public static final SkillDataManager.SkillDataKey<Integer> SAVED_CHARGE = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    private static final SkillDataManager.SkillDataKey<Boolean> CHARGING = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    private static final SkillDataManager.SkillDataKey<Boolean> SUPER_ARMOR = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    private static final SkillDataManager.SkillDataKey<Boolean> CHARGED = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    private static final SkillDataManager.SkillDataKey<Boolean> CHARGED_ATTACK = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    private static final SkillDataManager.SkillDataKey<Boolean> MOVESPEED = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    private static final UUID EVENT_UUID = UUID.fromString("72eabb8f-f889-4302-80bb-690bb557a008");

    public TormentPassiveSkill(Skill.Builder<?> builder) {
        super(builder.setActivateType(Skill.ActivateType.DURATION_INFINITE));
    }

    public void onInitiate(SkillContainer container) {
        container.getDataManager().registerData(TIMER);
        container.getDataManager().registerData(ACTIVE);
        container.getDataManager().registerData(CHARGING);
        container.getDataManager().registerData(CHARGING_TIME);
        container.getDataManager().registerData(SAVED_CHARGE);
        container.getDataManager().registerData(SUPER_ARMOR);
        container.getDataManager().registerData(CHARGED);
        container.getDataManager().registerData(CHARGED_ATTACK);
        container.getDataManager().registerData(MOVESPEED);
        if (!container.getExecuter().isLogicalClient()) {
            container.getDataManager().setDataSync(MOVESPEED, (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
        }
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID, event -> {
            if (((LocalPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory() == WOMWeaponCategories.TORMENT && container.getExecuter().getEntityState().canBasicAttack() && container.getExecuter().getStamina() > 0.0f) {
                ((LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
                ((Player)container.getExecuter().getOriginal()).m_6858_(false);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {
            if (((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory() == WOMWeaponCategories.TORMENT && container.getExecuter().getEntityState().canBasicAttack() && container.getExecuter().getStamina() > 0.0f) {
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
                container.getDataManager().setDataSync(CHARGING, (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                ((Player)container.getExecuter().getOriginal()).m_6858_(false);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(CHARGED_ATTACK)).booleanValue() || ((Boolean)container.getDataManager().getDataValue(CHARGED)).booleanValue()) {
                event.setDamage(event.getDamage() * 3.0f);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID, event -> {
            ServerPlayerPatch entitypatch = (ServerPlayerPatch)event.getPlayerPatch();
            AttackAnimation anim = (AttackAnimation)event.getDamageSource().getAnimation();
            AnimationPlayer player = entitypatch.getAnimator().getPlayerFor((DynamicAnimation)event.getDamageSource().getAnimation());
            float elapsedTime = player.getElapsedTime();
            AttackAnimation.Phase phase = anim.getPhaseByTime(elapsedTime);
            if (((Boolean)container.getDataManager().getDataValue(CHARGED_ATTACK)).booleanValue() && phase == anim.phases[0]) {
                container.getDataManager().setDataSync(CHARGED, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                ((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123762_, event.getTarget().m_20185_() - 0.15, event.getTarget().m_20186_() + 1.2, event.getTarget().m_20189_() - 0.15, 25, 0.0, 0.0, 0.0, 0.2);
                ((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123756_, event.getTarget().m_20185_() - 0.15, event.getTarget().m_20186_() + 1.2, event.getTarget().m_20189_() - 0.15, 25, 0.0, 0.0, 0.0, 1.0);
            } else {
                container.getDataManager().setDataSync(CHARGED, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                container.getDataManager().setDataSync(CHARGED_ATTACK, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(SUPER_ARMOR)).booleanValue() || ((Boolean)container.getDataManager().getDataValue(CHARGING)).booleanValue()) {
                event.setAmount(event.getAmount() * 0.8f);
                ((EpicFightDamageSource)event.getDamageSource()).setStunType(StunType.NONE);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if (event.getAnimation().equals((Object)WOMAnimations.SHADOWSTEP_BACKWARD) || event.getAnimation().equals((Object)WOMAnimations.SHADOWSTEP_FORWARD)) {
                container.getDataManager().setDataSync(MOVESPEED, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
            if (event.getAnimation().equals((Object)WOMAnimations.TORMENT_AUTO_1) || event.getAnimation().equals((Object)WOMAnimations.TORMENT_AUTO_2) || event.getAnimation().equals((Object)WOMAnimations.TORMENT_AUTO_3) || !event.getAnimation().equals((Object)WOMAnimations.TORMENT_AUTO_4)) {
                // empty if block
            }
            container.getDataManager().setDataSync(CHARGED_ATTACK, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            if (((Boolean)container.getDataManager().getDataValue(CHARGED)).booleanValue()) {
                container.getDataManager().setDataSync(CHARGED_ATTACK, (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
            container.getDataManager().setDataSync(CHARGING, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            if ((Integer)container.getDataManager().getDataValue(SAVED_CHARGE) < 20) {
                container.getDataManager().setDataSync(SAVED_CHARGE, (Object)((Integer)container.getDataManager().getDataValue(CHARGING_TIME)), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
            container.getDataManager().setDataSync(CHARGING_TIME, (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID, event -> {
            if (event.getAnimation().equals((Object)WOMAnimations.TORMENT_AUTO_1) || event.getAnimation().equals((Object)WOMAnimations.TORMENT_AUTO_2) || event.getAnimation().equals((Object)WOMAnimations.TORMENT_AUTO_3) || !event.getAnimation().equals((Object)WOMAnimations.TORMENT_AUTO_4)) {
                // empty if block
            }
            container.getDataManager().setDataSync(CHARGED_ATTACK, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            container.getDataManager().setDataSync(CHARGED, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        if (container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getSkill() instanceof TrueBerserkSkill) {
            return ((Boolean)container.getDataManager().getDataValue(CHARGING) != false || (Boolean)container.getDataManager().getDataValue(CHARGED) != false || (Integer)container.getDataManager().getDataValue(SAVED_CHARGE) > 0) && (Boolean)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue(TrueBerserkSkill.ACTIVE) == false;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, PoseStack poseStack, float x, float y) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)gui.getSlidingProgression(), 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WOMSkills.TRUE_BERSERK.getSkillTexture());
        GuiComponent.m_93160_((PoseStack)poseStack, (int)((int)x), (int)((int)y), (int)24, (int)24, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
        int charge = 0;
        charge = (Integer)container.getDataManager().getDataValue(SAVED_CHARGE) > 0 ? ((Integer)container.getDataManager().getDataValue(SAVED_CHARGE) + 10) / 30 : ((Integer)container.getDataManager().getDataValue(CHARGING_TIME) + 10) / 30;
        if (((Boolean)container.getDataManager().getDataValue(CHARGED)).booleanValue()) {
            gui.font.m_92750_(poseStack, String.valueOf(charge), x + 8.0f, y + 4.0f, 0xFFFFFF);
            gui.font.m_92750_(poseStack, "x3", x + 5.0f, y + 13.0f, 0xFFFFFF);
        } else {
            gui.font.m_92750_(poseStack, String.valueOf(charge), x + 8.0f, y + 6.0f, 0xFFFFFF);
        }
        poseStack.m_85849_();
    }

    public void updateContainer(SkillContainer container) {
        PlayerPatch entitypatch;
        if (container.getExecuter().isLogicalClient() && (container.getExecuter().getCurrentLivingMotion() == LivingMotions.WALK || container.getExecuter().getCurrentLivingMotion() == LivingMotions.RUN) && !((Player)container.getExecuter().getOriginal()).m_6117_()) {
            entitypatch = container.getExecuter();
            float interpolation = 0.0f;
            OpenMatrix4f transformMatrix = entitypatch.getArmature().getBindedTransformFor(entitypatch.getArmature().getPose(interpolation), Armatures.BIPED.toolR);
            transformMatrix.translate(new Vec3f(0.0f, -0.0f, -1.2f));
            OpenMatrix4f.mul((OpenMatrix4f)new OpenMatrix4f().rotate(-((float)Math.toRadians(((Player)entitypatch.getOriginal()).f_20884_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f)), (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
            transformMatrix.translate(new Vec3f(0.0f, 0.0f, -(new Random().nextFloat() * 1.0f)));
            float dpx = transformMatrix.m30 + (float)((Player)entitypatch.getOriginal()).m_20185_();
            float dpy = transformMatrix.m31 + (float)((Player)entitypatch.getOriginal()).m_20186_();
            float dpz = transformMatrix.m32 + (float)((Player)entitypatch.getOriginal()).m_20189_();
            BlockState blockstate = ((Player)entitypatch.getOriginal()).f_19853_.m_8055_(new BlockPos(new Vec3((double)dpx, (double)dpy, (double)dpz)));
            BlockPos blockpos = new BlockPos(new Vec3((double)dpx, (double)dpy, (double)dpz));
            while ((blockstate.m_60734_() instanceof BushBlock || blockstate.m_60795_()) && !blockstate.m_60713_(Blocks.f_50626_)) {
                blockstate = ((Player)entitypatch.getOriginal()).f_19853_.m_8055_(new BlockPos(new Vec3((double)dpx, (double)(dpy -= 1.0f), (double)dpz)));
            }
            while (blockstate instanceof FractureBlockState) {
                float f = dpy;
                dpy = f - 1.0f;
                blockpos = new BlockPos((double)dpx, (double)f, (double)dpz);
                blockstate = ((Player)entitypatch.getOriginal()).f_19853_.m_8055_(blockpos.m_7495_());
            }
            if ((double)transformMatrix.m31 + ((Player)entitypatch.getOriginal()).m_20186_() < (double)(dpy + 1.5f)) {
                for (int i = 0; i < 2; ++i) {
                    ((Player)entitypatch.getOriginal()).f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), (double)transformMatrix.m30 + ((Player)entitypatch.getOriginal()).m_20185_(), (double)transformMatrix.m31 + ((Player)entitypatch.getOriginal()).m_20186_() - (double)0.2f, (double)transformMatrix.m32 + ((Player)entitypatch.getOriginal()).m_20189_(), (double)((new Random().nextFloat() - 0.5f) * 0.005f), (double)(new Random().nextFloat() * 0.02f), (double)((new Random().nextFloat() - 0.5f) * 0.005f));
                }
            }
        }
        if (((Boolean)container.getDataManager().getDataValue(CHARGED)).booleanValue()) {
            entitypatch = container.getExecuter();
            int numberOf = 2;
            float partialScale = 1.0f / (float)(numberOf - 1);
            float interpolation = 0.0f;
            for (int i = 0; i < numberOf; ++i) {
                OpenMatrix4f transformMatrix = entitypatch.getArmature().getBindedTransformFor(entitypatch.getArmature().getPose(interpolation), Armatures.BIPED.toolR);
                transformMatrix.translate(new Vec3f(0.0f, 0.0f, -1.0f));
                OpenMatrix4f.mul((OpenMatrix4f)new OpenMatrix4f().rotate(-((float)Math.toRadians(((Player)entitypatch.getOriginal()).f_20884_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f)), (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
                transformMatrix.translate(new Vec3f(0.0f, 0.0f, -(new Random().nextFloat() * 1.0f)));
                ((Player)entitypatch.getOriginal()).f_19853_.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.8f, 0.6f, 0.0f), 1.0f), (double)transformMatrix.m30 + ((Player)entitypatch.getOriginal()).m_20185_() + (double)((new Random().nextFloat() - 0.5f) * 0.55f), (double)transformMatrix.m31 + ((Player)entitypatch.getOriginal()).m_20186_() + (double)((new Random().nextFloat() - 0.5f) * 0.55f), (double)transformMatrix.m32 + ((Player)entitypatch.getOriginal()).m_20189_() + (double)((new Random().nextFloat() - 0.5f) * 0.55f), 0.0, 0.0, 0.0);
                ((Player)entitypatch.getOriginal()).f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)transformMatrix.m30 + ((Player)entitypatch.getOriginal()).m_20185_() + (double)((new Random().nextFloat() - 0.5f) * 0.75f), (double)transformMatrix.m31 + ((Player)entitypatch.getOriginal()).m_20186_() + (double)((new Random().nextFloat() - 0.5f) * 0.75f), (double)transformMatrix.m32 + ((Player)entitypatch.getOriginal()).m_20189_() + (double)((new Random().nextFloat() - 0.5f) * 0.75f), 0.0, 0.0, 0.0);
                interpolation += partialScale;
            }
        }
        if (!container.getExecuter().isLogicalClient()) {
            AttributeModifier charging_Movementspeed = new AttributeModifier(EVENT_UUID, "torment.charging_movespeed", 3.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
            ServerPlayerPatch executer = (ServerPlayerPatch)container.getExecuter();
            int sweeping_edge = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)executer.getOriginal()));
            if (((Boolean)container.getDataManager().getDataValue(CHARGING)).booleanValue() && !((Player)container.getExecuter().getOriginal()).m_6117_() && container.getExecuter().getEntityState().canBasicAttack()) {
                container.getDataManager().setDataSync(MOVESPEED, (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                int animation_timer = (Integer)container.getDataManager().getDataValue(CHARGING_TIME);
                if ((Integer)container.getDataManager().getDataValue(CHARGING_TIME) < 20 && (Integer)container.getDataManager().getDataValue(SAVED_CHARGE) >= 20) {
                    animation_timer = (Integer)container.getDataManager().getDataValue(SAVED_CHARGE);
                }
                if ((Integer)container.getDataManager().getDataValue(CHARGING_TIME) >= 110) {
                    ((Player)container.getExecuter().getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19596_, 4, 2, true, false, false));
                    ((Player)container.getExecuter().getOriginal()).f_19853_.m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), EpicFightSounds.WHOOSH_BIG, SoundSource.PLAYERS, 1.0f, 1.2f);
                    if (!((Player)container.getExecuter().getOriginal()).m_7500_() && !container.getExecuter().consumeStamina(3.0f)) {
                        container.getExecuter().setStamina(0.0f);
                    }
                } else if (animation_timer >= 80) {
                    container.getExecuter().playAnimationSynchronized(WOMAnimations.TORMENT_CHARGED_ATTACK_3, 0.0f);
                } else if (animation_timer >= 50) {
                    container.getExecuter().playAnimationSynchronized(WOMAnimations.TORMENT_CHARGED_ATTACK_2, 0.0f);
                } else if (animation_timer >= 20) {
                    container.getExecuter().playAnimationSynchronized(WOMAnimations.TORMENT_CHARGED_ATTACK_1, 0.0f);
                } else if (!((Boolean)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue(TrueBerserkSkill.ACTIVE)).booleanValue()) {
                    ((Player)container.getExecuter().getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19596_, 4, 1, true, false, false));
                    ((Player)container.getExecuter().getOriginal()).f_19853_.m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), EpicFightSounds.WHOOSH_BIG, SoundSource.PLAYERS, 1.0f, 1.2f);
                    if (!((Player)container.getExecuter().getOriginal()).m_7500_() && !container.getExecuter().consumeStamina(3.0f)) {
                        container.getExecuter().setStamina(0.0f);
                    }
                } else {
                    ((Player)container.getExecuter().getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19596_, 7, 3, true, false, false));
                    ((Player)container.getExecuter().getOriginal()).f_19853_.m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), EpicFightSounds.WHOOSH_BIG, SoundSource.PLAYERS, 1.0f, 1.2f);
                    float stamina = container.getExecuter().getStamina();
                    float maxStamina = container.getExecuter().getMaxStamina();
                    float staminaRegen = (float)((Player)container.getExecuter().getOriginal()).m_21133_((Attribute)EpicFightAttributes.STAMINA_REGEN.get());
                    int regenStandbyTime = 900 / (int)(30.0f * staminaRegen);
                    if (container.getExecuter().getTickSinceLastAction() > regenStandbyTime) {
                        if (!((Player)container.getExecuter().getOriginal()).m_7500_()) {
                            float staminaFactor = 1.0f + (float)Math.pow(stamina / (maxStamina - stamina * 0.5f), 2.0);
                            if (!container.getExecuter().consumeStamina(2.0f + maxStamina * 0.05f * staminaFactor * staminaRegen)) {
                                container.getExecuter().setStamina(0.0f);
                            }
                        }
                    } else if (!((Player)container.getExecuter().getOriginal()).m_7500_() && !container.getExecuter().consumeStamina(2.0f)) {
                        container.getExecuter().setStamina(0.0f);
                    }
                }
                container.getDataManager().setDataSync(CHARGING, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                container.getDataManager().setDataSync(CHARGING_TIME, (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                container.getDataManager().setDataSync(SAVED_CHARGE, (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                ((Player)container.getExecuter().getOriginal()).m_21051_(Attributes.f_22279_).m_22130_(charging_Movementspeed);
            }
            if (((Boolean)container.getDataManager().getDataValue(CHARGING)).booleanValue()) {
                ((Player)container.getExecuter().getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 5, 0, true, false, false));
                if (((Player)container.getExecuter().getOriginal()).m_21051_(Attributes.f_22279_).m_22111_(EVENT_UUID) == null && ((Boolean)container.getDataManager().getDataValue(MOVESPEED)).booleanValue()) {
                    ((Player)container.getExecuter().getOriginal()).m_21051_(Attributes.f_22279_).m_22125_(charging_Movementspeed);
                }
                container.getDataManager().setDataSync(CHARGING_TIME, (Object)((Integer)container.getDataManager().getDataValue(CHARGING_TIME) + 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                if ((Integer)container.getDataManager().getDataValue(CHARGING_TIME) <= 130) {
                    if ((Integer)container.getDataManager().getDataValue(CHARGING_TIME) == 20) {
                        container.getDataManager().setDataSync(SAVED_CHARGE, (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                        ((Player)container.getExecuter().getOriginal()).f_19853_.m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 1.0f, 0.6f);
                        this.consume_stamina(container);
                    }
                    if ((Integer)container.getDataManager().getDataValue(CHARGING_TIME) == 50) {
                        ((Player)container.getExecuter().getOriginal()).f_19853_.m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 1.0f, 0.65f);
                        this.consume_stamina(container);
                    }
                    if ((Integer)container.getDataManager().getDataValue(CHARGING_TIME) == 80) {
                        ((Player)container.getExecuter().getOriginal()).f_19853_.m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 1.0f, 0.7f);
                        this.consume_stamina(container);
                    }
                    if ((Integer)container.getDataManager().getDataValue(CHARGING_TIME) == 110) {
                        container.getDataManager().setDataSync(CHARGED, (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                        ((Player)container.getExecuter().getOriginal()).f_19853_.m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 1.0f, 0.5f);
                        ((Player)container.getExecuter().getOriginal()).f_19853_.m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_11699_, SoundSource.MASTER, 2.5f, 0.5f);
                        this.consume_stamina(container);
                    }
                    if ((Integer)container.getDataManager().getDataValue(CHARGING_TIME) == 130) {
                        container.getDataManager().setDataSync(CHARGING_TIME, (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                        ((Player)container.getExecuter().getOriginal()).m_21051_(Attributes.f_22279_).m_22130_(charging_Movementspeed);
                    }
                }
            } else {
                ((Player)container.getExecuter().getOriginal()).m_21051_(Attributes.f_22279_).m_22130_(charging_Movementspeed);
            }
        }
    }

    public void consume_stamina(SkillContainer container) {
        if (!((Player)container.getExecuter().getOriginal()).m_7500_()) {
            if (container.getExecuter().getStamina() <= 0.0f) {
                ((Player)container.getExecuter().getOriginal()).m_5810_();
            }
            if (!container.getExecuter().consumeStamina(3.0f)) {
                container.getExecuter().setStamina(0.0f);
                ((Player)container.getExecuter().getOriginal()).f_19853_.m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_12031_, ((Player)container.getExecuter().getOriginal()).m_5720_(), 1.0f, 2.0f);
            }
        }
    }
}

