/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponpassive;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.skill.weaponinnate.LunarEclipseSkill;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class LunarEchoPassiveSkill
extends PassiveSkill {
    public static final SkillDataManager.SkillDataKey<Boolean> IDLE = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    public static final SkillDataManager.SkillDataKey<Boolean> VERSO = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    private static final UUID EVENT_UUID = UUID.fromString("bc38699e-0de8-11ed-861d-0242ac120002");

    public LunarEchoPassiveSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getDataManager().registerData(IDLE);
        container.getDataManager().registerData(VERSO);
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
    }

    public boolean shouldDeactivateAutomatically(PlayerPatch<?> executer) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        if (container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getSkill() instanceof LunarEclipseSkill) {
            return ((Float)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue(LunarEclipseSkill.LUNAR_ECLIPSE_STACK)).floatValue() > 0.0f;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, PoseStack poseStack, float x, float y) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)gui.getSlidingProgression(), 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WOMSkills.lUNAR_ECLIPSE.getSkillTexture());
        GuiComponent.m_93160_((PoseStack)poseStack, (int)((int)x), (int)((int)y), (int)24, (int)24, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
        if (container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getSkill() == WOMSkills.lUNAR_ECLIPSE && ((Float)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue(LunarEclipseSkill.LUNAR_ECLIPSE_STACK)).floatValue() > 0.0f) {
            float lunar_eclipse_stack = ((Float)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue(LunarEclipseSkill.LUNAR_ECLIPSE_STACK)).floatValue();
            int lunar_eclipse_damage = (int)((double)(4.0f * lunar_eclipse_stack) * (1.0 / Math.sqrt(lunar_eclipse_stack / 8.0f + 1.0f)));
            int nombre_de_chiffre = (int)Math.log(lunar_eclipse_damage);
            gui.font.m_92750_(poseStack, String.valueOf(lunar_eclipse_damage), x + 8.0f - (float)(2 * nombre_de_chiffre), y + 8.0f, 0xFFFFFF);
        }
        poseStack.m_85849_();
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        PlayerPatch entitypatch = container.getExecuter();
        int numberOf = 3;
        float partialScale = 1.0f / (float)(numberOf - 1);
        float interpolation = 0.0f;
        if (entitypatch.currentLivingMotion == LivingMotions.IDLE) {
            container.getDataManager().setData(IDLE, (Object)false);
        }
        if (((Boolean)container.getDataManager().getDataValue(IDLE)).booleanValue()) {
            int numberOf2 = 2;
            float partialScale2 = 1.0f / (float)(numberOf2 - 1);
            float interpolation2 = 0.0f;
            for (int i = 0; i < numberOf2; ++i) {
                int j;
                OpenMatrix4f transformMatrix = entitypatch.getArmature().getBindedTransformFor(entitypatch.getArmature().getPose(interpolation2), Armatures.BIPED.toolL);
                transformMatrix.translate(new Vec3f(0.0f, 0.0f, 0.0f));
                OpenMatrix4f.mul((OpenMatrix4f)new OpenMatrix4f().rotate(-((float)Math.toRadians(((Player)entitypatch.getOriginal()).f_20884_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f)), (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
                for (j = 0; j < 1; ++j) {
                    ((Player)entitypatch.getOriginal()).f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)transformMatrix.m30 + ((Player)entitypatch.getOriginal()).m_20185_() + (double)((new Random().nextFloat() - 0.5f) * 0.35f), (double)transformMatrix.m31 + ((Player)entitypatch.getOriginal()).m_20186_() + (double)((new Random().nextFloat() - 0.5f) * 0.35f), (double)transformMatrix.m32 + ((Player)entitypatch.getOriginal()).m_20189_() + (double)((new Random().nextFloat() - 0.5f) * 0.35f), (double)((new Random().nextFloat() - 0.5f) * 0.05f), (double)((new Random().nextFloat() - 0.5f) * 0.05f), (double)((new Random().nextFloat() - 0.5f) * 0.05f));
                }
                for (j = 0; j < 1; ++j) {
                    ((Player)entitypatch.getOriginal()).f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)transformMatrix.m30 + ((Player)entitypatch.getOriginal()).m_20185_(), (double)transformMatrix.m31 + ((Player)entitypatch.getOriginal()).m_20186_(), (double)transformMatrix.m32 + ((Player)entitypatch.getOriginal()).m_20189_(), 0.0, 0.05, 0.0);
                }
                interpolation += partialScale2;
            }
        }
        if (container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getSkill() == WOMSkills.lUNAR_ECLIPSE && ((Float)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue(LunarEclipseSkill.LUNAR_ECLIPSE_STACK)).floatValue() > 0.0f) {
            float lunar_eclipse_stack = ((Float)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue(LunarEclipseSkill.LUNAR_ECLIPSE_STACK)).floatValue();
            int lunar_eclipse_damage = (int)((double)(4.0f * lunar_eclipse_stack) * (1.0 / Math.sqrt(lunar_eclipse_stack / 8.0f + 1.0f)));
            int numberOf2 = lunar_eclipse_damage / 30;
            float partialScale2 = 1.0f / (float)(numberOf2 - 1);
            float interpolation2 = 0.0f;
            for (int i = 0; i < numberOf2; ++i) {
                OpenMatrix4f transformMatrix2 = entitypatch.getArmature().getBindedTransformFor(entitypatch.getArmature().getPose(interpolation2), Armatures.BIPED.toolR);
                transformMatrix2.translate(new Vec3f(0.0f, 1.7f, 0.2f));
                OpenMatrix4f.mul((OpenMatrix4f)new OpenMatrix4f().rotate(-((float)Math.toRadians(((Player)entitypatch.getOriginal()).f_20884_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f)), (OpenMatrix4f)transformMatrix2, (OpenMatrix4f)transformMatrix2);
                float blade = -(new Random().nextFloat() * 2.4f);
                transformMatrix2.translate(new Vec3f(-((new Random().nextFloat() - 0.5f) * 0.4f), blade, -((new Random().nextFloat() - 0.5f) * 0.4f)));
                ((Player)entitypatch.getOriginal()).f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_175830_, (double)transformMatrix2.m30 + ((Player)entitypatch.getOriginal()).m_20185_(), (double)transformMatrix2.m31 + ((Player)entitypatch.getOriginal()).m_20186_(), (double)transformMatrix2.m32 + ((Player)entitypatch.getOriginal()).m_20189_(), 0.0, 0.0, 0.0);
                interpolation2 += partialScale2;
            }
        }
    }
}

