/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponinnate;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.gameasset.WOMAnimations;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightEntityDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.PlayerEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillConsumeEvent;

public class TrueBerserkSkill
extends WeaponInnateSkill {
    private static final SkillDataManager.SkillDataKey<Integer> TIMER = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    public static final SkillDataManager.SkillDataKey<Boolean> ACTIVE = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    private static final SkillDataManager.SkillDataKey<Boolean> SUPER_ARMOR = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    private static final UUID EVENT_UUID = UUID.fromString("16c6748a-1c74-4681-9edb-e9ea4d69e54f");

    public TrueBerserkSkill(Skill.Builder<?> builder) {
        super(builder.setActivateType(Skill.ActivateType.DURATION_INFINITE));
    }

    public void onInitiate(SkillContainer container) {
        container.getDataManager().registerData(TIMER);
        container.getDataManager().registerData(ACTIVE);
        container.getDataManager().registerData(SUPER_ARMOR);
        if (!container.getExecuter().isLogicalClient()) {
            this.setMaxDurationSynchronize((ServerPlayerPatch)container.getExecuter(), this.maxDuration + EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)container.getExecuter().getOriginal())));
        }
    }

    public void onRemoved(SkillContainer container) {
        if (!container.getExecuter().isLogicalClient()) {
            container.getSkill().cancelOnServer((ServerPlayerPatch)container.getExecuter(), null);
        }
        container.deactivate();
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        if (executer.getSkill((Skill)this).isActivated()) {
            super.cancelOnServer(executer, args);
            executer.getSkill((Skill)this).getDataManager().setDataSync(ACTIVE, (Object)false, (ServerPlayer)executer.getOriginal());
            this.setDurationSynchronize(executer, 0);
            this.setStackSynchronize(executer, executer.getSkill((Skill)this).getStack() - 1);
            executer.getSkill((Skill)this).deactivate();
            executer.modifyLivingMotionByCurrentItem();
        } else {
            executer.playAnimationSynchronized(WOMAnimations.TORMENT_BERSERK_CONVERT, 0.0f);
            ((ServerPlayer)executer.getOriginal()).f_19853_.m_6263_(null, ((ServerPlayer)executer.getOriginal()).f_19854_, ((ServerPlayer)executer.getOriginal()).f_19855_, ((ServerPlayer)executer.getOriginal()).f_19856_, SoundEvents.f_11892_, ((ServerPlayer)executer.getOriginal()).m_5720_(), 1.0f, 0.5f);
            ((ServerLevel)((ServerPlayer)executer.getOriginal()).f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123755_, ((ServerPlayer)executer.getOriginal()).m_20185_() - 0.15, ((ServerPlayer)executer.getOriginal()).m_20186_() + 1.2, ((ServerPlayer)executer.getOriginal()).m_20189_() - 0.15, 150, 0.3, 0.6, 0.3, 0.1);
            executer.getSkill((Skill)this).getDataManager().setData(TIMER, (Object)2);
            executer.getSkill((Skill)this).getDataManager().setDataSync(ACTIVE, (Object)true, (ServerPlayer)executer.getOriginal());
            this.setDurationSynchronize(executer, this.maxDuration + EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)executer.getOriginal())));
            executer.getSkill((Skill)this).activate();
            executer.modifyLivingMotionByCurrentItem();
            SkillConsumeEvent event = new SkillConsumeEvent((PlayerPatch)executer, (Skill)this, this.resource, true);
            executer.getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, (PlayerEvent)event);
            if (!event.isCanceled()) {
                event.getResourceType().consumer.consume((Skill)this, executer, event.getAmount());
            }
            this.setStackSynchronize(executer, 1);
        }
    }

    public void cancelOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        super.cancelOnServer(executer, args);
        executer.getSkill((Skill)this).getDataManager().setDataSync(ACTIVE, (Object)false, (ServerPlayer)executer.getOriginal());
        this.setStackSynchronize(executer, executer.getSkill((Skill)this).getStack() - 1);
        this.setDurationSynchronize(executer, 0);
        executer.modifyLivingMotionByCurrentItem();
    }

    public boolean canExecute(PlayerPatch<?> executer) {
        if (executer.isLogicalClient()) {
            return super.canExecute(executer);
        }
        ItemStack itemstack = ((Player)executer.getOriginal()).m_21205_();
        return EpicFightCapabilities.getItemStackCapability((ItemStack)itemstack).getInnateSkill(executer, itemstack) == this && ((Player)executer.getOriginal()).m_20202_() == null;
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        List list = super.getTooltipOnItem(itemStack, cap, playerCap);
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "Auto attack :");
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(1), "Dash attack :");
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onScreen(LocalPlayerPatch playerpatch, float resolutionX, float resolutionY) {
        if (((Boolean)playerpatch.getSkill((Skill)this).getDataManager().getDataValue(ACTIVE)).booleanValue()) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("wom", "textures/gui/overlay/true_berserk.png"));
            GlStateManager.m_84525_();
            GlStateManager.m_84507_();
            GlStateManager.m_84328_((int)770, (int)771);
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tessellator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_5483_(0.0, 0.0, 1.0).m_7421_(0.0f, 0.0f).m_5752_();
            bufferbuilder.m_5483_(0.0, (double)resolutionY, 1.0).m_7421_(0.0f, 1.0f).m_5752_();
            bufferbuilder.m_5483_((double)resolutionX, (double)resolutionY, 1.0).m_7421_(1.0f, 1.0f).m_5752_();
            bufferbuilder.m_5483_((double)resolutionX, 0.0, 1.0).m_7421_(1.0f, 0.0f).m_5752_();
            tessellator.m_85914_();
        }
    }

    public void updateContainer(SkillContainer container) {
        if (container.isActivated()) {
            if (((Boolean)container.getDataManager().getDataValue(ACTIVE)).booleanValue()) {
                ((Player)container.getExecuter().getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 2, 0, true, false, false));
                if ((Integer)container.getDataManager().getDataValue(TIMER) > 0) {
                    container.getDataManager().setData(TIMER, (Object)((Integer)container.getDataManager().getDataValue(TIMER) - 1));
                } else {
                    container.getDataManager().setData(TIMER, (Object)3);
                    if (container.getRemainDuration() > 1) {
                        if (!container.getExecuter().isLogicalClient()) {
                            this.setDurationSynchronize((ServerPlayerPatch)container.getExecuter(), container.getRemainDuration() - 1);
                        }
                    } else if (((Player)container.getExecuter().getOriginal()).m_21223_() - ((Player)container.getExecuter().getOriginal()).m_21233_() * 0.04f > 0.0f) {
                        DamageSource damage = new EpicFightEntityDamageSource("Heartattack_from_wrath", container.getExecuter().getOriginal(), WOMAnimations.TORMENT_BERSERK_CONVERT).setStunType(StunType.NONE).cast().m_19380_().m_19382_();
                        ((Player)container.getExecuter().getOriginal()).m_6469_(damage, ((Player)container.getExecuter().getOriginal()).m_21233_() * 0.04f);
                        if (!container.getExecuter().isLogicalClient()) {
                            if (!((Player)container.getExecuter().getOriginal()).m_7500_()) {
                                ((ServerLevel)((Player)container.getExecuter().getOriginal()).f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123762_, ((Player)container.getExecuter().getOriginal()).m_20185_() - 0.2, ((Player)container.getExecuter().getOriginal()).m_20186_() + 1.3, ((Player)container.getExecuter().getOriginal()).m_20189_() - 0.2, 40, 0.6, 0.8, 0.6, 0.05);
                            }
                            this.setDurationSynchronize((ServerPlayerPatch)container.getExecuter(), this.maxDuration + EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)container.getExecuter().getOriginal())));
                        }
                    } else {
                        if (!container.getExecuter().isLogicalClient()) {
                            container.getSkill().cancelOnServer((ServerPlayerPatch)container.getExecuter(), null);
                            this.setDurationSynchronize((ServerPlayerPatch)container.getExecuter(), 0);
                        }
                        container.deactivate();
                    }
                }
            } else if (!container.getExecuter().isLogicalClient()) {
                container.getSkill().cancelOnServer((ServerPlayerPatch)container.getExecuter(), null);
            }
        }
    }
}

