/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponinnate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.Vec3;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.skill.WomMultipleAnimationSkill;
import reascer.wom.skill.guard.CounterAttack;
import reascer.wom.world.item.HerscherItem;
import reascer.wom.world.item.MagneticShieldItem;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class RegierungSkill
extends WomMultipleAnimationSkill {
    private static final SkillDataManager.SkillDataKey<Integer> COMBO = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    private static final SkillDataManager.SkillDataKey<Integer> COOLDOWN = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    public static final SkillDataManager.SkillDataKey<Boolean> GUARD_POINT = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    public static final SkillDataManager.SkillDataKey<Integer> GUARD_POINT_RESULT = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    public static final SkillDataManager.SkillDataKey<Boolean> GESETZ_SPRENGKOPF = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    public static final SkillDataManager.SkillDataKey<Boolean> SUPER_ARMOR = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    private static final UUID EVENT_UUID = UUID.fromString("63c38d4f-cc97-4339-bedf-d9bba36ba29f");

    public RegierungSkill(Skill.Builder<? extends Skill> builder) {
        super(builder, executer -> {
            int combo = (Integer)executer.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue(COMBO);
            return combo;
        }, WOMAnimations.GESETZ_AUTO_1, WOMAnimations.GESETZ_AUTO_2, WOMAnimations.GESETZ_AUTO_3, WOMAnimations.GESETZ_KRUMMEN, WOMAnimations.GESETZ_SPRENGKOPF);
    }

    public void onInitiate(SkillContainer container) {
        container.getDataManager().registerData(COMBO);
        container.getDataManager().registerData(COOLDOWN);
        container.getDataManager().registerData(GUARD_POINT);
        container.getDataManager().registerData(GUARD_POINT_RESULT);
        container.getDataManager().registerData(GESETZ_SPRENGKOPF);
        container.getDataManager().registerData(SUPER_ARMOR);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(SUPER_ARMOR)).booleanValue()) {
                ((EpicFightDamageSource)event.getDamageSource()).setStunType(StunType.NONE);
            }
        });
        if (!container.getExecuter().isLogicalClient()) {
            container.getDataManager().setDataSync(COMBO, (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            this.maxDuration += 200 * EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)((ServerPlayerPatch)container.getExecuter()).getOriginal()));
        }
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(GESETZ_SPRENGKOPF)).booleanValue() && container.getRemainDuration() > 0) {
                float attackDamage = event.getDamage();
                event.setDamage(attackDamage + (float)(container.getRemainDuration() / 20));
                ((Player)container.getExecuter().getOriginal()).m_183634_();
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> container.getDataManager().setData(GUARD_POINT, (Object)false));
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if (!container.getExecuter().isLogicalClient()) {
                container.getDataManager().setDataSync(GESETZ_SPRENGKOPF, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                container.getDataManager().setDataSync(COOLDOWN, (Object)40, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                if (!event.getAnimation().equals((Object)WOMAnimations.HERRSCHER_AUTO_2) && !event.getAnimation().equals((Object)WOMAnimations.GESETZ_AUTO_1)) {
                    container.getDataManager().setDataSync(GUARD_POINT, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
                if (event.getAnimation().equals((Object)WOMAnimations.HERRSCHER_GUARD_HIT)) {
                    this.setDurationSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.getRemainDuration() + 40);
                }
                if (event.getAnimation().equals((Object)WOMAnimations.GESETZ_SPRENGKOPF)) {
                    container.getDataManager().setDataSync(SUPER_ARMOR, (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
                if (event.getAnimation().equals((Object)WOMAnimations.HERRSCHER_TRANE)) {
                    this.setDurationSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.getRemainDuration() + 100);
                    container.getDataManager().setDataSync(COMBO, (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(GUARD_POINT)).booleanValue()) {
                DamageSource damageSource = (DamageSource)event.getDamageSource();
                boolean isFront = false;
                Vec3 sourceLocation = damageSource.m_7270_();
                if (sourceLocation != null) {
                    Vec3 viewVector = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20252_(1.0f);
                    Vec3 toSourceLocation = sourceLocation.m_82546_(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_()).m_82541_();
                    if (toSourceLocation.m_82526_(viewVector) > 0.0) {
                        isFront = true;
                    }
                }
                if (isFront) {
                    float impact = 0.5f;
                    float knockback = 0.25f;
                    if (event.getDamageSource() instanceof EpicFightDamageSource) {
                        impact = ((EpicFightDamageSource)event.getDamageSource()).getImpact();
                        knockback += Math.min(impact * 0.1f, 1.0f);
                    }
                    ServerPlayer playerentity = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
                    ((ServerPlayerPatch)event.getPlayerPatch()).playSound(EpicFightSounds.CLASH, -0.05f, 0.1f);
                    ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument((ServerLevel)playerentity.f_19853_, HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)playerentity, damageSource.m_7640_());
                    StaticAnimation animation = Animations.BIPED_HIT_SHIELD;
                    float convert = -0.05f;
                    switch ((Integer)container.getDataManager().getDataValue(GUARD_POINT_RESULT)) {
                        case 1: {
                            animation = WOMAnimations.GESETZ_AUTO_1;
                            container.getDataManager().setDataSync(COMBO, (Object)1, playerentity);
                            this.setDurationSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.getRemainDuration() + 20);
                            break;
                        }
                        case 2: {
                            animation = WOMAnimations.HERRSCHER_AUTO_2;
                            this.setDurationSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.getRemainDuration() + 40);
                            break;
                        }
                        case 3: {
                            animation = WOMAnimations.HERRSCHER_AUTO_3;
                            this.setDurationSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.getRemainDuration() + 100);
                            convert = -0.45f;
                            break;
                        }
                        case 4: {
                            animation = WOMAnimations.HERRSCHER_TRANE;
                            convert = -0.15f;
                            break;
                        }
                        case 5: {
                            animation = WOMAnimations.HERRSCHER_AUTO_2;
                            container.getDataManager().setDataSync(COMBO, (Object)1, playerentity);
                            this.setDurationSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.getRemainDuration() + 40);
                            break;
                        }
                        case 6: {
                            animation = WOMAnimations.HERRSCHER_BEFREIUNG;
                            convert = -0.25f;
                            this.setDurationSynchronize((ServerPlayerPatch)event.getPlayerPatch(), container.getRemainDuration() + 20);
                            break;
                        }
                        default: {
                            animation = Animations.BIPED_HIT_SHIELD;
                        }
                    }
                    ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(animation, convert);
                    event.setCanceled(true);
                    event.setResult(AttackResult.ResultType.BLOCKED);
                    Entity directEntity = ((DamageSource)event.getDamageSource()).m_7640_();
                    LivingEntityPatch entitypatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)directEntity, LivingEntityPatch.class);
                    if (entitypatch != null) {
                        entitypatch.onAttackBlocked((DamageSource)event.getDamageSource(), entitypatch);
                    }
                }
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID);
        if (container.getExecuter().getSkill(WOMSkills.COUNTER_ATTACK) != null && !container.getExecuter().isLogicalClient()) {
            container.getExecuter().getSkill(WOMSkills.COUNTER_ATTACK).getDataManager().setDataSync(CounterAttack.CONSUMPTION_VALUE, (Object)Float.valueOf(1.0f), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
        }
    }

    @Override
    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        ServerPlayer player = (ServerPlayer)executer.getOriginal();
        if (!player.m_20096_() && !player.m_20069_() && (player.f_19853_.m_46859_(player.m_142538_().m_7495_()) || player.f_19855_ - (double)player.m_142538_().m_123342_() > 0.2)) {
            if (!executer.consumeStamina(3.0f)) {
                executer.setStamina(0.0f);
            } else {
                executer.playAnimationSynchronized(this.attackAnimations[this.attackAnimations.length - 1], 0.0f);
            }
        } else if (((ServerPlayer)executer.getOriginal()).m_20142_()) {
            if (!executer.consumeStamina(2.0f)) {
                executer.setStamina(0.0f);
            } else {
                executer.playAnimationSynchronized(this.attackAnimations[this.attackAnimations.length - 2], 0.0f);
            }
            executer.getSkill((Skill)this).getDataManager().setDataSync(COMBO, (Object)0, (ServerPlayer)executer.getOriginal());
        } else {
            int animation = this.getAnimationInCondition(executer);
            executer.playAnimationSynchronized(this.attackAnimations[animation], 0.0f);
            if ((Integer)executer.getSkill((Skill)this).getDataManager().getDataValue(COMBO) < 2) {
                executer.getSkill((Skill)this).getDataManager().setDataSync(COMBO, (Object)((Integer)executer.getSkill((Skill)this).getDataManager().getDataValue(COMBO) + 1), (ServerPlayer)executer.getOriginal());
            } else {
                executer.getSkill((Skill)this).getDataManager().setDataSync(COMBO, (Object)0, (ServerPlayer)executer.getOriginal());
            }
        }
        executer.getSkill((Skill)this).getDataManager().setDataSync(COOLDOWN, (Object)40, (ServerPlayer)executer.getOriginal());
    }

    public boolean canExecute(PlayerPatch<?> executer) {
        return executer.getValidItemInHand(InteractionHand.OFF_HAND).m_41720_() instanceof MagneticShieldItem && executer.getValidItemInHand(InteractionHand.MAIN_HAND).m_41720_() instanceof HerscherItem;
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        executer.updateEntityState();
        EntityState playerState = executer.getEntityState();
        return !((Player)executer.getOriginal()).m_21255_() && executer.currentLivingMotion != LivingMotions.FALL && playerState.canUseSkill() && executer.getEntityState().canBasicAttack();
    }

    public boolean resourcePredicate(PlayerPatch<?> playerpatch) {
        return true;
    }

    @Override
    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        ArrayList list = Lists.newArrayList();
        String traslatableText = this.getTranslationKey();
        list.add(new TranslatableComponent(traslatableText).m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent(String.format("[%.0f]", Float.valueOf(this.consumption))).m_130940_(ChatFormatting.AQUA)));
        list.add(new TranslatableComponent(traslatableText + ".tooltip").m_130940_(ChatFormatting.DARK_GRAY));
        return list;
    }

    @Override
    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if ((Integer)container.getDataManager().getDataValue(COOLDOWN) > 0) {
            if (!container.getExecuter().isLogicalClient()) {
                container.getDataManager().setDataSync(COOLDOWN, (Object)((Integer)container.getDataManager().getDataValue(COOLDOWN) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
        } else if (!container.getExecuter().isLogicalClient()) {
            container.getExecuter().getSkill((Skill)this).getDataManager().setDataSync(COMBO, (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
        }
        if (container.getExecuter().getSkill(WOMSkills.COUNTER_ATTACK) != null && ((Float)container.getExecuter().getSkill(WOMSkills.COUNTER_ATTACK).getDataManager().getDataValue(CounterAttack.CONSUMPTION_VALUE)).floatValue() != 0.2f && !container.getExecuter().isLogicalClient()) {
            container.getExecuter().getSkill(WOMSkills.COUNTER_ATTACK).getDataManager().setDataSync(CounterAttack.CONSUMPTION_VALUE, (Object)Float.valueOf(0.2f), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
        }
        if (((Boolean)container.getDataManager().getDataValue(SUPER_ARMOR)).booleanValue()) {
            ((Player)container.getExecuter().getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 5, 0, true, false, false));
        }
        container.setResource(10.0f);
    }
}

