/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponinnate;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.skill.weaponpassive.LunarEchoPassiveSkill;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightEntityDamageSource;
import yesman.epicfight.world.damagesource.SourceTag;
import yesman.epicfight.world.damagesource.SourceTags;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.eventlistener.DealtDamageEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class LunarEclipseSkill
extends WeaponInnateSkill {
    private static final UUID EVENT_UUID = UUID.fromString("c7a0ee46-56b3-4008-9fba-d2594b1e2676");
    public static final SkillDataManager.SkillDataKey<Boolean> ECHO = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    public static final SkillDataManager.SkillDataKey<Boolean> CRESCENT = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    public static final SkillDataManager.SkillDataKey<Float> LUNAR_ECLIPSE_STACK = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.FLOAT);
    public static final SkillDataManager.SkillDataKey<Integer> TIMER = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);

    public LunarEclipseSkill(Skill.Builder builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        container.getDataManager().registerData(ECHO);
        container.getDataManager().registerData(CRESCENT);
        container.getDataManager().registerData(LUNAR_ECLIPSE_STACK);
        container.getDataManager().registerData(TIMER);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID, event -> {
            int sweeping_edge = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()));
            if (!event.getDamageSource().getAnimation().equals((Object)WOMAnimations.MOONLESS_LUNAR_ECLIPSE)) {
                if (((Boolean)container.getDataManager().getDataValue(ECHO)).booleanValue()) {
                    if (event.getTarget().m_21023_(MobEffects.f_19619_)) {
                        int glowing_amp = event.getTarget().m_21124_(MobEffects.f_19619_).m_19564_();
                        event.getTarget().m_21195_(MobEffects.f_19619_);
                        event.getTarget().m_7292_(new MobEffectInstance(MobEffects.f_19619_, 140, glowing_amp + (2 + EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()))) * 2, true, false, false));
                        AABB box = AABB.m_165882_((Vec3)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_(), (double)(10 + Math.min(40, 1 * glowing_amp)), (double)10.0, (double)(10 + Math.min(40, 1 * glowing_amp)));
                        List list = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19853_.m_45933_(((ServerPlayerPatch)event.getPlayerPatch()).getOriginal(), box);
                        for (Entity entity : list) {
                            LivingEntity livingEntity;
                            if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).m_6084_() || livingEntity.m_21023_(MobEffects.f_19619_)) continue;
                            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 140, glowing_amp + (2 + EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()))) * 2, true, false, false));
                        }
                    } else {
                        event.getTarget().m_7292_(new MobEffectInstance(MobEffects.f_19619_, 140, 0, true, false, false));
                    }
                } else if (((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE) != null && ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getSkill() == WOMSkills.LUNAR_ECHO_PASSIVE) {
                    if (!((Boolean)((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue(LunarEchoPassiveSkill.VERSO)).booleanValue()) {
                        if (event.getTarget().m_21023_(MobEffects.f_19619_)) {
                            if (((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_21023_(MobEffects.f_19609_)) {
                                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_21195_(MobEffects.f_19609_);
                            }
                            ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19609_, 140, 0, true, false, false));
                            container.getDataManager().setDataSync(TIMER, (Object)140, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                            container.getDataManager().setDataSync(LUNAR_ECLIPSE_STACK, (Object)Float.valueOf(((Float)container.getDataManager().getDataValue(LUNAR_ECLIPSE_STACK)).floatValue() + event.getAttackDamage() * 2.0f), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                            ((ServerLevel)event.getTarget().f_19853_).m_6263_(null, event.getTarget().m_20185_(), event.getTarget().m_20186_() + 0.75, event.getTarget().m_20189_(), SoundEvents.f_11736_, ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_5720_(), 4.0f, 2.0f);
                            ((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123747_, event.getTarget().m_20185_(), event.getTarget().m_20186_(), event.getTarget().m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                            if (!event.getTarget().m_21023_(MobEffects.f_19610_)) {
                                event.getTarget().m_7292_(new MobEffectInstance(MobEffects.f_19610_, 140, event.getTarget().m_21124_(MobEffects.f_19619_).m_19564_() * 5, true, false, false));
                            }
                            event.getTarget().m_21195_(MobEffects.f_19619_);
                        }
                    } else {
                        if (event.getTarget().m_21023_(MobEffects.f_19610_)) {
                            int blindess_amp = event.getTarget().m_21124_(MobEffects.f_19610_).m_19564_();
                            int blindess_dur = event.getTarget().m_21124_(MobEffects.f_19610_).m_19557_();
                            event.getTarget().m_21195_(MobEffects.f_19610_);
                            event.getTarget().m_7292_(new MobEffectInstance(MobEffects.f_19610_, blindess_dur, blindess_amp + 5 * (1 + sweeping_edge / 3), true, false, false));
                        }
                        if (event.getTarget().m_21023_(MobEffects.f_19619_)) {
                            if (((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_21023_(MobEffects.f_19609_)) {
                                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_21195_(MobEffects.f_19609_);
                            }
                            ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19609_, 140, 0, true, false, false));
                            container.getDataManager().setDataSync(TIMER, (Object)140, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                            container.getDataManager().setDataSync(LUNAR_ECLIPSE_STACK, (Object)Float.valueOf(((Float)container.getDataManager().getDataValue(LUNAR_ECLIPSE_STACK)).floatValue() + event.getAttackDamage()), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                            ((ServerLevel)event.getTarget().f_19853_).m_6263_(null, event.getTarget().m_20185_(), event.getTarget().m_20186_() + 0.75, event.getTarget().m_20189_(), SoundEvents.f_11736_, ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_5720_(), 4.0f, 2.0f);
                            ((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123747_, event.getTarget().m_20185_(), event.getTarget().m_20186_(), event.getTarget().m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                            if (!event.getTarget().m_21023_(MobEffects.f_19610_)) {
                                event.getTarget().m_7292_(new MobEffectInstance(MobEffects.f_19610_, 140, event.getTarget().m_21124_(MobEffects.f_19619_).m_19564_() * 5, true, false, false));
                            }
                            event.getTarget().m_21195_(MobEffects.f_19619_);
                        }
                    }
                }
                if (((Boolean)container.getDataManager().getDataValue(CRESCENT)).booleanValue() && event.getDamageSource().getAnimation().equals((Object)WOMAnimations.MOONLESS_CRESCENT) && ((Float)container.getDataManager().getDataValue(LUNAR_ECLIPSE_STACK)).floatValue() > 0.0f) {
                    Entity player = ((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
                    if (((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_21023_(MobEffects.f_19609_)) {
                        ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_21195_(MobEffects.f_19609_);
                    }
                    int blindness_amp = 0;
                    if (event.getTarget().m_21023_(MobEffects.f_19610_)) {
                        blindness_amp = event.getTarget().m_21124_(MobEffects.f_19610_).m_19564_();
                        event.getTarget().m_21195_(MobEffects.f_19610_);
                    }
                    int glowing_amp = 0;
                    if (event.getTarget().m_21023_(MobEffects.f_19619_)) {
                        glowing_amp = event.getTarget().m_21124_(MobEffects.f_19619_).m_19564_();
                        event.getTarget().m_21195_(MobEffects.f_19619_);
                    }
                    EpicFightEntityDamageSource epicFightDamageSource = new EpicFightEntityDamageSource("lunar_eclipse", player, WOMAnimations.MOONLESS_LUNAR_ECLIPSE);
                    epicFightDamageSource.setImpact(4.0f);
                    epicFightDamageSource.setStunType(StunType.HOLD);
                    epicFightDamageSource.addTag((SourceTag)SourceTags.WEAPON_INNATE);
                    EpicFightEntityDamageSource damage = epicFightDamageSource;
                    float lunar_eclipse_stack = ((Float)container.getDataManager().getDataValue(LUNAR_ECLIPSE_STACK)).floatValue();
                    float lunar_eclipse_damage = (float)((double)(4.0f * lunar_eclipse_stack) * (1.0 / Math.sqrt(lunar_eclipse_stack / 8.0f + 1.0f)));
                    float lunar_power = lunar_eclipse_damage + lunar_eclipse_damage * ((float)blindness_amp / 100.0f);
                    ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123810_, event.getTarget().m_20185_(), event.getTarget().m_20186_() + 0.25 * (double)((int)((double)lunar_power * (1.0 / Math.sqrt(lunar_power / 8.0f + 1.0f)))), event.getTarget().m_20189_(), 5 * (int)((double)lunar_power * (1.0 / Math.sqrt(lunar_power / 8.0f + 1.0f))), 0.1, 0.5 * (double)((int)((double)lunar_power * (1.0 / Math.sqrt(lunar_power / 8.0f + 1.0f)))), 0.1, 0.0);
                    AABB box = AABB.m_165882_((Vec3)event.getTarget().m_20182_(), (double)(10 + Math.min(40, glowing_amp)), (double)10.0, (double)(10 + Math.min(40, glowing_amp)));
                    List list = event.getTarget().f_19853_.m_45933_(player, box);
                    LivingEntity livingEntityLowestHP = null;
                    float distance_to_stored_target = -1.0f;
                    for (Object entity : list) {
                        if (!(entity instanceof LivingEntity)) continue;
                        LivingEntity livingEntity = (LivingEntity)entity;
                        if (livingEntity.m_21023_(MobEffects.f_19610_)) {
                            int Aoe_blindness_amp = livingEntity.m_21124_(MobEffects.f_19610_).m_19564_();
                            int Aoe_blindness_dur = livingEntity.m_21124_(MobEffects.f_19610_).m_19557_();
                            livingEntity.m_21195_(MobEffects.f_19610_);
                            if (Aoe_blindness_dur < 80) {
                                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 80, Aoe_blindness_amp, true, false, false));
                            }
                        }
                        if (livingEntity.equals((Object)event.getTarget())) {
                            if (livingEntity.m_6084_()) {
                                livingEntity.m_6469_((DamageSource)damage, lunar_power);
                                if (!livingEntity.m_20147_()) {
                                    ((ServerLevel)livingEntity.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123798_, livingEntity.m_20185_(), livingEntity.m_20186_() + 1.0, livingEntity.m_20189_(), 1 * (int)lunar_power, 0.2, 0.2, 0.2, 0.2);
                                }
                                ((ServerLevel)event.getTarget().f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123747_, livingEntity.m_20185_(), livingEntity.m_20186_() + 1.0, livingEntity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                                ((ServerLevel)event.getTarget().f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123810_, livingEntity.m_20185_(), livingEntity.m_20186_() + 1.0, livingEntity.m_20189_(), 5 * (1 + (int)lunar_power / 10), 0.5 * (double)(1 + (int)lunar_power / 20), 0.5 * (double)(1 + (int)lunar_power / 20), 0.5 * (double)(1 + (int)lunar_power / 20), 0.0);
                            }
                        } else if (!(livingEntity instanceof Animal) && livingEntity.m_6084_() && !(livingEntity instanceof Npc)) {
                            if (livingEntityLowestHP == null) {
                                livingEntityLowestHP = livingEntity;
                                distance_to_stored_target = (float)Math.sqrt(Math.pow(livingEntity.m_20185_() - event.getTarget().m_20185_(), 2.0) + Math.pow(livingEntity.m_20189_() - event.getTarget().m_20189_(), 2.0) + Math.pow(livingEntity.m_20186_() - event.getTarget().m_20186_(), 2.0));
                            } else {
                                float distance_to_current_target = (float)Math.sqrt(Math.pow(livingEntity.m_20185_() - event.getTarget().m_20185_(), 2.0) + Math.pow(livingEntity.m_20189_() - event.getTarget().m_20189_(), 2.0) + Math.pow(livingEntity.m_20186_() - event.getTarget().m_20186_(), 2.0));
                                if (distance_to_current_target < distance_to_stored_target) {
                                    livingEntityLowestHP = livingEntity;
                                    distance_to_stored_target = distance_to_current_target;
                                }
                            }
                        }
                        if (event.getPlayerPatch() == null) continue;
                        ((ServerPlayerPatch)event.getPlayerPatch()).getEventListener().triggerEvents(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, (PlayerEvent)new DealtDamageEvent((ServerPlayerPatch)event.getPlayerPatch(), livingEntity, (EpicFightDamageSource)epicFightDamageSource, lunar_power));
                    }
                    if (event.getTarget().m_21224_() && livingEntityLowestHP != null) {
                        Boolean no_lunarEclipse_tag = true;
                        for (String tag : livingEntityLowestHP.m_19880_()) {
                            if (!tag.contains("lunar_eclipse:")) continue;
                            no_lunarEclipse_tag = false;
                            break;
                        }
                        if (no_lunarEclipse_tag.booleanValue()) {
                            livingEntityLowestHP.m_20049_("lunar_eclipse:" + ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_142049_() + ":" + lunar_power * 0.95f);
                        }
                        int lowestHP_blindness_amp = 0;
                        int lowestHP_glowing_amp = 0;
                        if (livingEntityLowestHP.m_21023_(MobEffects.f_19610_)) {
                            lowestHP_blindness_amp = livingEntityLowestHP.m_21124_(MobEffects.f_19610_).m_19564_();
                            livingEntityLowestHP.m_21195_(MobEffects.f_19610_);
                        }
                        if (livingEntityLowestHP.m_21023_(MobEffects.f_19619_)) {
                            lowestHP_glowing_amp = livingEntityLowestHP.m_21124_(MobEffects.f_19619_).m_19564_();
                            if (lowestHP_glowing_amp < glowing_amp) {
                                livingEntityLowestHP.m_21195_(MobEffects.f_19619_);
                                livingEntityLowestHP.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 5, glowing_amp, true, false, false));
                            } else {
                                livingEntityLowestHP.m_21195_(MobEffects.f_19619_);
                                livingEntityLowestHP.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 5, lowestHP_glowing_amp, true, false, false));
                            }
                        } else if (glowing_amp > 0) {
                            livingEntityLowestHP.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 5, glowing_amp, true, false, false));
                        }
                        livingEntityLowestHP.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 3, lowestHP_blindness_amp, true, false, false));
                    }
                    container.getDataManager().setDataSync(LUNAR_ECLIPSE_STACK, (Object)Float.valueOf(0.0f), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                }
                if (event.getDamageSource().getAnimation().equals((Object)WOMAnimations.MOONLESS_FULLMOON) && ((Float)container.getDataManager().getDataValue(LUNAR_ECLIPSE_STACK)).floatValue() > 0.0f) {
                    AnimationPlayer animplayer;
                    float elapsedTime;
                    ServerPlayerPatch entitypatch = (ServerPlayerPatch)event.getPlayerPatch();
                    AttackAnimation anim = (AttackAnimation)event.getDamageSource().getAnimation();
                    AttackAnimation.Phase phase = anim.getPhaseByTime(elapsedTime = (animplayer = entitypatch.getAnimator().getPlayerFor((DynamicAnimation)event.getDamageSource().getAnimation())).getElapsedTime());
                    if (phase == anim.phases[anim.phases.length - 1]) {
                        Entity player = ((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
                        if (((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_21023_(MobEffects.f_19609_)) {
                            ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_21195_(MobEffects.f_19609_);
                        }
                        int blindness_amp = 0;
                        if (event.getTarget().m_21023_(MobEffects.f_19610_)) {
                            blindness_amp = event.getTarget().m_21124_(MobEffects.f_19610_).m_19564_();
                            event.getTarget().m_21195_(MobEffects.f_19610_);
                        }
                        EpicFightEntityDamageSource epicFightDamageSource = new EpicFightEntityDamageSource("lunar_eclipse", player, WOMAnimations.MOONLESS_LUNAR_ECLIPSE);
                        epicFightDamageSource.setImpact(4.0f);
                        epicFightDamageSource.setStunType(StunType.LONG);
                        epicFightDamageSource.addTag((SourceTag)SourceTags.WEAPON_INNATE);
                        EpicFightEntityDamageSource damage = epicFightDamageSource;
                        float lunar_eclipse_stack = ((Float)container.getDataManager().getDataValue(LUNAR_ECLIPSE_STACK)).floatValue();
                        float lunar_eclipse_damage = (float)((double)(4.0f * lunar_eclipse_stack) * (1.0 / Math.sqrt(lunar_eclipse_stack / 8.0f + 1.0f)));
                        float lunar_power = lunar_eclipse_damage + lunar_eclipse_damage * ((float)blindness_amp / 100.0f);
                        ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123810_, event.getTarget().m_20185_(), event.getTarget().m_20186_() + 0.25 * (double)((int)((double)(lunar_power *= 0.7f) * (1.0 / Math.sqrt(lunar_power / 8.0f + 1.0f)))), event.getTarget().m_20189_(), 5 * (int)((double)lunar_power * (1.0 / Math.sqrt(lunar_power / 8.0f + 1.0f))), 0.1, 0.5 * (double)((int)((double)lunar_power * (1.0 / Math.sqrt(lunar_power / 8.0f + 1.0f)))), 0.1, 0.0);
                        ((ServerLevel)event.getTarget().f_19853_).m_6263_(null, event.getTarget().m_20185_(), event.getTarget().m_20186_() + 0.75, event.getTarget().m_20189_(), SoundEvents.f_12089_, ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_5720_(), 2.0f, 2.0f);
                        ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123815_, event.getTarget().m_20185_(), event.getTarget().m_20186_() + 0.25, event.getTarget().m_20189_(), 5 * (int)((double)lunar_power * (1.0 / Math.sqrt(lunar_power / 8.0f + 1.0f))), 0.0, 0.0, 0.0, 0.5);
                        AABB box = AABB.m_165882_((Vec3)event.getTarget().m_20182_(), (double)15.0, (double)15.0, (double)15.0);
                        List list = event.getTarget().f_19853_.m_45933_(player, box);
                        for (Entity entity : list) {
                            if (!(entity instanceof LivingEntity)) continue;
                            LivingEntity livingEntity = (LivingEntity)entity;
                            if (livingEntity.m_21023_(MobEffects.f_19610_)) {
                                int Aoe_blindness_amp = livingEntity.m_21124_(MobEffects.f_19610_).m_19564_();
                                int Aoe_blindness_dur = livingEntity.m_21124_(MobEffects.f_19610_).m_19557_();
                                livingEntity.m_21195_(MobEffects.f_19610_);
                                if (Aoe_blindness_dur < 80) {
                                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 80, Aoe_blindness_amp, true, false, false));
                                }
                            }
                            if (livingEntity.m_6084_()) {
                                int aoe_blindness_amp = 0;
                                if (livingEntity.m_21023_(MobEffects.f_19610_)) {
                                    aoe_blindness_amp = livingEntity.m_21124_(MobEffects.f_19610_).m_19564_();
                                    livingEntity.m_21195_(MobEffects.f_19610_);
                                }
                                livingEntity.m_6469_((DamageSource)damage, lunar_power + lunar_power * (float)aoe_blindness_amp);
                                ((ServerLevel)event.getTarget().f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123747_, livingEntity.m_20185_(), livingEntity.m_20186_() + 1.0, livingEntity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                                ((ServerLevel)event.getTarget().f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123810_, livingEntity.m_20185_(), livingEntity.m_20186_() + 1.0, livingEntity.m_20189_(), 5 * (1 + (int)lunar_power / 10), 0.5 * (double)(1 + (int)lunar_power / 20), 0.5 * (double)(1 + (int)lunar_power / 20), 0.5 * (double)(1 + (int)lunar_power / 20), 0.0);
                            }
                            if (event.getPlayerPatch() != null) {
                                ((ServerPlayerPatch)event.getPlayerPatch()).getEventListener().triggerEvents(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, (PlayerEvent)new DealtDamageEvent((ServerPlayerPatch)event.getPlayerPatch(), livingEntity, (EpicFightDamageSource)epicFightDamageSource, lunar_power));
                            }
                            double power = 1.0;
                            double d1 = event.getTarget().m_20185_() - entity.m_20185_();
                            double d2 = event.getTarget().m_20186_() - 1.0 - entity.m_20186_();
                            if (entity instanceof ItemEntity || entity instanceof ExperienceOrb) {
                                power = 0.0;
                            }
                            double d0 = event.getTarget().m_20189_() - entity.m_20189_();
                            while (d1 * d1 + d0 * d0 < 1.0E-4) {
                                d1 = (Math.random() - Math.random()) * 0.01;
                                d0 = (Math.random() - Math.random()) * 0.01;
                            }
                            if (entity instanceof LivingEntity) {
                                power *= 1.0 - ((LivingEntity)entity).m_21133_(Attributes.f_22278_);
                            }
                            entity.f_19812_ = true;
                            Vec3 vec3 = entity.m_20184_();
                            Vec3 vec31 = new Vec3(d1, d2, d0).m_82541_().m_82490_(power);
                            entity.m_20334_(vec3.f_82479_ / 2.0 - vec31.f_82479_, vec3.f_82480_ / 2.0 - vec31.f_82480_, vec3.f_82481_ / 2.0 - vec31.f_82481_);
                        }
                        container.getDataManager().setDataSync(LUNAR_ECLIPSE_STACK, (Object)Float.valueOf(0.0f), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                    }
                }
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if (!event.getAnimation().equals((Object)WOMAnimations.MOONLESS_LUNAR_ECHO)) {
                container.getDataManager().setDataSync(ECHO, (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
            if (!event.getAnimation().equals((Object)WOMAnimations.MOONLESS_CRESCENT)) {
                container.getDataManager().setDataSync(CRESCENT, (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            } else {
                container.getDataManager().setDataSync(CRESCENT, (Object)true, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        super.executeOnServer(executer, args);
        executer.playAnimationSynchronized(WOMAnimations.MOONLESS_LUNAR_ECHO, 0.0f);
        executer.getSkill((Skill)this).getDataManager().setDataSync(ECHO, (Object)true, (ServerPlayer)executer.getOriginal());
        this.setDurationSynchronize(executer, 0);
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        List list = super.getTooltipOnItem(itemStack, cap, playerCap);
        return list;
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        executer.updateEntityState();
        EntityState playerState = executer.getEntityState();
        return !((Player)executer.getOriginal()).m_21255_() && executer.currentLivingMotion != LivingMotions.FALL && playerState.canUseSkill();
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!container.getExecuter().isLogicalClient()) {
            if (((Float)container.getDataManager().getDataValue(LUNAR_ECLIPSE_STACK)).floatValue() > 0.0f) {
                if ((Integer)container.getDataManager().getDataValue(TIMER) > 0) {
                    container.getDataManager().setDataSync(TIMER, (Object)((Integer)container.getDataManager().getDataValue(TIMER) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                } else {
                    container.getDataManager().setDataSync(LUNAR_ECLIPSE_STACK, (Object)Float.valueOf(0.0f), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
            } else {
                container.getDataManager().setDataSync(TIMER, (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
        }
    }
}

