/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponinnate;

import com.google.common.collect.Lists;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.gameasset.WOMSounds;
import reascer.wom.skill.WomMultipleAnimationSkill;
import reascer.wom.skill.passive.MeditationSkill;
import reascer.wom.world.capabilities.item.WOMWeaponCategories;
import reascer.wom.world.item.WOMItems;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPExecuteSkill;
import yesman.epicfight.network.server.SPSkillExecutionFeedback;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillConsumeEvent;

public class EnderBlastSkill
extends WomMultipleAnimationSkill {
    private static final SkillDataManager.SkillDataKey<Integer> COMBO = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    private static final SkillDataManager.SkillDataKey<Integer> COOLDOWN = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    private static final SkillDataManager.SkillDataKey<Integer> RELOAD_COOLDOWN = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    private static final SkillDataManager.SkillDataKey<Boolean> ZOOM = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    private static final SkillDataManager.SkillDataKey<Boolean> SHOOT = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    private static final SkillDataManager.SkillDataKey<Boolean> NOFALLDAMAGE = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    private static final UUID EVENT_UUID = UUID.fromString("b9023f5e-ee42-11ec-8ea0-0242ac120002");

    public EnderBlastSkill(Skill.Builder<? extends Skill> builder) {
        super(builder, executer -> {
            int combo = (Integer)executer.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue(COMBO);
            return combo;
        }, WOMAnimations.ENDERBLASTER_ONEHAND_SHOOT_1, WOMAnimations.ENDERBLASTER_ONEHAND_SHOOT_2, WOMAnimations.ENDERBLASTER_ONEHAND_SHOOT_3, WOMAnimations.ENDERBLASTER_ONEHAND_SHOOT_2_FORWARD, WOMAnimations.ENDERBLASTER_ONEHAND_SHOOT_2_LEFT, WOMAnimations.ENDERBLASTER_ONEHAND_SHOOT_2_RIGHT, WOMAnimations.ENDERBLASTER_ONEHAND_SHOOT_DASH, WOMAnimations.ENDERBLASTER_ONEHAND_AIRSHOOT);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getDataManager().registerData(COMBO);
        container.getDataManager().registerData(SHOOT);
        container.getDataManager().registerData(COOLDOWN);
        container.getDataManager().registerData(ZOOM);
        container.getDataManager().registerData(RELOAD_COOLDOWN);
        container.getDataManager().registerData(NOFALLDAMAGE);
        if (!container.getExecuter().isLogicalClient()) {
            container.getDataManager().setDataSync(COMBO, (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            container.getDataManager().setDataSync(RELOAD_COOLDOWN, (Object)80, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
        }
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID, event -> {
            if (((LocalPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory() == WOMWeaponCategories.ENDERBLASTER && container.getExecuter().getEntityState().canBasicAttack()) {
                ((LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {
            if (((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory() == WOMWeaponCategories.ENDERBLASTER && container.getExecuter().getEntityState().canBasicAttack()) {
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
                if (!container.getExecuter().isLogicalClient()) {
                    container.getDataManager().setDataSync(SHOOT, (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
            }
            if (!container.getExecuter().isLogicalClient() && ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory() == WOMWeaponCategories.ENDERBLASTER && container.getExecuter().getEntityState().canBasicAttack()) {
                container.getDataManager().setDataSync(COOLDOWN, (Object)40, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                container.getDataManager().setDataSync(ZOOM, (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            container.getDataManager().setDataSync(RELOAD_COOLDOWN, (Object)80, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            if (!event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_ONEHAND_SHOOT) && !event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_ONEHAND_SHOOT_LAYED)) {
                container.getDataManager().setDataSync(SHOOT, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
            if (!(event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_ONEHAND_SHOOT_1) || event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_ONEHAND_SHOOT_2) || event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_ONEHAND_SHOOT_3) || event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_ONEHAND_SHOOT_2_FORWARD) || event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_ONEHAND_SHOOT_2_LEFT) || event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_ONEHAND_SHOOT_2_RIGHT) || event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_ONEHAND_SHOOT_DASH) || event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_ONEHAND_SHOOT) || event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_ONEHAND_AIRSHOOT) || container.getExecuter().isLogicalClient())) {
                container.getDataManager().setDataSync(COOLDOWN, (Object)40, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                container.getDataManager().setDataSync(ZOOM, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
            if (event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_ONEHAND_AIRSHOOT)) {
                container.getDataManager().setDataSync(NOFALLDAMAGE, (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
            if (event.getAnimation().equals((Object)WOMAnimations.ENDERBLASTER_ONEHAND_JUMPKICK)) {
                container.getDataManager().setDataSync(NOFALLDAMAGE, (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                container.getDataManager().setDataSync(COOLDOWN, (Object)40, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                container.getDataManager().setDataSync(ZOOM, (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
    }

    public boolean resourcePredicate(PlayerPatch<?> playerpatch) {
        float consumption = this.getDefaultConsumeptionAmount(playerpatch);
        SkillConsumeEvent event = new SkillConsumeEvent(playerpatch, (Skill)this, this.resource, consumption * 5.0f, false);
        playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, (PlayerEvent)event);
        if (event.isCanceled()) {
            return false;
        }
        if (event.getResourceType().predicate.canExecute((Skill)this, playerpatch, event.getAmount())) {
            int stack = playerpatch.getSkill((Skill)this).getStack();
            if (playerpatch.getSkill(EpicFightSkills.HYPERVITALITY) != null && stack <= 0) {
                if (playerpatch.getSkill(EpicFightSkills.HYPERVITALITY).getStack() > 0) {
                    playerpatch.getSkill(EpicFightSkills.HYPERVITALITY).activate();
                    playerpatch.getSkill(EpicFightSkills.HYPERVITALITY).setMaxResource(6.0f);
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public FriendlyByteBuf gatherArguments(LocalPlayerPatch executer, ControllEngine controllEngine) {
        int forward = controllEngine.isKeyDown(Minecraft.m_91087_().f_91066_.f_92085_) ? 1 : 0;
        int backward = controllEngine.isKeyDown(Minecraft.m_91087_().f_91066_.f_92087_) ? -1 : 0;
        int left = controllEngine.isKeyDown(Minecraft.m_91087_().f_91066_.f_92086_) ? 1 : 0;
        int right = controllEngine.isKeyDown(Minecraft.m_91087_().f_91066_.f_92088_) ? -1 : 0;
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(forward);
        buf.writeInt(backward);
        buf.writeInt(left);
        buf.writeInt(right);
        return buf;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(LocalPlayerPatch executer, FriendlyByteBuf args) {
        int forward = args.readInt();
        int backward = args.readInt();
        int left = args.readInt();
        int right = args.readInt();
        int vertic = forward + backward;
        int horizon = left + right;
        int animation = vertic == 0 ? (horizon == 0 ? -3 : (horizon >= 0 ? 1 : 2)) : (vertic <= 0 ? -2 : 0);
        CPExecuteSkill packet = new CPExecuteSkill(executer.getSkill((Skill)this).getSlotId());
        packet.getBuffer().writeInt(animation);
        return packet;
    }

    @Override
    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        int i = args.readInt();
        boolean double_cost = false;
        ServerPlayer player = (ServerPlayer)executer.getOriginal();
        if (!player.m_20096_() && !player.m_20069_() && (player.f_19853_.m_46859_(player.m_142538_().m_7495_()) || player.f_19855_ - (double)player.m_142538_().m_123342_() > 0.2)) {
            executer.playAnimationSynchronized(this.attackAnimations[this.attackAnimations.length - 1], 0.0f);
        } else if (((ServerPlayer)executer.getOriginal()).m_20142_()) {
            executer.playAnimationSynchronized(this.attackAnimations[this.attackAnimations.length - 2], 0.0f);
        } else {
            if (i != -3 && (Integer)executer.getSkill((Skill)this).getDataManager().getDataValue(COMBO) >= 1) {
                executer.playAnimationSynchronized(this.attackAnimations[i + 3], 0.0f);
                executer.getSkill((Skill)this).getDataManager().setDataSync(COMBO, (Object)1, (ServerPlayer)executer.getOriginal());
            } else {
                int animation = this.getAnimationInCondition(executer);
                executer.playAnimationSynchronized(this.attackAnimations[animation], 0.0f);
                if (animation == 2) {
                    double_cost = true;
                }
            }
            if ((Integer)executer.getSkill((Skill)this).getDataManager().getDataValue(COMBO) < 2) {
                executer.getSkill((Skill)this).getDataManager().setDataSync(COMBO, (Object)((Integer)executer.getSkill((Skill)this).getDataManager().getDataValue(COMBO) + 1), (ServerPlayer)executer.getOriginal());
            } else {
                executer.getSkill((Skill)this).getDataManager().setDataSync(COMBO, (Object)0, (ServerPlayer)executer.getOriginal());
            }
        }
        executer.getSkill((Skill)this).getDataManager().setDataSync(COOLDOWN, (Object)40, (ServerPlayer)executer.getOriginal());
        executer.getSkill((Skill)this).getDataManager().setDataSync(ZOOM, (Object)true, (ServerPlayer)executer.getOriginal());
        executer.getSkill((Skill)this).activate();
        if (!((ServerPlayer)executer.getOriginal()).m_7500_()) {
            int stack = executer.getSkill((Skill)this).getStack();
            SkillConsumeEvent event = new SkillConsumeEvent((PlayerPatch)executer, (Skill)this, this.resource, true);
            executer.getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, (PlayerEvent)event);
            if (!event.isCanceled()) {
                event.getResourceType().consumer.consume((Skill)this, executer, event.getAmount());
                if (double_cost) {
                    event.getResourceType().consumer.consume((Skill)this, executer, event.getAmount());
                }
            }
            int sweeping_edge = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)executer.getOriginal())) + EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44983_, (ItemStack)executer.getValidItemInHand(InteractionHand.OFF_HAND));
            Random random = new Random();
            if ((double)(Math.abs(random.nextInt()) % 100) < 100.0 * (-(1.0 / Math.sqrt(sweeping_edge + 1)) + 1.0)) {
                if (!double_cost || stack != 1) {
                    this.setStackSynchronize(executer, executer.getSkill((Skill)this).getStack() + 1);
                }
                ((ServerPlayer)executer.getOriginal()).f_19853_.m_6263_(null, ((ServerPlayer)executer.getOriginal()).m_20185_(), ((ServerPlayer)executer.getOriginal()).m_20186_(), ((ServerPlayer)executer.getOriginal()).m_20189_(), WOMSounds.ENDERBLASTER_RELOAD, ((ServerPlayer)executer.getOriginal()).m_5720_(), 1.0f, 2.0f);
            }
        }
        executer.getSkill((Skill)this).activate();
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        executer.updateEntityState();
        EntityState playerState = executer.getEntityState();
        return !((Player)executer.getOriginal()).m_21255_() && executer.currentLivingMotion != LivingMotions.FALL && playerState.canUseSkill() && executer.getEntityState().canBasicAttack();
    }

    @Override
    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        ArrayList list = Lists.newArrayList();
        String traslatableText = this.getTranslationKey();
        list.add(new TranslatableComponent(traslatableText).m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent(String.format("[%.0f]", Float.valueOf(this.consumption))).m_130940_(ChatFormatting.AQUA)));
        list.add(new TranslatableComponent(traslatableText + ".tooltip").m_130940_(ChatFormatting.DARK_GRAY));
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "Close range shot:");
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(1), "Bullet shot:");
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(2), "Laser beam:");
        return list;
    }

    @Override
    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!container.getExecuter().isLogicalClient()) {
            if (container.getDataManager().getDataValue(RELOAD_COOLDOWN) == null) {
                container.getDataManager().setDataSync(RELOAD_COOLDOWN, (Object)80, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
            if ((Integer)container.getDataManager().getDataValue(RELOAD_COOLDOWN) > 0) {
                container.getDataManager().setDataSync(RELOAD_COOLDOWN, (Object)((Integer)container.getDataManager().getDataValue(RELOAD_COOLDOWN) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            } else {
                container.getDataManager().setDataSync(RELOAD_COOLDOWN, (Object)80, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                if (container.getExecuter().getSkill((Skill)this).getStack() < this.getMaxStack() && ((Player)container.getExecuter().getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() == WOMItems.ENDER_BLASTER.get()) {
                    if (container.getExecuter().getSkill(WOMSkills.MEDITATION) == null) {
                        container.getExecuter().playAnimationSynchronized(WOMAnimations.ENDERBLASTER_ONEHAND_RELOAD, 0.0f);
                    } else if ((Integer)container.getExecuter().getSkill(WOMSkills.MEDITATION).getDataManager().getDataValue(MeditationSkill.TIMER) == 0 || container.getExecuter().getSkill(WOMSkills.MEDITATION).getDataManager().getDataValue(MeditationSkill.TIMER) == null) {
                        container.getExecuter().playAnimationSynchronized(WOMAnimations.ENDERBLASTER_ONEHAND_RELOAD, 0.0f);
                    }
                }
            }
        }
        if ((Integer)container.getDataManager().getDataValue(COOLDOWN) > 0) {
            if (container.getExecuter().isLogicalClient() && ((Boolean)container.getDataManager().getDataValue(ZOOM)).booleanValue()) {
                ClientEngine.getInstance().renderEngine.zoomIn();
            }
            if (!container.getExecuter().isLogicalClient()) {
                ServerPlayerPatch executer = (ServerPlayerPatch)container.getExecuter();
                container.getDataManager().setDataSync(COOLDOWN, (Object)((Integer)container.getDataManager().getDataValue(COOLDOWN) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                if (((Boolean)container.getDataManager().getDataValue(NOFALLDAMAGE)).booleanValue()) {
                    if ((Integer)container.getDataManager().getDataValue(COOLDOWN) > 10) {
                        ((Player)container.getExecuter().getOriginal()).m_183634_();
                    } else {
                        container.getExecuter().getSkill((Skill)this).getDataManager().setDataSync(NOFALLDAMAGE, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    }
                }
                int sweeping_edge = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)executer.getOriginal()));
                if (((Boolean)container.getDataManager().getDataValue(SHOOT)).booleanValue() && !((Player)container.getExecuter().getOriginal()).m_6117_() && container.getExecuter().getEntityState().canBasicAttack()) {
                    ((Player)container.getExecuter().getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
                    container.getDataManager().setDataSync(SHOOT, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    if (executer.getSkill(EpicFightSkills.HYPERVITALITY) != null || container.getStack() > 0 || ((Player)container.getExecuter().getOriginal()).m_7500_()) {
                        boolean flag = true;
                        if (!((Player)container.getExecuter().getOriginal()).m_7500_()) {
                            int stack = executer.getSkill((Skill)this).getStack();
                            if (executer.getSkill(EpicFightSkills.HYPERVITALITY) != null && stack <= 0) {
                                if (executer.getSkill(EpicFightSkills.HYPERVITALITY).getStack() > 0) {
                                    executer.getSkill(EpicFightSkills.HYPERVITALITY).activate();
                                    executer.getSkill(EpicFightSkills.HYPERVITALITY).setMaxResource(6.0f);
                                    executer.getSkill(EpicFightSkills.HYPERVITALITY).getSkill().setStackSynchronize(executer, -1);
                                    EpicFightNetworkManager.sendToPlayer((Object)SPSkillExecutionFeedback.executed((int)executer.getSkill(EpicFightSkills.HYPERVITALITY).getSlotId()), (ServerPlayer)((ServerPlayer)executer.getOriginal()));
                                } else {
                                    flag = false;
                                }
                            }
                            if (flag) {
                                this.setStackSynchronize(executer, executer.getSkill((Skill)this).getStack() - 1);
                                Random random = new Random();
                                if ((double)(Math.abs(random.nextInt()) % 100) < 100.0 * (-(1.0 / Math.sqrt(sweeping_edge + 1)) + 1.0)) {
                                    this.setStackSynchronize(executer, executer.getSkill((Skill)this).getStack() + 1);
                                    ((Player)container.getExecuter().getOriginal()).f_19853_.m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), WOMSounds.ENDERBLASTER_RELOAD, ((Player)container.getExecuter().getOriginal()).m_5720_(), 1.0f, 2.0f);
                                }
                            }
                        }
                        if (flag) {
                            if (((Player)container.getExecuter().getOriginal()).m_6067_()) {
                                container.getExecuter().playAnimationSynchronized(WOMAnimations.ENDERBLASTER_ONEHAND_SHOOT_LAYED, 0.0f);
                            } else {
                                container.getExecuter().playAnimationSynchronized(WOMAnimations.ENDERBLASTER_ONEHAND_SHOOT, 0.0f);
                            }
                        }
                    }
                    container.getDataManager().setDataSync(COOLDOWN, (Object)40, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    container.getDataManager().setDataSync(ZOOM, (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                } else if (((Player)container.getExecuter().getOriginal()).m_6117_()) {
                    ((Player)container.getExecuter().getOriginal()).m_6858_(false);
                    container.getDataManager().setDataSync(COOLDOWN, (Object)40, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
            }
        } else {
            if (!container.getExecuter().isLogicalClient()) {
                container.getExecuter().getSkill((Skill)this).getDataManager().setDataSync(COMBO, (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
            if (container.getExecuter().isLogicalClient()) {
                ClientEngine.getInstance().renderEngine.zoomOut(0);
            }
        }
    }
}

