/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.passive;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.UUID;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.gameasset.WOMAnimations;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class MeditationSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("294c9e0d-7a43-443a-a603-2dd838d9702e");
    public static final SkillDataManager.SkillDataKey<Integer> TIMER = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    protected static final SkillDataManager.SkillDataKey<Boolean> ACTIVE = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    protected static final SkillDataManager.SkillDataKey<Integer> DUREE = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    protected static final SkillDataManager.SkillDataKey<Integer> CYCLE = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    protected static final SkillDataManager.SkillDataKey<Integer> STAGE = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    public AttributeModifier meditation_speed = new AttributeModifier(EVENT_UUID, "meditation.meditation_speed", 0.0, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public MeditationSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        container.getDataManager().registerData(TIMER);
        container.getDataManager().registerData(ACTIVE);
        container.getDataManager().registerData(DUREE);
        container.getDataManager().registerData(CYCLE);
        container.getDataManager().registerData(STAGE);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(ACTIVE)).booleanValue() && (Integer)container.getDataManager().getDataValue(DUREE) == 0 && !event.getAnimation().equals((Object)WOMAnimations.MEDITATION_SITING) && !event.getAnimation().equals((Object)WOMAnimations.MEDITATION_BREATHING)) {
                if ((Integer)container.getDataManager().getDataValue(STAGE) != 0) {
                    container.getDataManager().setDataSync(ACTIVE, (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    container.getDataManager().setDataSync(DUREE, (Object)((Integer)container.getDataManager().getDataValue(TIMER) * 6), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                } else {
                    container.getDataManager().setDataSync(ACTIVE, (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                }
                container.getDataManager().setDataSync(TIMER, (Object)0, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                ((ServerPlayerPatch)container.getExecuter()).modifyLivingMotionByCurrentItem();
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(ACTIVE)).booleanValue() && (Integer)container.getDataManager().getDataValue(DUREE) > 0 && ((Integer)container.getDataManager().getDataValue(STAGE) == 1 || (Integer)container.getDataManager().getDataValue(STAGE) == 4)) {
                float attackDamage = event.getDamage();
                event.setDamage(attackDamage * 1.4f);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MODIFY_ATTACK_SPEED_EVENT, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(ACTIVE)).booleanValue() && (Integer)container.getDataManager().getDataValue(DUREE) > 0 && ((Integer)container.getDataManager().getDataValue(STAGE) == 2 || (Integer)container.getDataManager().getDataValue(STAGE) == 4)) {
                float attackSpeed = event.getAttackSpeed();
                event.setAttackSpeed(attackSpeed * 1.3f);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(ACTIVE)).booleanValue() && (Integer)container.getDataManager().getDataValue(DUREE) > 0 && ((Integer)container.getDataManager().getDataValue(STAGE) == 3 || (Integer)container.getDataManager().getDataValue(STAGE) == 4)) {
                event.setAmount(event.getAmount() * 0.5f);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_ATTACK_SPEED_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID);
        if (((Boolean)container.getDataManager().getDataValue(ACTIVE)).booleanValue() && (Integer)container.getDataManager().getDataValue(DUREE) > 0 && ((Integer)container.getDataManager().getDataValue(STAGE) == 3 || (Integer)container.getDataManager().getDataValue(STAGE) == 4)) {
            ((Player)container.getExecuter().getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19605_, ((Integer)container.getDataManager().getDataValue(DUREE)).intValue(), 0, true, false, false));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return (Integer)container.getDataManager().getDataValue(STAGE) > 0 || (Boolean)container.getDataManager().getDataValue(ACTIVE) != false && (Integer)container.getDataManager().getDataValue(DUREE) == 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, PoseStack poseStack, float x, float y) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)gui.getSlidingProgression(), 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getSkillTexture());
        if (((Boolean)container.getDataManager().getDataValue(ACTIVE)).booleanValue() && (Integer)container.getDataManager().getDataValue(DUREE) > 0) {
            switch ((Integer)container.getDataManager().getDataValue(STAGE)) {
                case 1: {
                    RenderSystem.m_157429_((float)1.0f, (float)0.3f, (float)0.3f, (float)1.0f);
                    break;
                }
                case 2: {
                    RenderSystem.m_157429_((float)0.3f, (float)0.9f, (float)0.9f, (float)1.0f);
                    break;
                }
                case 3: {
                    RenderSystem.m_157429_((float)0.9f, (float)0.9f, (float)0.3f, (float)1.0f);
                    break;
                }
                case 4: {
                    RenderSystem.m_157429_((float)0.9f, (float)0.2f, (float)0.9f, (float)1.0f);
                    break;
                }
                default: {
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
            GuiComponent.m_93160_((PoseStack)poseStack, (int)((int)x), (int)((int)y), (int)24, (int)24, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
            gui.font.m_92750_(poseStack, ((Integer)container.getDataManager().getDataValue(DUREE) / 20 / 60 / 10 == 0 ? "0" : "") + String.valueOf((Integer)container.getDataManager().getDataValue(DUREE) / 20 / 60) + ":" + ((Integer)container.getDataManager().getDataValue(DUREE) / 20 % 60 / 10 == 0 ? "0" : "") + String.valueOf((Integer)container.getDataManager().getDataValue(DUREE) / 20 % 60), x, y + 17.0f, 0xFFFFFF);
        } else {
            RenderSystem.m_157429_((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
            if ((Integer)container.getDataManager().getDataValue(TIMER) >= 6000) {
                RenderSystem.m_157429_((float)0.8f, (float)0.2f, (float)0.8f, (float)0.5f);
            } else if ((Integer)container.getDataManager().getDataValue(TIMER) >= 1200) {
                RenderSystem.m_157429_((float)0.7f, (float)0.7f, (float)0.3f, (float)0.5f);
            } else if ((Integer)container.getDataManager().getDataValue(TIMER) >= 800) {
                RenderSystem.m_157429_((float)0.3f, (float)0.7f, (float)0.7f, (float)0.5f);
            } else if ((Integer)container.getDataManager().getDataValue(TIMER) >= 400) {
                RenderSystem.m_157429_((float)0.8f, (float)0.3f, (float)0.3f, (float)0.5f);
            }
            GuiComponent.m_93160_((PoseStack)poseStack, (int)((int)x), (int)((int)y), (int)24, (int)24, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
            if ((Integer)container.getDataManager().getDataValue(TIMER) > 0) {
                gui.font.m_92750_(poseStack, ((Integer)container.getDataManager().getDataValue(TIMER) / 20 / 60 / 10 == 0 ? "0" : "") + String.valueOf((Integer)container.getDataManager().getDataValue(TIMER) / 20 / 60) + ":" + ((Integer)container.getDataManager().getDataValue(TIMER) / 20 % 60 / 10 == 0 ? "0" : "") + String.valueOf((Integer)container.getDataManager().getDataValue(TIMER) / 20 % 60), x, y + 17.0f, 0xFFFFFF);
            }
        }
        poseStack.m_85849_();
    }

    public void updateContainer(SkillContainer container) {
        if (((Player)container.getExecuter().getOriginal()).m_6047_()) {
            if (!container.getExecuter().isLogicalClient()) {
                if ((Integer)container.getDataManager().getDataValue(TIMER) < 40) {
                    container.getDataManager().setDataSync(TIMER, (Object)((Integer)container.getDataManager().getDataValue(TIMER) + 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
                if ((Integer)container.getDataManager().getDataValue(TIMER) >= 40) {
                    if ((Integer)container.getDataManager().getDataValue(STAGE) == 3 && (Integer)container.getDataManager().getDataValue(DUREE) > 0) {
                        ((Player)container.getExecuter().getOriginal()).m_21195_(MobEffects.f_19605_);
                    }
                    container.getDataManager().setDataSync(DUREE, (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    container.getDataManager().setDataSync(STAGE, (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    container.getDataManager().setDataSync(TIMER, (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    container.getDataManager().setDataSync(CYCLE, (Object)30, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    container.getDataManager().setDataSync(ACTIVE, (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    container.getExecuter().playAnimationSynchronized(WOMAnimations.MEDITATION_SITING, 0.0f);
                }
            }
        } else if (!container.getExecuter().isLogicalClient() && ((Boolean)container.getDataManager().getDataValue(ACTIVE)).booleanValue()) {
            if ((Integer)container.getDataManager().getDataValue(DUREE) == 0) {
                container.getDataManager().setDataSync(TIMER, (Object)((Integer)container.getDataManager().getDataValue(TIMER) + 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
            if ((Integer)container.getDataManager().getDataValue(TIMER) >= 6000 || (Integer)container.getDataManager().getDataValue(STAGE) == 4) {
                container.getDataManager().setDataSync(STAGE, (Object)4, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                ((ServerLevel)((Player)container.getExecuter().getOriginal()).f_19853_).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.0f, 1.0f), 1.0f), ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_() + 0.5, ((Player)container.getExecuter().getOriginal()).m_20189_(), 4, 0.6, 0.6, 0.6, 0.05);
            } else if ((Integer)container.getDataManager().getDataValue(TIMER) >= 1200 || (Integer)container.getDataManager().getDataValue(STAGE) == 3) {
                container.getDataManager().setDataSync(STAGE, (Object)3, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                ((ServerLevel)((Player)container.getExecuter().getOriginal()).f_19853_).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.4f), 1.0f), ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_() + 0.5, ((Player)container.getExecuter().getOriginal()).m_20189_(), 3, 0.6, 0.6, 0.6, 0.05);
            } else if ((Integer)container.getDataManager().getDataValue(TIMER) >= 800 || (Integer)container.getDataManager().getDataValue(STAGE) == 2) {
                container.getDataManager().setDataSync(STAGE, (Object)2, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                ((ServerLevel)((Player)container.getExecuter().getOriginal()).f_19853_).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 1.0f, 1.0f), 1.0f), ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_() + 0.5, ((Player)container.getExecuter().getOriginal()).m_20189_(), 2, 0.6, 0.6, 0.6, 0.05);
            } else if ((Integer)container.getDataManager().getDataValue(TIMER) >= 400 || (Integer)container.getDataManager().getDataValue(STAGE) == 1) {
                container.getDataManager().setDataSync(STAGE, (Object)1, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                ((ServerLevel)((Player)container.getExecuter().getOriginal()).f_19853_).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 1.0f), ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_() + 0.5, ((Player)container.getExecuter().getOriginal()).m_20189_(), 1, 0.6, 0.6, 0.6, 0.05);
            } else {
                container.getDataManager().setDataSync(STAGE, (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
        }
        if (!container.getExecuter().isLogicalClient()) {
            if ((Integer)container.getDataManager().getDataValue(DUREE) > 0) {
                if (!((Player)container.getExecuter().getOriginal()).m_6047_()) {
                    container.getDataManager().setDataSync(TIMER, (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
                container.getDataManager().setDataSync(DUREE, (Object)((Integer)container.getDataManager().getDataValue(DUREE) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                if ((Integer)container.getDataManager().getDataValue(DUREE) == 0) {
                    container.getDataManager().setDataSync(ACTIVE, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    container.getDataManager().setDataSync(STAGE, (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
            }
            if (((Boolean)container.getDataManager().getDataValue(ACTIVE)).booleanValue() && (Integer)container.getDataManager().getDataValue(DUREE) == 0) {
                if ((Integer)container.getDataManager().getDataValue(CYCLE) > 0) {
                    container.getDataManager().setDataSync(CYCLE, (Object)((Integer)container.getDataManager().getDataValue(CYCLE) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    if ((Integer)container.getDataManager().getDataValue(CYCLE) == 0) {
                        container.getExecuter().playAnimationSynchronized(WOMAnimations.MEDITATION_BREATHING, 0.0f);
                        container.getDataManager().setDataSync(CYCLE, (Object)80, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    }
                }
                if (((Player)container.getExecuter().getOriginal()).f_19787_ != ((Player)container.getExecuter().getOriginal()).f_19867_) {
                    if ((Integer)container.getDataManager().getDataValue(STAGE) != 0) {
                        container.getDataManager().setDataSync(ACTIVE, (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                        container.getDataManager().setDataSync(DUREE, (Object)((Integer)container.getDataManager().getDataValue(TIMER) * 6), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    } else {
                        container.getDataManager().setDataSync(ACTIVE, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    }
                    container.getDataManager().setDataSync(TIMER, (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    ((ServerPlayerPatch)container.getExecuter()).modifyLivingMotionByCurrentItem();
                }
            }
            if (((Boolean)container.getDataManager().getDataValue(ACTIVE)).booleanValue() && (Integer)container.getDataManager().getDataValue(DUREE) > 0 && ((Integer)container.getDataManager().getDataValue(STAGE) == 2 || (Integer)container.getDataManager().getDataValue(STAGE) == 4)) {
                ((Player)container.getExecuter().getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19596_, 5, 1, true, false, false));
            }
            if (((Boolean)container.getDataManager().getDataValue(ACTIVE)).booleanValue() && (Integer)container.getDataManager().getDataValue(DUREE) > 0 && ((Integer)container.getDataManager().getDataValue(STAGE) == 3 || (Integer)container.getDataManager().getDataValue(STAGE) == 4) && (Integer)container.getDataManager().getDataValue(CYCLE) > 0) {
                container.getDataManager().setDataSync(CYCLE, (Object)((Integer)container.getDataManager().getDataValue(CYCLE) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                if ((Integer)container.getDataManager().getDataValue(CYCLE) == 0) {
                    ((Player)container.getExecuter().getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19605_, 110, 0, true, false, false));
                    container.getDataManager().setDataSync(CYCLE, (Object)100, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
            }
        }
    }
}

