/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.guard;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.WOMColliders;
import reascer.wom.world.capabilities.item.WOMWeaponCategories;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.guard.GuardSkill;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.IndirectEpicFightDamageSource;
import yesman.epicfight.world.damagesource.SourceTag;
import yesman.epicfight.world.damagesource.SourceTags;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class PerfectBulwarkSkill
extends GuardSkill {
    private static final UUID EVENT_UUID = UUID.fromString("8665b153-4bc3-4480-adb4-96bdd66e35e6");
    private static final SkillDataManager.SkillDataKey<Boolean> PARRYING = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    private static final SkillDataManager.SkillDataKey<Integer> CHARGE = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    private static final SkillDataManager.SkillDataKey<Integer> COOLDOWN = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);

    public static GuardSkill.Builder createCounterAttackBuilder() {
        return GuardSkill.createGuardBuilder().addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.SWORD, (itemCap, playerpatch) -> itemCap.getStyle((LivingEntityPatch)playerpatch) == CapabilityItem.Styles.ONE_HAND ? Animations.SWORD_AUTO3 : (itemCap.getStyle((LivingEntityPatch)playerpatch) == CapabilityItem.Styles.OCHS ? WOMAnimations.HERRSCHER_TRANE : Animations.SWORD_DUAL_AUTO3)).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.LONGSWORD, (itemCap, playerpatch) -> Animations.LONGSWORD_DASH).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.TACHI, (itemCap, playerpatch) -> Animations.TACHI_DASH).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.SPEAR, (itemCap, playerpatch) -> Animations.SPEAR_DASH).addAdvancedGuardMotion((WeaponCategory)WOMWeaponCategories.AGONY, (itemCap, playerpatch) -> WOMAnimations.AGONY_CLAWSTRIKE).addAdvancedGuardMotion((WeaponCategory)WOMWeaponCategories.RUINE, (itemCap, playerpatch) -> WOMAnimations.RUINE_COUNTER).addAdvancedGuardMotion((WeaponCategory)WOMWeaponCategories.STAFF, (itemCap, playerpatch) -> WOMAnimations.STAFF_DASH).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.UCHIGATANA, (itemCap, playerpatch) -> WOMAnimations.KATANA_SHEATHED_DASH);
    }

    public PerfectBulwarkSkill(GuardSkill.Builder builder) {
        super(builder);
    }

    public void setPenalizer(float penalizer) {
        this.penalizer = penalizer;
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getDataManager().registerData(PARRYING);
        container.getDataManager().registerData(CHARGE);
        container.getDataManager().registerData(COOLDOWN);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, GuardSkill.EVENT_UUID, 1);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, GuardSkill.EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, GuardSkill.EVENT_UUID);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((LocalPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
            if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD) && (Integer)container.getDataManager().getDataValue(COOLDOWN) == 0) {
                ((LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
            if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD) && (Integer)container.getDataManager().getDataValue(COOLDOWN) == 0) {
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
                container.getDataManager().setDataSync(PARRYING, (Object)true, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            } else if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD) && ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().canBasicAttack() && (Integer)container.getDataManager().getDataValue(COOLDOWN) > 0) {
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19853_.m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_12031_, ((Player)container.getExecuter().getOriginal()).m_5720_(), 1.0f, 2.0f);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_STOP_EVENT, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(PARRYING)).booleanValue() && (Integer)container.getDataManager().getDataValue(CHARGE) >= 5) {
                container.getDataManager().setDataSync(PARRYING, (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                container.getDataManager().setDataSync(COOLDOWN, (Object)100, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
                StaticAnimation animation = switch (new Random().nextInt() % 3) {
                    case 0 -> Animations.SWORD_GUARD_ACTIVE_HIT1;
                    case 1 -> Animations.SWORD_GUARD_ACTIVE_HIT2;
                    case 2 -> Animations.SWORD_GUARD_ACTIVE_HIT3;
                    default -> Animations.SWORD_GUARD_ACTIVE_HIT1;
                };
                if (itemCapability.getStyle((LivingEntityPatch)event.getPlayerPatch()) == CapabilityItem.Styles.TWO_HAND) {
                    animation = new Random().nextBoolean() ? Animations.LONGSWORD_GUARD_ACTIVE_HIT1 : Animations.LONGSWORD_GUARD_ACTIVE_HIT2;
                }
                float convert = 0.15f;
                if (itemCapability.getWeaponCollider() == WOMColliders.AGONY) {
                    animation = WOMAnimations.AGONY_GUARD_HIT_1;
                }
                if (itemCapability.getWeaponCollider() == WOMColliders.RUINE) {
                    animation = Animations.LONGSWORD_GUARD_HIT;
                }
                if (itemCapability.getWeaponCollider() == WOMColliders.KATANA) {
                    animation = WOMAnimations.KATANA_GUARD_HIT;
                    convert = -0.05f;
                }
                if (itemCapability.getWeaponCollider() == WOMColliders.HERSCHER && itemCapability.getStyle((LivingEntityPatch)event.getPlayerPatch()) == CapabilityItem.Styles.OCHS) {
                    animation = WOMAnimations.HERRSCHER_GUARD_PARRY;
                }
                if (itemCapability.getWeaponCollider() == WOMColliders.MOONLESS) {
                    animation = WOMAnimations.MOONLESS_GUARD_HIT_1;
                }
                if (!((ServerPlayerPatch)event.getPlayerPatch()).consumeStamina(3.0f)) {
                    ((ServerPlayerPatch)event.getPlayerPatch()).setStamina(0.0f);
                }
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19853_.m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), EpicFightSounds.CLASH, ((Player)container.getExecuter().getOriginal()).m_5720_(), 1.0f, 0.5f);
                ((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123796_, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_() + 0.75, ((Player)container.getExecuter().getOriginal()).m_20189_(), 60, 0.0, 0.0, 0.0, 0.5);
                ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(animation, convert);
                AABB box = AABB.m_165882_((Vec3)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_(), (double)10.0, (double)5.0, (double)10.0);
                List list = ((Player)container.getExecuter().getOriginal()).f_19853_.m_45933_(container.getExecuter().getOriginal(), box);
                for (Entity entity : list) {
                    double power = 1.0;
                    double d1 = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_().m_7096_() - entity.m_20185_();
                    double d2 = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_().m_7098_() - 1.0 - entity.m_20186_();
                    double d0 = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_().m_7094_() - entity.m_20189_();
                    while (d1 * d1 + d0 * d0 < 1.0E-4) {
                        d1 = (Math.random() - Math.random()) * 0.01;
                        d0 = (Math.random() - Math.random()) * 0.01;
                    }
                    if (!(entity instanceof LivingEntity)) continue;
                    entity.f_19812_ = true;
                    Vec3 vec3 = entity.m_20184_();
                    Vec3 vec31 = new Vec3(d1, d2, d0).m_82541_().m_82490_(power *= 1.0 - ((LivingEntity)entity).m_21133_(Attributes.f_22278_));
                    IndirectEpicFightDamageSource damage = new IndirectEpicFightDamageSource("perfect_bulkwark_shockwave", container.getExecuter().getOriginal(), container.getExecuter().getOriginal(), StunType.LONG);
                    damage.setImpact(3.0f);
                    LivingEntity target = (LivingEntity)entity;
                    target.m_6469_((DamageSource)damage, (float)((Integer)container.getDataManager().getDataValue(CHARGE) * 2));
                    entity.m_20334_(vec3.f_82479_ / 2.0 - vec31.f_82479_, vec3.f_82480_ / 2.0 - vec31.f_82480_, vec3.f_82481_ / 2.0 - vec31.f_82481_);
                }
                container.getDataManager().setDataSync(CHARGE, (Object)0, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7655_());
            if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD) && ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6117_()) {
                container.getDataManager().setDataSync(CHARGE, (Object)(1 + (Integer)container.getDataManager().getDataValue(CHARGE)), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                if ((Integer)container.getDataManager().getDataValue(CHARGE) >= 5) {
                    ((ServerLevel)((Player)container.getExecuter().getOriginal()).f_19853_).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.8f, 0.75f, 0.65f), 1.0f), ((Player)container.getExecuter().getOriginal()).m_20185_() - 0.2, ((Player)container.getExecuter().getOriginal()).m_20186_() + 1.3, ((Player)container.getExecuter().getOriginal()).m_20189_() - 0.2, 30, 0.6, 0.8, 0.6, 0.05);
                }
                float impact = 0.5f;
                float knockback = 0.25f;
                Object patt12523$temp = event.getDamageSource();
                if (patt12523$temp instanceof EpicFightDamageSource) {
                    EpicFightDamageSource epicfightDamageSource = (EpicFightDamageSource)patt12523$temp;
                    if (epicfightDamageSource.hasTag((SourceTag)SourceTags.GUARD_PUNCTURE)) {
                        return;
                    }
                    impact = ((EpicFightDamageSource)event.getDamageSource()).getImpact();
                    knockback += Math.min(impact * 0.1f, 1.0f);
                }
                this.guard(container, itemCapability, (HurtEvent.Pre)event, knockback, impact, false);
            }
        }, 0);
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, 0);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_STOP_EVENT, EVENT_UUID);
        super.onRemoved(container);
    }

    public void guard(SkillContainer container, CapabilityItem itemCapability, HurtEvent.Pre event, float knockback, float impact, boolean advanced) {
        DamageSource damageSource = (DamageSource)event.getDamageSource();
        if (this.isBlockableSource(damageSource, advanced)) {
            ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19853_.m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), EpicFightSounds.CLASH, ((Player)container.getExecuter().getOriginal()).m_5720_(), 1.0f, 0.9f + 0.15f * (float)((Integer)container.getDataManager().getDataValue(CHARGE)).intValue());
            ServerPlayer serveerPlayer = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument((ServerLevel)serveerPlayer.f_19853_, HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)serveerPlayer, damageSource.m_7640_());
            if (damageSource.m_7640_() instanceof LivingEntity) {
                knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)((LivingEntity)damageSource.m_7640_())) * 0.1f;
            }
            float penalty = ((Float)container.getDataManager().getDataValue(PENALTY)).floatValue() + this.getPenalizer(itemCapability);
            ((ServerPlayerPatch)event.getPlayerPatch()).knockBackEntity(damageSource.m_7640_().m_20182_(), knockback);
            boolean enoughStamina = ((ServerPlayerPatch)event.getPlayerPatch()).consumeStamina(penalty * impact);
            container.getDataManager().setDataSync(PENALTY, (Object)Float.valueOf(penalty), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            GuardSkill.BlockType blockType = enoughStamina ? GuardSkill.BlockType.GUARD : GuardSkill.BlockType.GUARD_BREAK;
            StaticAnimation animation = this.getGuardMotion(event.getPlayerPatch(), itemCapability, blockType);
            if (animation != null) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(animation, 0.0f);
            }
            if (blockType == GuardSkill.BlockType.GUARD_BREAK) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playSound(EpicFightSounds.NEUTRALIZE_MOBS, 3.0f, 0.0f, 0.1f);
            }
            this.dealEvent(event.getPlayerPatch(), event, advanced);
        }
    }

    protected boolean isBlockableSource(DamageSource damageSource, boolean advanced) {
        return damageSource.m_19360_() && advanced || super.isBlockableSource(damageSource, false);
    }

    @Nullable
    protected StaticAnimation getGuardMotion(PlayerPatch<?> playerpatch, CapabilityItem itemCapability, GuardSkill.BlockType blockType) {
        if (blockType == GuardSkill.BlockType.GUARD) {
            if (itemCapability.getWeaponCollider() == WOMColliders.AGONY) {
                return new Random().nextBoolean() ? WOMAnimations.AGONY_GUARD_HIT_1 : WOMAnimations.AGONY_GUARD_HIT_2;
            }
            if (itemCapability.getWeaponCollider() == WOMColliders.KATANA) {
                return WOMAnimations.KATANA_GUARD_HIT;
            }
            if (itemCapability.getWeaponCollider() == WOMColliders.HERSCHER && itemCapability.getStyle(playerpatch) == CapabilityItem.Styles.OCHS) {
                return WOMAnimations.HERRSCHER_GUARD_HIT;
            }
            if (itemCapability.getWeaponCollider() == WOMColliders.MOONLESS) {
                switch (new Random().nextInt() % 3) {
                    case 0: {
                        return WOMAnimations.MOONLESS_GUARD_HIT_1;
                    }
                    case 1: {
                        return WOMAnimations.MOONLESS_GUARD_HIT_2;
                    }
                    case 2: {
                        return WOMAnimations.MOONLESS_GUARD_HIT_3;
                    }
                }
                return WOMAnimations.MOONLESS_GUARD_HIT_1;
            }
        }
        return super.getGuardMotion(playerpatch, itemCapability, blockType);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return (Integer)container.getDataManager().getDataValue(CHARGE) > 0 || (Integer)container.getDataManager().getDataValue(COOLDOWN) > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, PoseStack poseStack, float x, float y) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)gui.getSlidingProgression(), 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getSkillTexture());
        if ((Integer)container.getDataManager().getDataValue(COOLDOWN) > 0) {
            RenderSystem.m_157429_((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
        } else {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GuiComponent.m_93160_((PoseStack)poseStack, (int)((int)x), (int)((int)y), (int)24, (int)24, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
        String string = "";
        if ((Integer)container.getDataManager().getDataValue(COOLDOWN) > 0) {
            string = String.valueOf((Integer)container.getDataManager().getDataValue(COOLDOWN) / 20 + 1);
        } else {
            string = String.valueOf(container.getDataManager().getDataValue(CHARGE));
            if ((Integer)container.getDataManager().getDataValue(CHARGE) == 0) {
                string = "";
            }
        }
        gui.font.m_92750_(poseStack, string, x + 5.0f, y + 6.0f, 0xFFFFFF);
        poseStack.m_85849_();
    }

    public Skill getPriorSkill() {
        return EpicFightSkills.GUARD;
    }

    protected boolean isAdvancedGuard() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.clear();
        list.add(String.format("%s, %s, %s, %s, %s, %s, %s, %s", new Object[]{CapabilityItem.WeaponCategories.UCHIGATANA, CapabilityItem.WeaponCategories.LONGSWORD, CapabilityItem.WeaponCategories.SWORD, CapabilityItem.WeaponCategories.TACHI, CapabilityItem.WeaponCategories.SPEAR, WOMWeaponCategories.AGONY, WOMWeaponCategories.RUINE, WOMWeaponCategories.STAFF}).toLowerCase());
        return list;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if ((Integer)container.getDataManager().getDataValue(COOLDOWN) > 0) {
            container.getDataManager().setData(COOLDOWN, (Object)((Integer)container.getDataManager().getDataValue(COOLDOWN) - 1));
        }
    }
}

