/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.dodges;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.gameasset.WOMSkills;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.client.CPExecuteSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.dodge.DodgeSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillConsumeEvent;

public class EnderObscurisSkill
extends DodgeSkill {
    public static final SkillDataManager.SkillDataKey<Integer> TARGET_ID = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    private static final UUID EVENT_UUID = UUID.fromString("38cb04e1-9751-445f-82bd-fb61426a58c7");

    public EnderObscurisSkill(DodgeSkill.Builder builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getDataManager().registerData(TARGET_ID);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID, event -> container.getDataManager().setDataSync(TARGET_ID, (Object)event.getTarget().m_142049_(), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()));
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FriendlyByteBuf gatherArguments(LocalPlayerPatch executer, ControllEngine controllEngine) {
        int forward = controllEngine.isKeyDown(Minecraft.m_91087_().f_91066_.f_92085_) ? 1 : 0;
        int backward = controllEngine.isKeyDown(Minecraft.m_91087_().f_91066_.f_92087_) ? -1 : 0;
        int left = controllEngine.isKeyDown(Minecraft.m_91087_().f_91066_.f_92086_) ? 1 : 0;
        int right = controllEngine.isKeyDown(Minecraft.m_91087_().f_91066_.f_92088_) ? -1 : 0;
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(forward);
        buf.writeInt(backward);
        buf.writeInt(left);
        buf.writeInt(right);
        return buf;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(LocalPlayerPatch executer, FriendlyByteBuf args) {
        int degree;
        int forward = args.readInt();
        int backward = args.readInt();
        int left = args.readInt();
        int right = args.readInt();
        int vertic = forward + backward;
        int horizon = left + right;
        int n = degree = vertic == 0 ? 0 : -(90 * horizon * (1 - Math.abs(vertic)) + 45 * vertic * horizon);
        int animation = vertic == 0 ? (horizon == 0 ? 4 : (horizon >= 0 ? 2 : 3)) : (vertic >= 0 ? 0 : 1);
        CPExecuteSkill packet = new CPExecuteSkill(executer.getSkill((Skill)this).getSlotId());
        packet.getBuffer().writeInt(animation);
        packet.getBuffer().writeFloat((float)degree);
        return packet;
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        SkillConsumeEvent event = new SkillConsumeEvent((PlayerPatch)executer, (Skill)this, this.resource, true);
        executer.getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, (PlayerEvent)event);
        if (!event.isCanceled()) {
            event.getResourceType().consumer.consume((Skill)this, executer, event.getAmount());
        }
        executer.getSkill((Skill)this).activate();
        int i = args.readInt();
        float yaw = args.readFloat();
        boolean tag = false;
        LivingEntity target = (LivingEntity)((ServerPlayer)executer.getOriginal()).f_19853_.m_6815_(((Integer)executer.getSkill((Skill)this).getDataManager().getDataValue(TARGET_ID)).intValue());
        if (target != null) {
            if (target.m_20270_(executer.getOriginal()) < 30.0f) {
                tag = true;
            }
            if (!tag) {
                i = 1;
            }
        }
        executer.playAnimationSynchronized(this.animations[i], 0.0f);
        executer.changeModelYRot(yaw);
    }

    public Skill getPriorSkill() {
        return WOMSkills.ENDERSTEP;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        LivingEntity target = (LivingEntity)((Player)container.getExecuter().getOriginal()).f_19853_.m_6815_(((Integer)container.getDataManager().getDataValue(TARGET_ID)).intValue());
        boolean tag = false;
        if (target != null && target.m_20270_(container.getExecuter().getOriginal()) < 30.0f) {
            tag = true;
        }
        return tag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, PoseStack poseStack, float x, float y) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)gui.getSlidingProgression(), 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getSkillTexture());
        GuiComponent.m_93160_((PoseStack)poseStack, (int)((int)x), (int)((int)y), (int)24, (int)24, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
        poseStack.m_85849_();
    }

    public void updateContainer(SkillContainer container) {
        Entity target;
        super.updateContainer(container);
        if (!container.getExecuter().isLogicalClient() && container.getDataManager().getDataValue(TARGET_ID) != null && (target = ((Player)container.getExecuter().getOriginal()).f_19853_.m_6815_(((Integer)container.getDataManager().getDataValue(TARGET_ID)).intValue())) != null && target instanceof LivingEntity && ((LivingEntity)target).m_21224_()) {
            container.getDataManager().setDataSync(TARGET_ID, (Object)-1, (ServerPlayer)container.getExecuter().getOriginal());
        }
    }
}

