/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.client.model.layers;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WOMModelLayers {
    private static final String DEFAULT_LAYER = "main";
    private static final Set<ModelLayerLocation> ALL_MODELS = Sets.newHashSet();
    public static final ModelLayerLocation EnderBlast = WOMModelLayers.register("enderbullet");

    private static ModelLayerLocation register(String p_171294_) {
        return WOMModelLayers.register(p_171294_, "Entity");
    }

    private static ModelLayerLocation register(String p_171296_, String p_171297_) {
        ModelLayerLocation modellayerlocation = WOMModelLayers.createLocation(p_171296_, p_171297_);
        if (!ALL_MODELS.add(modellayerlocation)) {
            throw new IllegalStateException("Duplicate registration for " + modellayerlocation);
        }
        return modellayerlocation;
    }

    private static ModelLayerLocation createLocation(String p_171301_, String p_171302_) {
        return new ModelLayerLocation(new ResourceLocation("wom", p_171301_), p_171302_);
    }

    private static ModelLayerLocation registerInnerArmor(String p_171299_) {
        return WOMModelLayers.register(p_171299_, "inner_armor");
    }

    private static ModelLayerLocation registerOuterArmor(String p_171304_) {
        return WOMModelLayers.register(p_171304_, "outer_armor");
    }

    public static ModelLayerLocation createBoatModelName(Boat.Type p_171290_) {
        return WOMModelLayers.createLocation("boat/" + p_171290_.m_38429_(), DEFAULT_LAYER);
    }

    public static ModelLayerLocation createSignModelName(WoodType p_171292_) {
        ResourceLocation location = new ResourceLocation(p_171292_.m_61846_());
        return new ModelLayerLocation(new ResourceLocation(location.m_135827_(), "sign/" + location.m_135815_()), DEFAULT_LAYER);
    }

    public static Stream<ModelLayerLocation> getKnownLocations() {
        return ALL_MODELS.stream();
    }
}

