/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.damagesource;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.world.damagesource.DamageSourceElements;
import yesman.epicfight.world.damagesource.EpicFightEntityDamageSource;
import yesman.epicfight.world.damagesource.ExtraDamageInstance;
import yesman.epicfight.world.damagesource.SourceTag;
import yesman.epicfight.world.damagesource.StunType;

public interface EpicFightDamageSource {
    public static EpicFightDamageSource commonEntityDamageSource(String msg, LivingEntity owner, StaticAnimation animation) {
        return new EpicFightEntityDamageSource(msg, (Entity)owner, animation);
    }

    public DamageSourceElements getDamageSourceElements();

    default public EpicFightDamageSource setHurtItem(ItemStack hurtItem) {
        this.getDamageSourceElements().hurtItem = hurtItem;
        return this;
    }

    default public ItemStack getHurtItem() {
        return this.getDamageSourceElements().hurtItem;
    }

    default public EpicFightDamageSource setDamageModifier(ValueModifier damageModifier) {
        this.getDamageSourceElements().damageModifier = damageModifier;
        return this;
    }

    default public ValueModifier getDamageModifier() {
        return this.getDamageSourceElements().damageModifier;
    }

    default public EpicFightDamageSource setImpact(float f) {
        this.getDamageSourceElements().impact = f;
        return this;
    }

    default public float getImpact() {
        return this.getDamageSourceElements().impact;
    }

    default public EpicFightDamageSource setArmorNegation(float f) {
        this.getDamageSourceElements().armorNegation = f;
        return this;
    }

    default public float getArmorNegation() {
        return this.getDamageSourceElements().armorNegation;
    }

    default public EpicFightDamageSource setStunType(StunType stunType) {
        this.getDamageSourceElements().stunType = stunType;
        return this;
    }

    default public StunType getStunType() {
        return this.getDamageSourceElements().stunType;
    }

    default public EpicFightDamageSource addTag(SourceTag tag) {
        if (this.getDamageSourceElements().sourceTag == null) {
            this.getDamageSourceElements().sourceTag = Sets.newHashSet();
        }
        this.getDamageSourceElements().sourceTag.add(tag);
        return this;
    }

    default public boolean hasTag(SourceTag tag) {
        Set<SourceTag> tags = this.getDamageSourceElements().sourceTag;
        if (tags != null) {
            return tags.contains(tag);
        }
        return false;
    }

    default public EpicFightDamageSource addExtraDamage(ExtraDamageInstance extraDamage) {
        if (this.getDamageSourceElements().extraDamages == null) {
            this.getDamageSourceElements().extraDamages = Sets.newHashSet();
        }
        this.getDamageSourceElements().extraDamages.add(extraDamage);
        return this;
    }

    default public Set<ExtraDamageInstance> getExtraDamages() {
        return this.getDamageSourceElements().extraDamages;
    }

    default public DamageSource cast() {
        return (DamageSource)this;
    }

    public EpicFightDamageSource setInitialPosition(Vec3 var1);

    public Vec3 getInitialPosition();

    public boolean isBasicAttack();

    public StaticAnimation getAnimation();
}

