/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.projectile;

import java.util.Map;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.RangedWeaponCapability;
import yesman.epicfight.world.damagesource.IndirectEpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public abstract class ProjectilePatch<T extends Projectile>
extends EntityPatch<T> {
    protected float impact;
    protected float armorNegation;
    protected Vec3 initialFirePosition;

    @Override
    public void onJoinWorld(T projectileEntity, EntityJoinWorldEvent event) {
        Entity shooter = projectileEntity.m_37282_();
        boolean flag = true;
        if (shooter != null && shooter instanceof LivingEntity) {
            this.initialFirePosition = shooter.m_20182_();
            LivingEntity livingshooter = (LivingEntity)shooter;
            ItemStack heldItem = livingshooter.m_21205_();
            CapabilityItem itemCap = EpicFightCapabilities.getItemStackCapability(heldItem);
            if (itemCap instanceof RangedWeaponCapability) {
                Map<Attribute, AttributeModifier> modifierMap = itemCap.getDamageAttributesInCondition(CapabilityItem.Styles.RANGED);
                if (modifierMap != null) {
                    this.armorNegation = modifierMap.containsKey(EpicFightAttributes.ARMOR_NEGATION.get()) ? (float)modifierMap.get(EpicFightAttributes.ARMOR_NEGATION.get()).m_22218_() : (float)((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).m_22082_();
                    float f = this.impact = modifierMap.containsKey(EpicFightAttributes.IMPACT.get()) ? (float)modifierMap.get(EpicFightAttributes.IMPACT.get()).m_22218_() : (float)((Attribute)EpicFightAttributes.IMPACT.get()).m_22082_();
                    if (modifierMap.containsKey(EpicFightAttributes.MAX_STRIKES.get())) {
                        this.setMaxStrikes(projectileEntity, (int)modifierMap.get(EpicFightAttributes.MAX_STRIKES.get()).m_22218_());
                    }
                }
                flag = false;
            }
        }
        if (flag) {
            this.armorNegation = 0.0f;
            this.impact = 0.0f;
        }
    }

    @Override
    public final void tick(LivingEvent.LivingUpdateEvent event) {
    }

    @Override
    protected final void clientTick(LivingEvent.LivingUpdateEvent event) {
    }

    @Override
    protected final void serverTick(LivingEvent.LivingUpdateEvent event) {
    }

    public boolean onProjectileImpact(ProjectileImpactEvent event) {
        return false;
    }

    protected abstract void setMaxStrikes(T var1, int var2);

    public IndirectEpicFightDamageSource getEpicFightDamageSource(DamageSource original) {
        IndirectEpicFightDamageSource extSource = new IndirectEpicFightDamageSource(original.f_19326_, original.m_7639_(), original.m_7640_(), StunType.SHORT);
        extSource.m_19366_();
        extSource.setArmorNegation(this.armorNegation);
        extSource.setImpact(this.impact);
        extSource.setInitialPosition(this.initialFirePosition);
        return extSource;
    }

    @Override
    public boolean overrideRender() {
        return false;
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        return null;
    }
}

