/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.passive;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;

public abstract class PassiveSkill
extends Skill {
    private final Map<Attribute, AttributeModifier> passiveStats = Maps.newHashMap();

    public static Skill.Builder<PassiveSkill> createPassiveBuilder() {
        return new Skill.Builder().setCategory(SkillCategories.PASSIVE).setResource(Skill.Resource.NONE);
    }

    public PassiveSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.passiveStats.clear();
        if (parameters.m_128441_("attribute_modifiers")) {
            ListTag attributeList = parameters.m_128437_("attribute_modifiers", 10);
            for (Tag tag : attributeList) {
                CompoundTag comp = (CompoundTag)tag;
                String attribute = comp.m_128461_("attribute");
                Attribute attr = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(attribute));
                AttributeModifier modifier = ParseUtil.toAttributeModifier(comp);
                this.passiveStats.put(attr, modifier);
            }
        }
    }

    @Override
    public void onInitiate(SkillContainer container) {
        for (Map.Entry<Attribute, AttributeModifier> stat : this.passiveStats.entrySet()) {
            AttributeInstance attr = ((Player)container.getExecuter().getOriginal()).m_21051_(stat.getKey());
            if (attr.m_22109_(stat.getValue())) continue;
            attr.m_22118_(stat.getValue());
        }
    }

    @Override
    public void onRemoved(SkillContainer container) {
        for (Map.Entry<Attribute, AttributeModifier> stat : this.passiveStats.entrySet()) {
            AttributeInstance attr = ((Player)container.getExecuter().getOriginal()).m_21051_(stat.getKey());
            if (!attr.m_22109_(stat.getValue())) continue;
            attr.m_22130_(stat.getValue());
        }
    }

    public Set<Map.Entry<Attribute, AttributeModifier>> getModfierEntry() {
        return this.passiveStats.entrySet();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, PoseStack poseStack, float x, float y) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)gui.getSlidingProgression(), 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getSkillTexture());
        GuiComponent.m_93160_((PoseStack)poseStack, (int)((int)x), (int)((int)y), (int)24, (int)24, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
        String remainTime = String.format("%.0f", Float.valueOf(container.getMaxResource() - container.getResource()));
        gui.font.m_92750_(poseStack, remainTime, x + 12.0f - (float)(4 * remainTime.length()), y + 6.0f, 0xFFFFFF);
        poseStack.m_85849_();
    }
}

