/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.mover;

import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.LevelUtil;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPPlayAnimation;
import yesman.epicfight.network.server.SPSkillExecutionFeedback;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.ChargeableSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class DemolitionLeapSkill
extends Skill
implements ChargeableSkill {
    private static final SkillDataManager.SkillDataKey<Boolean> PROTECT_NEXT_FALL = SkillDataManager.SkillDataKey.createDataKey(SkillDataManager.ValueType.BOOLEAN);
    private static final UUID EVENT_UUID = UUID.fromString("3d142bf4-0dcd-11ee-be56-0242ac120002");
    private StaticAnimation chargingAnimation = Animations.BIPED_DEMOLITION_LEAP_CHARGING;
    private StaticAnimation shootAnimation = Animations.BIPED_DEMOLITION_LEAP;

    public DemolitionLeapSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        container.getDataManager().registerData(PROTECT_NEXT_FALL);
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            if (((LocalPlayerPatch)event.getPlayerPatch()).isChargingSkill(this)) {
                event.getMovementInput().f_108572_ = false;
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            if (((DamageSource)event.getDamageSource()).m_146707_() && container.getDataManager().getDataValue(PROTECT_NEXT_FALL).booleanValue()) {
                float damage = event.getAmount();
                event.setAmount(damage * 0.5f);
                event.setCanceled(true);
                container.getDataManager().setData(PROTECT_NEXT_FALL, false);
            }
        }, 1);
        listener.addEventListener(PlayerEventListener.EventType.FALL_EVENT, EVENT_UUID, event -> container.getDataManager().setData(PROTECT_NEXT_FALL, false));
    }

    @Override
    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, 1);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.FALL_EVENT, EVENT_UUID);
    }

    @Override
    public boolean isExecutableState(PlayerPatch<?> executer) {
        return super.isExecutableState(executer) && ((Player)executer.getOriginal()).m_20096_();
    }

    @Override
    public void cancelOnClient(LocalPlayerPatch executer, FriendlyByteBuf args) {
        super.cancelOnClient(executer, args);
        executer.resetSkillCharging();
        executer.playAnimationSynchronized(Animations.BIPED_IDLE, 0.0f);
    }

    @Override
    public void executeOnClient(LocalPlayerPatch executer, FriendlyByteBuf args) {
        args.readInt();
        int ticks = args.readInt();
        int modifiedTicks = (int)((double)7.4668f * Math.log10((float)ticks + 1.0f) / Math.log10(2.0));
        Vec3f jumpDirection = new Vec3f(0.0f, (float)modifiedTicks * 0.05f, 0.0f);
        float xRot = Mth.m_14036_((float)(70.0f + Mth.m_14036_((float)executer.getCameraXRot(), (float)-90.0f, (float)0.0f)), (float)0.0f, (float)70.0f);
        jumpDirection.add(0.0f, xRot / 70.0f * 0.05f, 0.0f);
        jumpDirection.rotate(xRot, Vec3f.X_AXIS);
        jumpDirection.rotate(-executer.getCameraYRot(), Vec3f.Y_AXIS);
        ((LocalPlayer)executer.getOriginal()).m_20256_(jumpDirection.toDoubleVector());
        executer.resetSkillCharging();
    }

    @Override
    public void gatherChargingArguemtns(LocalPlayerPatch caster, ControllEngine controllEngine, FriendlyByteBuf buffer) {
        controllEngine.setChargingKey(SkillSlots.MOVER, this.getKeyMapping());
        caster.startSkillCharging(this);
    }

    @Override
    public void startCharging(PlayerPatch<?> caster) {
        ((Animator)caster.getAnimator()).playAnimation(this.chargingAnimation, 0.0f);
        if (!caster.isLogicalClient()) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPPlayAnimation(this.chargingAnimation, 0.0f, caster), caster.getOriginal());
        }
    }

    @Override
    public void resetCharging(PlayerPatch<?> caster) {
    }

    @Override
    public void castSkill(ServerPlayerPatch caster, SkillContainer skillContainer, int chargingTicks, SPSkillExecutionFeedback feedbackPacket, boolean onMaxTick) {
        if (onMaxTick) {
            feedbackPacket.setFeedbackType(SPSkillExecutionFeedback.FeedbackType.EXPIRED);
        } else {
            caster.playSound(EpicFightSounds.ROCKET_JUMP, 1.0f, 0.0f, 0.0f);
            caster.playSound(EpicFightSounds.ENTITY_MOVE, 1.0f, 0.0f, 0.0f);
            int accumulatedTicks = caster.getChargingAmount();
            LevelUtil.circleSlamFracture(null, ((ServerPlayer)caster.getOriginal()).f_19853_, ((ServerPlayer)caster.getOriginal()).m_20182_().m_82492_(0.0, 1.0, 0.0), (double)accumulatedTicks * 0.05, true, false, false);
            Vec3 entityEyepos = ((ServerPlayer)caster.getOriginal()).m_146892_();
            ((HitParticleType)((Object)EpicFightParticles.AIR_BURST.get())).spawnParticleWithArgument(((ServerPlayer)caster.getOriginal()).m_183503_(), entityEyepos.f_82479_, entityEyepos.f_82480_, entityEyepos.f_82481_, 0.0, 0.0, 2.0 + 0.05 * (double)chargingTicks);
            caster.playAnimationSynchronized(this.shootAnimation, 0.0f);
            feedbackPacket.getBuffer().writeInt(accumulatedTicks);
            skillContainer.getDataManager().setData(PROTECT_NEXT_FALL, true);
        }
    }

    @Override
    public int getAllowedMaxChargingTicks() {
        return 80;
    }

    @Override
    public int getMaxChargingTicks() {
        return 40;
    }

    @Override
    public int getMinChargingTicks() {
        return 12;
    }

    @Override
    public KeyMapping getKeyMapping() {
        return EpicFightKeyMappings.MOVER_SKILL;
    }

    @Override
    public void chargingTick(PlayerPatch<?> caster) {
        int chargingTicks = caster.getSkillChargingTicks();
        if (chargingTicks % 5 == 0 && caster.getAccumulatedChargeAmount() < this.getMaxChargingTicks() && caster.consumeStamina(this.consumption)) {
            caster.setChargingAmount(caster.getChargingAmount() + 5);
        }
    }
}

