/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.identity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class RevelationSkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("31a396ea-0361-11ee-be56-0242ac120002");
    protected static final SkillDataManager.SkillDataKey<Integer> STACKS = SkillDataManager.SkillDataKey.createDataKey(SkillDataManager.ValueType.INTEGER);
    protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, StaticAnimation>> motions;
    protected final Map<EntityType<?>, Integer> maxRevelationStacks = Maps.newHashMap();
    protected int blockStack;
    protected int parryStack;
    protected int dodgeStack;
    protected int defaultRevelationStacks;

    public static Builder createRevelationSkillBuilder() {
        return new Builder().setCategory(SkillCategories.IDENTITY).setActivateType(Skill.ActivateType.DURATION).setResource(Skill.Resource.NONE).addMotion(CapabilityItem.WeaponCategories.LONGSWORD, (item, player) -> Animations.REVELATION_TWOHAND).addMotion(CapabilityItem.WeaponCategories.GREATSWORD, (item, player) -> Animations.REVELATION_TWOHAND).addMotion(CapabilityItem.WeaponCategories.TACHI, (item, player) -> Animations.REVELATION_TWOHAND);
    }

    public RevelationSkill(Builder builder) {
        super(builder);
        this.motions = builder.motions;
    }

    @Override
    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.maxRevelationStacks.clear();
        this.blockStack = parameters.m_128451_("block_stacks");
        this.parryStack = parameters.m_128451_("parry_stacks");
        this.dodgeStack = parameters.m_128451_("dodge_stacks");
        this.defaultRevelationStacks = parameters.m_128451_("default_revelation_stacks");
        CompoundTag maxStacks = parameters.m_128469_("max_revelations");
        for (String registryName : maxStacks.m_128431_()) {
            EntityType entityType = EntityType.m_20632_((String)registryName).orElse(null);
            if (entityType != null) {
                this.maxRevelationStacks.put(entityType, maxStacks.m_128451_(registryName));
                continue;
            }
            EpicFightMod.LOGGER.warn("Revelation registry error: no entity type named : " + registryName);
        }
    }

    @Override
    public void onInitiate(SkillContainer container) {
        container.getDataManager().registerData(STACKS);
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.SKILL_EXECUTE_EVENT, EVENT_UUID, event -> {
            if (container.getExecuter().isLogicalClient()) {
                LivingEntityPatch entitypatch;
                Skill skill = event.getSkillContainer().getSkill();
                if (skill.getCategory() != SkillCategories.WEAPON_INNATE) {
                    return;
                }
                if (container.getExecuter().getTarget() != null && (entitypatch = EpicFightCapabilities.getEntityPatch((Entity)container.getExecuter().getTarget(), LivingEntityPatch.class)) != null && container.isActivated() && container.sendExecuteRequest((LocalPlayerPatch)container.getExecuter(), ClientEngine.getInstance().controllEngine).isExecutable()) {
                    container.setDuration(0);
                    event.setCanceled(true);
                }
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.SET_TARGET_EVENT, EVENT_UUID, event -> container.getDataManager().setDataSync(STACKS, Integer.valueOf(0), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()));
        listener.addEventListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, EVENT_UUID, event -> {
            LivingEntity target = container.getExecuter().getTarget();
            if (target != null && target.m_7306_(event.getDamageSource().m_7640_())) {
                this.checkStackAndActivate(container, (ServerPlayerPatch)event.getPlayerPatch(), target, container.getDataManager().getDataValue(STACKS), this.dodgeStack);
            }
        }, -1);
        listener.addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            LivingEntity target;
            if (event.getResult() == AttackResult.ResultType.BLOCKED && (target = container.getExecuter().getTarget()) != null && target.m_7306_(((DamageSource)event.getDamageSource()).m_7640_())) {
                int stacks = event.isParried() ? this.parryStack : this.blockStack;
                this.checkStackAndActivate(container, (ServerPlayerPatch)event.getPlayerPatch(), target, container.getDataManager().getDataValue(STACKS), stacks);
            }
        }, -1);
        listener.addEventListener(PlayerEventListener.EventType.TARGET_INDICATOR_ALERT_CHECK_EVENT, EVENT_UUID, event -> {
            if (container.isActivated()) {
                event.setCanceled(false);
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SKILL_EXECUTE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SET_TARGET_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.TARGET_INDICATOR_ALERT_CHECK_EVENT, EVENT_UUID);
    }

    @Override
    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        super.executeOnServer(executer, args);
        CapabilityItem holdingItem = executer.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        StaticAnimation animation = this.motions.containsKey(holdingItem.getWeaponCategory()) ? this.motions.get(holdingItem.getWeaponCategory()).apply(holdingItem, executer) : Animations.REVELATION_ONEHAND;
        executer.playAnimationSynchronized(animation, 0.0f);
    }

    public void checkStackAndActivate(SkillContainer container, ServerPlayerPatch playerpatch, LivingEntity target, int stacks, int addStacks) {
        int plusStack = stacks + addStacks;
        int maxStackSize = this.maxRevelationStacks.getOrDefault(target.m_6095_(), this.defaultRevelationStacks);
        if (plusStack < maxStackSize) {
            container.getDataManager().setDataSync(STACKS, Integer.valueOf(plusStack), (ServerPlayer)playerpatch.getOriginal());
        } else {
            if (!container.isActivated()) {
                this.setDurationSynchronize(playerpatch, this.maxDuration);
            }
            container.getDataManager().setDataSync(STACKS, Integer.valueOf(0), (ServerPlayer)playerpatch.getOriginal());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return container.getExecuter().getTarget() != null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, PoseStack poseStack, float x, float y) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)gui.getSlidingProgression(), 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getSkillTexture());
        GuiComponent.m_93160_((PoseStack)poseStack, (int)((int)x), (int)((int)y), (int)24, (int)24, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
        int stacks = container.getRemainDuration() > 0 ? 0 : this.maxRevelationStacks.getOrDefault(container.getExecuter().getTarget().m_6095_(), this.defaultRevelationStacks) - container.getDataManager().getDataValue(STACKS);
        gui.font.m_92750_(poseStack, String.format("%d", stacks), x + 18.0f, y + 14.0f, 0xFFFFFF);
        poseStack.m_85849_();
    }

    public static class Builder
    extends Skill.Builder<RevelationSkill> {
        protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, StaticAnimation>> motions = Maps.newHashMap();

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCreativeTab(CreativeModeTab tab) {
            this.tab = tab;
            return this;
        }

        public Builder addMotion(WeaponCategory weaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, StaticAnimation> function) {
            this.motions.put(weaponCategory, function);
            return this;
        }
    }
}

